/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.common;

import biz.elabor.prebilling.common.BasicServiceStatus;
import biz.elabor.prebilling.common.dao.BasicMisureDao;
import biz.elabor.prebilling.common.model.Applicazione;
import biz.elabor.prebilling.common.model.Contratto;
import biz.elabor.prebilling.common.model.TipoTrattamento;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.homelinux.elabor.calendar.CalendarTools;
import org.homelinux.elabor.calendar.Month;

public class TariffeCommonHelper {
    public static List<Applicazione> getSubapplicazioni(Applicazione applicazione, int anno, Month mese, BasicServiceStatus status, BasicMisureDao dao) {
        List<Applicazione> subapplicazioni = status.getSubapplicazioni(applicazione, anno, mese);
        if (subapplicazioni == null) {
            subapplicazioni = new ArrayList<Applicazione>();
            List<Integer> tipiSubapp = dao.getSubapplicazioni(applicazione, anno, mese);
            String reseller = applicazione.getReseller();
            for (Integer tipoSubapp : tipiSubapp) {
                Applicazione subapplicazione = status.getApplicazione(reseller, tipoSubapp);
                subapplicazioni.add(subapplicazione);
            }
            status.setSubapplicazioni(applicazione, anno, mese, subapplicazioni);
        }
        return subapplicazioni;
    }

    public static boolean checkTrattamento(Contratto contratto, int anno, Month mese, Applicazione applicazione, TipoTrattamento tipoTrattamento) {
        Date inizioMese = CalendarTools.getDate(anno, mese, 1);
        return TariffeCommonHelper.checkTrattamento(contratto, inizioMese, applicazione, tipoTrattamento);
    }

    public static boolean checkTrattamento(Contratto contratto, Date inizioMese, Applicazione applicazione, TipoTrattamento tipoTrattamento) {
        boolean regime = contratto.isRegime(inizioMese);
        return TariffeCommonHelper.checkTrattamentoContratto(tipoTrattamento, regime) && TariffeCommonHelper.checkTrattamentoApplicazione(applicazione, regime);
    }

    private static boolean checkTrattamentoContratto(TipoTrattamento tipoTrattamento, boolean regime) {
        return tipoTrattamento.checkRegime(regime);
    }

    private static boolean checkTrattamentoApplicazione(Applicazione applicazione, boolean regime) {
        TipoTrattamento tipoTrattamento = applicazione.getTipoTrattamento();
        return tipoTrattamento.checkRegime(regime);
    }
}

