/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.common.dao;

import biz.elabor.prebilling.common.dao.BasicRecordCreatorHelper;
import biz.elabor.prebilling.common.model.RegimeContratto;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DateFormat;
import java.util.Date;
import org.homelinux.elabor.db.RecordCreator;

public class RegimeContrattoCreator
implements RecordCreator<RegimeContratto> {
    private final DateFormat dateFormat;
    private final boolean modello;

    public RegimeContrattoCreator(boolean modello) {
        this.modello = modello;
        this.dateFormat = BasicRecordCreatorHelper.getDateFormat();
    }

    @Override
    public RegimeContratto createRecord(ResultSet rs) throws SQLException {
        String codice = rs.getString("cdprerif").trim();
        String azienda = rs.getString("cdazirif").trim();
        Date dataInizio = BasicRecordCreatorHelper.getDate(rs, "inizio", this.dateFormat);
        Date dataSospensione = BasicRecordCreatorHelper.getDate(rs, "dtsospen", this.dateFormat);
        String cdconmag = this.modello ? rs.getString("cdconmag").trim() : null;
        Date dataFirstRegime = BasicRecordCreatorHelper.getDate(rs, "data_att", this.dateFormat);
        return new RegimeContratto(codice, azienda, dataInizio, dataSospensione, dataFirstRegime, cdconmag);
    }
}

