/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.common.model;

import biz.elabor.prebilling.common.dao.MultipuntoOption;
import biz.elabor.prebilling.common.model.Contratto;
import biz.elabor.prebilling.common.model.TipoFlatManager;
import biz.elabor.prebilling.common.model.TipoFlatVisitor;
import java.util.List;
import org.homelinux.elabor.tools.MathUtils;
import org.homelinux.elabor.tools.StringUtils;

class ResiduoNegativoMinoritarioManager
implements TipoFlatManager {
    ResiduoNegativoMinoritarioManager() {
    }

    @Override
    public double getConsumoEfficace(double consumoReale, double consumoFlat, double emtaruni, double cdindneg) {
        return Math.min(0.0, consumoReale - consumoFlat);
    }

    @Override
    public double getConsumoTariffa(double consumoReale, double consumoEfficace) {
        return consumoEfficace;
    }

    @Override
    public double getPrezzo(double reale, double flat, double spread, double consumoReale, double consumoFlat) {
        return consumoReale < consumoFlat && reale < flat ? reale : 0.0;
    }

    @Override
    public double getConsumoTotale(double reale, double flat) {
        return reale;
    }

    @Override
    public double getQtMisura(double valoreEffettivo, double valore) {
        return valore;
    }

    @Override
    public boolean isSpread() {
        return false;
    }

    @Override
    public double getPrezzoGiornoSpread(double emspread, double emspreneg) {
        return emspread;
    }

    @Override
    public String getCodiceIndiceEnergetico(Contratto contratto) {
        return contratto.getCdindneg();
    }

    @Override
    public boolean isMissingSbil(Contratto contratto) {
        String cdindneg = contratto.getCdindneg();
        return StringUtils.isEmpty(cdindneg) || cdindneg.equals("0");
    }

    @Override
    public boolean isApplicable(double consumoReale) {
        return consumoReale > 0.0;
    }

    @Override
    public boolean isFixing() {
        return false;
    }

    @Override
    public double getCostoGiorno(double consumo, double prezzoGiorno, double costoGiornoFlat, int nCifre) {
        return MathUtils.round(consumo * prezzoGiorno, nCifre);
    }

    @Override
    public double getEmspread(Contratto contratto, double consumoTotaleFixingSwap, List<MultipuntoOption> opzioniFixingSwap) {
        return contratto.getEmspread();
    }

    @Override
    public void accept(TipoFlatVisitor visitor) {
        visitor.visitResiduoNegativoMinoritario();
    }
}

