/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.gas.config;

import biz.elabor.prebilling.gas.Funzionalita;
import biz.elabor.prebilling.gas.config.PrebillingGasConfiguration;
import java.io.File;
import org.homelinux.elabor.file.PatternFileFilter;

public class ConfigurationHelper {
    private static final String IMPORT = "import";
    private static final String PCS = "pcs";
    private static final String TARIFFE = "tariffe";
    private static final String RESELLER = "reseller";

    public static File getExecutionTmpFolder(PrebillingGasConfiguration configuration, String idEsecuzione) {
        File tmpFolder = configuration.getTmpFolder();
        return new File(tmpFolder, idEsecuzione);
    }

    public static File getTmpFolder(PrebillingGasConfiguration configuration, String idEsecuzione, Funzionalita funzionalita) {
        File executionTmpFolder = ConfigurationHelper.getExecutionTmpFolder(configuration, idEsecuzione);
        return new File(executionTmpFolder, funzionalita.name().toLowerCase());
    }

    public static File getFolder(PrebillingGasConfiguration configuration) {
        return configuration.getCodaFolder();
    }

    public static File getResellerTmpFolder(PrebillingGasConfiguration configuration, String idEsecuzione, String azienda, Funzionalita funzionalita) {
        File tmpFolder = ConfigurationHelper.getTmpFolder(configuration, idEsecuzione, funzionalita);
        File tmpResellerFolder = new File(tmpFolder, "reseller-" + azienda);
        return tmpResellerFolder;
    }

    public static File getResellerFolder(PrebillingGasConfiguration configuration, String azienda) {
        File tmpFolder = ConfigurationHelper.getFolder(configuration);
        File tmpResellerFolder = new File(tmpFolder, "reseller-" + azienda);
        return tmpResellerFolder;
    }

    public static File getResellerTmpImportFolder(PrebillingGasConfiguration configuration, String idEsecuzione, String azienda, Funzionalita funzionalita) {
        File resellerFolder = ConfigurationHelper.getResellerTmpFolder(configuration, idEsecuzione, azienda, funzionalita);
        File folder = new File(resellerFolder, IMPORT);
        folder.mkdirs();
        return folder;
    }

    public static File getResellerTmpPcsFolder(PrebillingGasConfiguration configuration, String idEsecuzione, String azienda, Funzionalita funzionalita) {
        File resellerFolder = ConfigurationHelper.getResellerTmpFolder(configuration, idEsecuzione, azienda, funzionalita);
        File folder = new File(resellerFolder, PCS);
        folder.mkdirs();
        return folder;
    }

    public static File getResellerTmpTariffeFolder(PrebillingGasConfiguration configuration, String idEsecuzione, String azienda, Funzionalita funzionalita, String annoMese) {
        File resellerFolder = ConfigurationHelper.getResellerTmpFolder(configuration, idEsecuzione, azienda, funzionalita);
        File tariffeFolder = new File(resellerFolder, TARIFFE);
        File folder = new File(tariffeFolder, annoMese);
        folder.mkdirs();
        return folder;
    }

    public static File[] getResellerTmpFolders(PrebillingGasConfiguration configuration, String idEsecuzione, Funzionalita funzionalita) {
        PatternFileFilter resellerFilter = new PatternFileFilter("reseller-.*", "reseller file filter");
        File tmpFolder = ConfigurationHelper.getTmpFolder(configuration, idEsecuzione, funzionalita);
        return tmpFolder.listFiles(resellerFilter);
    }

    public static File getResellerTmpLettureFolder(PrebillingGasConfiguration configuration, String idEsecuzione, String azienda, Funzionalita funzionalita) {
        File resellerFolder = ConfigurationHelper.getResellerTmpFolder(configuration, idEsecuzione, azienda, funzionalita);
        String resellerOutput = configuration.getResellerOutputLettureFolderName();
        File folder = new File(resellerFolder, resellerOutput);
        folder.mkdirs();
        return folder;
    }
}

