/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.gas.dao.misure;

import biz.elabor.prebilling.common.model.StatoMisure;
import biz.elabor.prebilling.gas.dao.misure.PrepareStatementHandler;
import biz.elabor.prebilling.gas.services.common.ErroreElaborazioneGas;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Date;

class ConsumoPSH
implements PrepareStatementHandler {
    private final String codicePdr;
    private final String cdREmi;
    private final Date dataMisura;
    private final double consumo;
    private final StatoMisure stato;
    private final ErroreElaborazioneGas errore;
    private final StatoMisure statoTariffe;
    private final ErroreElaborazioneGas erroreTariffe;
    private final Date dataEstrazione;

    public ConsumoPSH(String codicePdr, String cdREmi, Date dataMisura, double consumo, StatoMisure stato, ErroreElaborazioneGas errore, StatoMisure statoTariffe, ErroreElaborazioneGas erroreTariffe, Date dataEstrazione) {
        this.codicePdr = codicePdr;
        this.cdREmi = cdREmi;
        this.dataMisura = dataMisura;
        this.consumo = consumo;
        this.stato = stato;
        this.errore = errore;
        this.statoTariffe = statoTariffe;
        this.erroreTariffe = erroreTariffe;
        this.dataEstrazione = dataEstrazione;
    }

    @Override
    public void prepare(PreparedStatement statement) throws SQLException {
        statement.setDouble(1, this.consumo);
        statement.setDate(2, new java.sql.Date(this.dataEstrazione.getTime()));
        statement.setInt(3, this.stato.getCodice());
        statement.setInt(4, this.errore.getCodice());
        statement.setString(5, this.errore.getMessage());
        statement.setInt(6, this.statoTariffe.getCodice());
        statement.setInt(7, this.erroreTariffe.getCodice());
        statement.setString(8, this.erroreTariffe.getMessage());
        statement.setString(9, this.codicePdr);
        statement.setString(10, this.cdREmi);
        statement.setDate(11, new java.sql.Date(this.dataMisura.getTime()));
    }
}

