/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.gas.dao.misure;

import biz.elabor.prebilling.common.StrategyCommonHelper;
import biz.elabor.prebilling.common.dao.AbstractJdbcMisureDao;
import biz.elabor.prebilling.common.dao.ApplicazioneCreator;
import biz.elabor.prebilling.common.dao.BasicContrattoCreator;
import biz.elabor.prebilling.common.dao.BasicDaoHelper;
import biz.elabor.prebilling.common.dao.MultiPuntoOptionCreator;
import biz.elabor.prebilling.common.dao.MultipuntoEntry;
import biz.elabor.prebilling.common.dao.MultipuntoEntryCreator;
import biz.elabor.prebilling.common.dao.MultipuntoOption;
import biz.elabor.prebilling.common.dao.PrebillingExceptionHandler;
import biz.elabor.prebilling.common.dao.RegimeContrattoCreator;
import biz.elabor.prebilling.common.dao.StatoElaborazione;
import biz.elabor.prebilling.common.dao.TipoStato;
import biz.elabor.prebilling.common.model.Applicazione;
import biz.elabor.prebilling.common.model.BasicContratto;
import biz.elabor.prebilling.common.model.RegimeContratto;
import biz.elabor.prebilling.common.model.StatoMisure;
import biz.elabor.prebilling.gas.Funzionalita;
import biz.elabor.prebilling.gas.config.PrebillingGasConfiguration;
import biz.elabor.prebilling.gas.dao.misure.ClienteCreator;
import biz.elabor.prebilling.gas.dao.misure.ConsumoDirettoCreator;
import biz.elabor.prebilling.gas.dao.misure.ConsumoPSH;
import biz.elabor.prebilling.gas.dao.misure.DatiRegimePSH;
import biz.elabor.prebilling.gas.dao.misure.GasPdrRegimeCreator;
import biz.elabor.prebilling.gas.dao.misure.IgmgCreator;
import biz.elabor.prebilling.gas.dao.misure.MisuraPeriodicaCreator;
import biz.elabor.prebilling.gas.dao.misure.MisureGasDao;
import biz.elabor.prebilling.gas.dao.misure.OfferteGasCreator;
import biz.elabor.prebilling.gas.dao.misure.PrepareStatementHandler;
import biz.elabor.prebilling.gas.dao.misure.PrezzoGasCreator;
import biz.elabor.prebilling.gas.dao.misure.PrezzoPSH;
import biz.elabor.prebilling.gas.dao.misure.ResultUpdateHandler;
import biz.elabor.prebilling.gas.dao.misure.StatoCreator;
import biz.elabor.prebilling.gas.dao.misure.StatoPSH;
import biz.elabor.prebilling.gas.dao.misure.TariffeUpsertHandler;
import biz.elabor.prebilling.gas.dao.misure.TipoMisuraGas;
import biz.elabor.prebilling.gas.dao.misure.model.Cliente;
import biz.elabor.prebilling.gas.dao.misure.model.ConsumoDiretto;
import biz.elabor.prebilling.gas.dao.misure.model.ContrattoGas;
import biz.elabor.prebilling.gas.dao.misure.model.GasPdrRegime;
import biz.elabor.prebilling.gas.dao.misure.model.Igmg;
import biz.elabor.prebilling.gas.dao.misure.model.MisuraGas;
import biz.elabor.prebilling.gas.dao.misure.model.OffertaGas;
import biz.elabor.prebilling.gas.dao.misure.model.PrezzoGas;
import biz.elabor.prebilling.gas.services.GasServiceStatus;
import biz.elabor.prebilling.gas.services.StrategyHelper;
import biz.elabor.prebilling.gas.services.common.ConsumoResult;
import biz.elabor.prebilling.gas.services.common.ErroreElaborazioneGas;
import biz.elabor.prebilling.gas.services.common.IgmgResult;
import biz.elabor.prebilling.gas.services.common.MisuraGasResult;
import biz.elabor.prebilling.gas.services.tariffe.GasErrorWrapper;
import biz.elabor.prebilling.gas.services.tariffe.TariffePdr;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.homelinux.elabor.calendar.CalendarTools;
import org.homelinux.elabor.calendar.ElaborCalendar;
import org.homelinux.elabor.calendar.Month;
import org.homelinux.elabor.db.DataAccessException;
import org.homelinux.elabor.db.DataNotFoundException;
import org.homelinux.elabor.db.DateCreator;
import org.homelinux.elabor.db.QueryTemplate;
import org.homelinux.elabor.db.StringCreator;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;
import org.homelinux.elabor.structures.listmap.DefaultListMapKey;
import org.homelinux.elabor.structures.listmap.ListMap;
import org.homelinux.elabor.structures.listmap.SafeListMap;
import org.homelinux.elabor.structures.safe.DefaultSafeMap;
import org.homelinux.elabor.structures.safe.SafeMap;
import org.homelinux.elabor.structures.safe.SimpleSafeListMap;

public class JdbcMisureGasDao
extends AbstractJdbcMisureDao
implements MisureGasDao {
    private static final List<StatoMisure> STATI = Arrays.asList(StatoMisure.values());
    private final PrebillingGasConfiguration configuration;
    private final DateFormat longDateFormat;
    private final DateFormat standardDateFormat;
    private final String queryPdrRegime;
    private final String queryMisurePeriodiche;
    private final String queryMisureMensili;
    private final String queryMisureVoltura;
    private final String queryRettificheMensili;
    private final String queryMisureRettifiche;
    private final String queryMisureRettificheVoltura;
    private final String queryMisuraPeriodicaRiferimento;
    private final String queryMisuraRettificaRiferimento;
    private final String queryPrezzi;
    private final String queryDiretti;
    private final String queryDirettiPdrs;
    private final String queryConsumiDiretti;
    private final String queryRegime;
    private final String queryContrattoValido;
    private final String queryFirstMisuraPeriodica;
    private final String queryFirstMisuraRettifica;
    private final String queryDirettoRemi;

    public JdbcMisureGasDao(PrebillingGasConfiguration configuration) throws IOException {
        super(configuration.getMisureHost(), configuration.getMisureType(), configuration.getMisureDbName(), configuration.getMisureDbUser(), configuration.getMisureDbPassword());
        ClassLoader classLoader = JdbcMisureGasDao.class.getClassLoader();
        this.queryMisurePeriodiche = JdbcMisureGasDao.loadTemplate(classLoader, "query-misure-periodiche.sql");
        this.queryMisureMensili = JdbcMisureGasDao.loadTemplate(classLoader, "query-misure-mensili.sql");
        this.queryRettificheMensili = JdbcMisureGasDao.loadTemplate(classLoader, "query-rettifiche-mensili.sql");
        this.queryMisureVoltura = JdbcMisureGasDao.loadTemplate(classLoader, "query-misure-voltura.sql");
        this.queryPdrRegime = JdbcMisureGasDao.loadTemplate(classLoader, "query-pdr-regime.sql");
        this.queryContrattoValido = JdbcMisureGasDao.loadTemplate(classLoader, "query-contratto-valido.sql");
        this.queryMisureRettifiche = JdbcMisureGasDao.loadTemplate(classLoader, "query-misure-rettifiche.sql");
        this.queryMisureRettificheVoltura = JdbcMisureGasDao.loadTemplate(classLoader, "query-misure-rettifiche-voltura.sql");
        this.queryMisuraPeriodicaRiferimento = JdbcMisureGasDao.loadTemplate(classLoader, "query-misura-periodica-riferimento.sql");
        this.queryMisuraRettificaRiferimento = JdbcMisureGasDao.loadTemplate(classLoader, "query-misura-rettifica-riferimento.sql");
        this.queryPrezzi = JdbcMisureGasDao.loadTemplate(classLoader, "query-prezzi.sql");
        this.queryDiretti = JdbcMisureGasDao.loadTemplate(classLoader, "query-diretti.sql");
        this.queryDirettiPdrs = JdbcMisureGasDao.loadTemplate(classLoader, "query-diretti-pdrs.sql");
        this.queryConsumiDiretti = JdbcMisureGasDao.loadTemplate(classLoader, "query-consumi-diretti.sql");
        this.queryRegime = JdbcMisureGasDao.loadTemplate(classLoader, "query-regime.sql");
        this.queryFirstMisuraPeriodica = JdbcMisureGasDao.loadTemplate(classLoader, "query-first-misura-periodica.sql");
        this.queryFirstMisuraRettifica = JdbcMisureGasDao.loadTemplate(classLoader, "query-first-misura-rettifica.sql");
        this.queryDirettoRemi = JdbcMisureGasDao.loadTemplate(classLoader, "query-diretto-remi.sql");
        this.configuration = configuration;
        this.longDateFormat = StrategyHelper.getLongDateFormat();
        this.standardDateFormat = StrategyCommonHelper.getStandardDateFormat();
    }

    private void fillDates(QueryTemplate query, int anno, Month mese) {
        ElaborCalendar calendar = new ElaborCalendar(anno, mese);
        Date startDate = calendar.getDate();
        calendar.addMesi(1);
        Date endDate = calendar.getDate();
        this.fillDates(query, startDate, endDate);
    }

    private void fillDates(QueryTemplate query, Date startDate, Date endDate) {
        query.replace(":start_date:", startDate, this.standardDateFormat);
        query.replace(":end_date:", endDate, this.standardDateFormat);
    }

    @Override
    public ListMap<String, MultipuntoOption> getMultipuntoOptions(int anno, Month mese) {
        DefaultListMapKey<String, MultipuntoOption> map = new DefaultListMapKey<String, MultipuntoOption>();
        QueryTemplate query = new QueryTemplate("SELECT * FROM gas_multipunto_opz  WHERE    to_char(dtvalidi,'yyyy-mm-dd')<=:inizio:    AND (dtscaden is null OR to_char(dtscaden,'yyyy-mm-dd')>=:fine:)");
        Date inizio = CalendarTools.getDate(anno, mese, 1);
        DateFormat dateFormat = StrategyCommonHelper.getStandardDateFormat();
        query.replace(":inizio:", inizio, dateFormat);
        Date fine = CalendarTools.getNextMese(anno, mese);
        query.replace(":fine:", fine, dateFormat);
        MultiPuntoOptionCreator creator = new MultiPuntoOptionCreator();
        this.buildClassifier(map, query, creator);
        return map;
    }

    @Override
    public List<MisuraGas> getMisurePeriodiche(String codicePdr, int anno, Month mese, TalkManager talkManager) {
        QueryTemplate query = new QueryTemplate(this.queryMisurePeriodiche);
        query.replace(":pdr:", codicePdr);
        this.fillDates(query, anno, mese);
        MisuraPeriodicaCreator creator = new MisuraPeriodicaCreator(TipoMisuraGas.PERIODICA, talkManager);
        return this.getRecords(query, creator);
    }

    @Override
    public List<MisuraGas> getMisureMensili(String codicePdr, int anno, Month mese, TalkManager talkManager) {
        QueryTemplate query = new QueryTemplate(this.queryMisureMensili);
        query.replace(":pdr:", codicePdr);
        this.fillDates(query, anno, mese);
        MisuraPeriodicaCreator creator = new MisuraPeriodicaCreator(TipoMisuraGas.MENSILE, talkManager);
        return this.getRecords(query, creator);
    }

    @Override
    public List<MisuraGas> getMisureRettificaMensili(String codicePdr, int anno, Month mese, TalkManager talkManager) {
        QueryTemplate query = new QueryTemplate(this.queryRettificheMensili);
        query.replace(":pdr:", codicePdr);
        this.fillDates(query, anno, mese);
        MisuraPeriodicaCreator creator = new MisuraPeriodicaCreator(TipoMisuraGas.RETTIFICA_MENSILE, talkManager);
        return this.getRecords(query, creator);
    }

    @Override
    public List<MisuraGas> getMisureVoltura(String codicePdr, int anno, Month mese, TalkManager talkManager) {
        QueryTemplate query = new QueryTemplate(this.queryMisureVoltura);
        query.replace(":pdr:", codicePdr);
        this.fillDates(query, anno, mese);
        MisuraPeriodicaCreator creator = new MisuraPeriodicaCreator(TipoMisuraGas.VOLTURA, talkManager);
        return this.getRecords(query, creator);
    }

    @Override
    public List<GasPdrRegime> getPdrRegime() {
        QueryTemplate query = new QueryTemplate(this.queryPdrRegime);
        GasPdrRegimeCreator creator = new GasPdrRegimeCreator();
        return this.getRecords(query, creator);
    }

    @Override
    public void updateDatiRegime(int id, Date date) {
        DatiRegimePSH datiRegimeSPH = new DatiRegimePSH(id, date);
        if (!this.updateDatiRegime(datiRegimeSPH)) {
            this.insertDatiRegime(datiRegimeSPH);
        }
    }

    @Override
    public List<MisuraGas> getMisureRettificaPeriodiche(String codicePdr, int anno, Month mese, TalkManager talkManager) {
        QueryTemplate query = new QueryTemplate(this.queryMisureRettifiche);
        query.replace(":pdr:", codicePdr);
        this.fillDates(query, anno, mese);
        MisuraPeriodicaCreator creator = new MisuraPeriodicaCreator(TipoMisuraGas.RETTIFICA_PERIODICA, talkManager);
        return this.getRecords(query, creator);
    }

    @Override
    public List<MisuraGas> getMisureRettificaVoltura(String codicePdr, int anno, Month mese, TalkManager talkManager) {
        QueryTemplate query = new QueryTemplate(this.queryMisureRettificheVoltura);
        query.replace(":pdr:", codicePdr);
        this.fillDates(query, anno, mese);
        MisuraPeriodicaCreator creator = new MisuraPeriodicaCreator(TipoMisuraGas.RETTIFICA_VOLTURA, talkManager);
        return this.getRecords(query, creator);
    }

    @Override
    public MisuraGas getMisuraPeriodicaRiferimento(ContrattoGas contratto, Date endDate, TalkManager talkManager) {
        return this.getMisuraRiferimento(contratto, endDate, this.queryMisuraPeriodicaRiferimento, TipoMisuraGas.PERIODICA, talkManager);
    }

    @Override
    public MisuraGas getMisuraRettificaRiferimento(ContrattoGas contratto, Date endDate, TalkManager talkManager) {
        return this.getMisuraRiferimento(contratto, endDate, this.queryMisuraRettificaRiferimento, TipoMisuraGas.RETTIFICA_PERIODICA, talkManager);
    }

    private MisuraGas getMisuraRiferimento(ContrattoGas contratto, Date endDate, String template, TipoMisuraGas tipo, TalkManager talkManager) {
        QueryTemplate query = new QueryTemplate(template);
        query.replace(":pdr:", contratto.getCodice());
        DateFormat dateFormat = StrategyCommonHelper.getStandardDateFormat();
        query.replace(":end_date:", endDate, dateFormat);
        MisuraPeriodicaCreator creator = new MisuraPeriodicaCreator(tipo, talkManager);
        List<MisuraGas> misure = this.getRecords(query, creator);
        return misure.isEmpty() ? null : misure.get(0);
    }

    @Override
    public MisuraGas getFirstMisuraPeriodica(String codicePdr, TalkManager talkManager) {
        QueryTemplate query = new QueryTemplate(this.queryFirstMisuraPeriodica);
        query.replace(":pdr:", codicePdr);
        MisuraPeriodicaCreator creator = new MisuraPeriodicaCreator(TipoMisuraGas.PERIODICA, talkManager);
        List<MisuraGas> misure = this.getRecords(query, creator);
        return misure.isEmpty() ? null : misure.get(0);
    }

    @Override
    public MisuraGas getFirstMisuraRettifica(String codicePdr, TalkManager talkManager) {
        QueryTemplate query = new QueryTemplate(this.queryFirstMisuraRettifica);
        query.replace(":pdr:", codicePdr);
        MisuraPeriodicaCreator creator = new MisuraPeriodicaCreator(TipoMisuraGas.RETTIFICA_PERIODICA, talkManager);
        List<MisuraGas> misure = this.getRecords(query, creator);
        return misure.isEmpty() ? null : misure.get(0);
    }

    @Override
    public void savePrezzo(String indice, Date data, double prezzo) {
        PrezzoPSH prezzoSPH = new PrezzoPSH(indice, data, prezzo);
        if (!this.updatePrezzo(prezzoSPH)) {
            this.insertPrezzo(prezzoSPH);
        }
    }

    private void insertPrezzo(PrepareStatementHandler prezzoSPH) {
        String query = "insert into GAS_PREZZI (VALORE, INDICE, DATA) values(?, ?, ?)";
        this.executePrepared(query, prezzoSPH);
    }

    private boolean updatePrezzo(PrepareStatementHandler prezzoSPH) {
        String query = "update GAS_PREZZI set VALORE=? where indice=? and data=?";
        int count = this.executePrepared(query, prezzoSPH);
        return count > 0;
    }

    private void insertDatiRegime(PrepareStatementHandler datiRegimeSPH) {
        String query = "insert into GAS_DATI_REGIME (ID, TIMESTAMP) values(?, ?)";
        this.executePrepared(query, datiRegimeSPH);
    }

    private boolean updateDatiRegime(PrepareStatementHandler datiRegimeSPH) {
        String query = "update GAS_DATI_REGIME set ID=?, TIMESTAMP=?";
        int count = this.executePrepared(query, datiRegimeSPH);
        return count > 0;
    }

    private int executePrepared(String query, PrepareStatementHandler handler) {
        int count;
        try {
            Connection connection = this.getConnection();
            Throwable throwable = null;
            Object var6_7 = null;
            try (PreparedStatement statement = connection.prepareStatement(query);){
                handler.prepare(statement);
                statement.execute();
                count = statement.getUpdateCount();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException exc) {
            throw new DataAccessException(exc);
        }
        return count;
    }

    @Override
    public SafeListMap<String, PrezzoGas> getPrezzi(int anno, Month mese) {
        QueryTemplate query = new QueryTemplate(this.queryPrezzi);
        ElaborCalendar calendar = new ElaborCalendar(anno, mese);
        Date startDate = calendar.getDate();
        calendar.addMesi(1);
        Date endDate = calendar.getDate();
        this.fillDates(query, startDate, endDate);
        PrezzoGasCreator creator = new PrezzoGasCreator();
        SimpleSafeListMap<String, PrezzoGas> prezziGas = new SimpleSafeListMap<String, PrezzoGas>("prezzi");
        this.buildClassifier(prezziGas, query, creator);
        return prezziGas;
    }

    @Override
    public List<Cliente> getDiretti(int anno, Month mese) {
        QueryTemplate query = new QueryTemplate(this.queryDiretti);
        Date startDate = CalendarTools.getDate(anno, mese, 1);
        query.replace(":start_date:", startDate, this.standardDateFormat);
        Date endDate = CalendarTools.getNextMese(anno, mese);
        query.replace(":end_date:", endDate, this.standardDateFormat);
        ClienteCreator creator = new ClienteCreator();
        return this.getRecords(query, creator);
    }

    @Override
    public List<Cliente> getDiretti(Date inizio, Date fine, List<String> pdrs) {
        QueryTemplate query = new QueryTemplate(this.queryDirettiPdrs);
        query.replace(":start_date:", inizio, this.standardDateFormat);
        query.replace(":end_date:", fine, this.standardDateFormat);
        query.replace(":pdrs:", pdrs);
        ClienteCreator creator = new ClienteCreator();
        return this.getRecords(query, creator);
    }

    @Override
    public List<Cliente> getClienti(String codiceRemi, Date startDate, Date endDate) {
        QueryTemplate query = new QueryTemplate(this.queryDirettoRemi);
        query.replace(":start_date:", startDate, this.standardDateFormat);
        query.replace(":end_date:", endDate, this.standardDateFormat);
        ClienteCreator creator = new ClienteCreator();
        query.replace(":cdremi:", codiceRemi);
        return this.getRecords(query, creator);
    }

    @Override
    public void saveConsumo(Date data, double consumo, String codiceRemi, String codicePdr) {
        Date toDay = this.configuration.getToDay();
        ConsumoPSH consumoSPH = new ConsumoPSH(codicePdr, codiceRemi, data, consumo, StatoMisure.VALIDATO, ErroreElaborazioneGas.OK, StatoMisure.VALIDATO, ErroreElaborazioneGas.OK, toDay);
        if (!this.updateConsumo(consumoSPH)) {
            this.insertConsumo(consumoSPH);
        }
    }

    private boolean updateConsumo(PrepareStatementHandler consumoSPH) {
        String query = "update gas_consumi_diretti set QTCONSUM=?, DATA_ESTRAZIONE=?, STATO=?, COD_ERRORE=?, DESC_ERRORE=?, STATO_TARIFFE_RESELLER=?, COD_ERRORE_TARIFFE_RESELLER=?, DESC_ERRORE_TARIFFE_RESELLER=? where PDR=? and CDREMI=? and DTMISURA=?";
        int count = this.executePrepared(query, consumoSPH);
        return count > 0;
    }

    private void insertConsumo(PrepareStatementHandler consumoSPH) {
        String query = "insert into gas_consumi_diretti ( QTCONSUM, DATA_ESTRAZIONE, STATO, COD_ERRORE, DESC_ERRORE, STATO_TARIFFE_RESELLER, COD_ERRORE_TARIFFE_RESELLER, DESC_ERRORE_TARIFFE_RESELLER, PDR, CDREMI, DTMISURA) values(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        this.executePrepared(query, consumoSPH);
    }

    @Override
    public List<ConsumoDiretto> getConsumiDiretti(String codiceRemi, int anno, Month mese) {
        return this.getConsumiDiretti(codiceRemi, anno, mese, STATI);
    }

    @Override
    public List<ConsumoDiretto> getConsumiDiretti(String codiceRemi, int anno, Month mese, List<StatoMisure> stati) {
        QueryTemplate query = new QueryTemplate(this.queryConsumiDiretti);
        query.replace(":cdremi:", codiceRemi);
        Date startDate = CalendarTools.getDate(anno, mese, 1);
        Date endDate = CalendarTools.getNextMese(anno, mese);
        this.fillDates(query, startDate, endDate);
        List<Integer> codici = BasicDaoHelper.buildCodiciStatoMisure(stati);
        query.replace(":stati:", codici);
        ConsumoDirettoCreator creator = new ConsumoDirettoCreator();
        return this.getRecords(query, creator);
    }

    @Override
    public StatoElaborazione getStato(List<Funzionalita> funzionalita, List<String> ambiti) throws DataNotFoundException {
        String template = "SELECT * FROM stato WHERE funzionalita in (:funzionalita) AND tipostato != 'NO_ESECUZIONE'";
        if (!ambiti.isEmpty()) {
            template = String.valueOf(template) + " AND (";
            String connettore = "";
            for (String ambito : ambiti) {
                template = String.valueOf(template) + connettore;
                template = String.valueOf(template) + "cdaziend LIKE '" + ambito + "'";
                connettore = " OR ";
            }
            template = String.valueOf(template) + ")";
        }
        QueryTemplate query = new QueryTemplate(template);
        query.replace(":funzionalita", funzionalita);
        StatoCreator creator = new StatoCreator();
        return this.getRecord(query, creator, "applicazione.notfound", funzionalita.get(0).name());
    }

    @Override
    public void saveStato(Funzionalita funzionalita, String azienda, TipoStato stato, Date date, String idEsecuzione) {
        String query = "update stato set TIPOSTATO=?, DATA=?, ID_LOG=? where FUNZIONALITA=? and CDAZIEND=?";
        StatoPSH handler = new StatoPSH(funzionalita, azienda, stato, date, idEsecuzione, this.longDateFormat);
        if (this.executePrepared(query, handler) == 0) {
            query = "insert into stato (TIPOSTATO, DATA, ID_LOG, FUNZIONALITA, CDAZIEND) values (?, ?, ?, ?, ?)";
            this.executePrepared(query, handler);
        }
    }

    @Override
    public boolean recordStatoTariffe(GasServiceStatus status, TalkManager talkManager) {
        Connection connection = this.getConnection();
        Logger logger = status.getLogger();
        PrebillingExceptionHandler exceptionHandler = new PrebillingExceptionHandler(talkManager, logger);
        List<MisuraGasResult> misure = status.getMisureResult();
        ResultUpdateHandler misureUH = new ResultUpdateHandler(misure, "GAS_MISURE_PERIODICHE", connection);
        boolean ok = this.executeMultiUpdate(misureUH, exceptionHandler);
        List<MisuraGasResult> rettifiche = status.getRettificheResult();
        ResultUpdateHandler rettificheUH = new ResultUpdateHandler(rettifiche, "GAS_MISURE_RETTIFICHE", connection);
        ok &= this.executeMultiUpdate(rettificheUH, exceptionHandler);
        List<IgmgResult> igmgResult = status.getIgmgResult();
        ResultUpdateHandler igmgUH = new ResultUpdateHandler(igmgResult, "GAS_MISURE_IGMG", connection);
        ok &= this.executeMultiUpdate(igmgUH, exceptionHandler);
        List<ConsumoResult> consumiResult = status.getConsumiResult();
        ResultUpdateHandler consumiUH = new ResultUpdateHandler(consumiResult, "GAS_CONSUMI_DIRETTI", connection);
        ok &= this.executeMultiUpdate(consumiUH, exceptionHandler);
        Map<String, Map<String, Map<String, TariffePdr>>> tariffe = status.getTariffe();
        TariffeUpsertHandler tariffeUH = new TariffeUpsertHandler(tariffe, connection);
        return ok &= this.executeMultiUpdate(tariffeUH, exceptionHandler);
    }

    @Override
    public SafeMap<String, OffertaGas> getOfferte() {
        QueryTemplate query = new QueryTemplate("select * from GAS_OFFERTE order by cdindene");
        OfferteGasCreator creator = new OfferteGasCreator();
        GasErrorWrapper error = new GasErrorWrapper(ErroreElaborazioneGas.MISSING_OFFERTA);
        DefaultSafeMap<String, OffertaGas> map = new DefaultSafeMap<String, OffertaGas>(error);
        this.buildMap(map, query, creator);
        return map;
    }

    @Override
    public List<Igmg> getIgmg(String codicePdr, int anno, Month mese) {
        QueryTemplate query = new QueryTemplate("select *  from GAS_MISURE_IGMG  where    FLUSSO='IGMG'    and PDR=:pdr:    and STATO_TARIFFE_RESELLER in (4,5,8)    and to_char(DATA_MISURA, 'yyyy-mm-dd') >= :start_date:  order by DATA_MISURA");
        query.replace(":pdr:", codicePdr);
        this.fillDates(query, anno, mese);
        IgmgCreator creator = new IgmgCreator();
        return this.getRecords(query, creator);
    }

    @Override
    public Set<String> getActivePdr(int anno, Month mese) {
        Date endDate = CalendarTools.getNextMese(anno, mese);
        DateFormat dateFormat = StrategyCommonHelper.getAnnoMeseDateFormat();
        String templatePeriodiche = "SELECT DISTINCT pdr FROM GAS_MISURE_PERIODICHE WHERE  FLUSSO='TGL'  AND to_char(LET_DATA_COMP, 'yyyymm') < :mese:  AND STATO_TARIFFE_RESELLER in (4,5) GROUP BY pdr ORDER BY pdr";
        QueryTemplate query = new QueryTemplate(templatePeriodiche);
        query.replace(":mese:", endDate, dateFormat);
        StringCreator creator = new StringCreator("pdr");
        LinkedHashSet<String> activePdr = new LinkedHashSet<String>(this.getRecords(query, creator));
        String templateRettifiche = "SELECT DISTINCT pdr FROM GAS_MISURE_RETTIFICHE WHERE  FLUSSO='RGL'  AND to_char(LET_DATA_RACC, 'yyyymm') < :mese:  AND STATO_TARIFFE_RESELLER in (4,5) GROUP BY pdr ORDER BY pdr";
        query = new QueryTemplate(templateRettifiche);
        query.replace(":mese:", endDate, dateFormat);
        activePdr.addAll(this.getRecords(query, creator));
        return activePdr;
    }

    @Override
    public Date getFirstActiveMonth(String codicePdr) {
        DateFormat dateFormat = StrategyCommonHelper.getAnnoMeseDateFormat();
        String templatePeriodiche = "SELECT to_char(min(LET_DATA_COMP), 'yyyymm') as data FROM GAS_MISURE_PERIODICHE WHERE  PDR=:pdr:  AND FLUSSO='TGL'  AND STATO_TARIFFE_RESELLER in (4,5)";
        QueryTemplate query = new QueryTemplate(templatePeriodiche);
        query.replace(":pdr:", codicePdr);
        DateCreator creator = new DateCreator("data", dateFormat, true);
        Date firstActiveDatePeriodiche = JdbcMisureGasDao.getFirst(this.getRecords(query, creator));
        String templateRettifiche = "SELECT to_char(min(LET_DATA_RACC), 'yyyymm') as data FROM GAS_MISURE_RETTIFICHE WHERE  PDR=:pdr:  AND FLUSSO='RGL'  AND STATO_TARIFFE_RESELLER in (4,5)";
        query = new QueryTemplate(templateRettifiche);
        query.replace(":pdr:", codicePdr);
        Date firstActiveDateRettifiche = JdbcMisureGasDao.getFirst(this.getRecords(query, creator));
        return CalendarTools.minNullable(firstActiveDatePeriodiche, firstActiveDateRettifiche);
    }

    private static Date getFirst(List<Date> dates) {
        Date first = null;
        Iterator<Date> iterator = dates.iterator();
        while (iterator.hasNext()) {
            Date current;
            first = current = iterator.next();
        }
        return first;
    }

    @Override
    public List<BasicContratto> getContrattiDirettiNonRegime(Date data) {
        QueryTemplate query = new QueryTemplate(this.queryRegime);
        DateFormat dateFormat = StrategyCommonHelper.getStandardDateFormat();
        query.replace(":data_fine", data, dateFormat);
        BasicContrattoCreator creator = new BasicContrattoCreator(false);
        return this.getRecords(query, creator);
    }

    @Override
    public RegimeContratto getContrattoValido(String pdr, Date data) {
        QueryTemplate query = new QueryTemplate(this.queryContrattoValido);
        DateFormat dateFormat = StrategyCommonHelper.getStandardDateFormat();
        query.replace(":data:", data, dateFormat);
        query.replace(":pdr:", pdr);
        RegimeContrattoCreator creator = new RegimeContrattoCreator(false);
        List<RegimeContratto> contratti = this.getRecords(query, creator);
        return contratti.size() > 0 ? contratti.get(0) : null;
    }

    @Override
    public boolean isTariffaElaborata(String codicePdr, Date data) {
        QueryTemplate query = new QueryTemplate("SELECT *  FROM gas_tariffe_elaborate  WHERE pdr=:codice-pdr: AND to_char(data_inizio, 'yyyy-mm-dd') = :data:");
        query.replace(":codice-pdr:", codicePdr);
        String dataFmt = this.standardDateFormat.format(data);
        query.replace(":data:", dataFmt);
        return this.queryForExistence(query);
    }

    @Override
    public Map<String, Applicazione> getApplicazioni() {
        QueryTemplate query = new QueryTemplate("SELECT * FROM gas_applicazioni ORDER BY tipo");
        ApplicazioneCreator creator = new ApplicazioneCreator();
        LinkedHashMap applicazioni = new LinkedHashMap();
        return this.buildMap(applicazioni, query, creator);
    }

    @Override
    public Map<String, MultipuntoEntry> getPdrMap(String codicePdr, int anno, Month mese) {
        QueryTemplate query = new QueryTemplate("SELECT trim(PDR) as key, COD_RAGGRUPPAMENTO, dtinicom, dtfincom FROM gas_multipunto_ass WHERE COD_RAGGRUPPAMENTO in (SELECT COD_RAGGRUPPAMENTO  FROM gas_multipunto_ass  WHERE    PDR=:pdr: AND    to_char(dtinicom, 'yyyy-mm-dd') < :end-date: AND    (dtfincom is null OR to_char(dtfincom, 'yyyy-mm-dd') >= :start-date:)) AND to_char(dtinicom, 'yyyy-mm-dd') < :end-date: AND (dtfincom is null OR to_char(dtfincom, 'yyyy-mm-dd') >= :start-date:)");
        query.replace(":pdr:", codicePdr);
        DateFormat dateFormat = StrategyCommonHelper.getStandardDateFormat();
        Date startDate = CalendarTools.getDate(anno, mese, 1);
        query.replace(":start-date:", startDate, dateFormat);
        Date endDate = CalendarTools.getNextMese(anno, mese);
        query.replace(":end-date:", endDate, dateFormat);
        MultipuntoEntryCreator creator = new MultipuntoEntryCreator();
        return this.getMap(query, creator);
    }

    @Override
    public List<Integer> getSubapplicazioni(Applicazione applicazione, int anno, Month mese) {
        return this.getSubapplicazioni("gas_applicazioni_sub", applicazione, anno, mese);
    }
}

