/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.gas.dao.misure;

import biz.elabor.prebilling.common.model.StatoMisure;
import biz.elabor.prebilling.gas.dao.misure.TipoMisuraGas;
import biz.elabor.prebilling.gas.dao.misure.model.InvalidDataValue;
import biz.elabor.prebilling.gas.dao.misure.model.MisuraGas;
import biz.elabor.prebilling.gas.dao.misure.model.TipoLettura;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import org.homelinux.elabor.db.RecordCreator;
import org.homelinux.elabor.springtools.web.widgets.Message;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;

public class MisuraPeriodicaCreator
implements RecordCreator<MisuraGas> {
    private final TipoMisuraGas tipoMisura;
    private final TalkManager talkManager;

    public MisuraPeriodicaCreator(TipoMisuraGas tipoMisura, TalkManager talkManager) {
        this.tipoMisura = tipoMisura;
        this.talkManager = talkManager;
    }

    @Override
    public MisuraGas createRecord(ResultSet rs) throws SQLException {
        MisuraGas misura;
        String id = rs.getString("ID");
        String codicePdr = rs.getString("PDR");
        try {
            TipoLettura tipoLettura = this.tipoMisura.getTipoLettura(rs);
            Date dataMisura = this.tipoMisura.getDataMisura(rs);
            String matrMis = rs.getString("LET_MATR_MIS");
            String matrConv = rs.getString("LET_MATR_CONV");
            double coeffCorr = rs.getDouble("PDR_COEFF_CORR");
            double segnanteMisuratore = this.tipoMisura.getSegnante(rs);
            double segnanteConvertitore = this.tipoMisura.getSegnanteConv(rs);
            String flusso = rs.getString("FLUSSO").trim();
            boolean ingresso = rs.getString("TIMESTAMP") != null;
            StatoMisure stato = StatoMisure.valueOf(rs.getInt("STATO_TARIFFE_RESELLER"));
            misura = new MisuraGas(id, flusso, codicePdr, dataMisura, tipoLettura, matrMis, matrConv, segnanteMisuratore, segnanteConvertitore, coeffCorr, ingresso, stato);
        }
        catch (InvalidDataValue exc) {
            String message = exc.getMessage();
            Message sentence = new Message("misura.periodica", message);
            sentence.addParam(exc.getCodice());
            sentence.addParam(exc.getNome());
            sentence.addParam(codicePdr);
            this.talkManager.addSentence(sentence);
            misura = null;
        }
        return misura;
    }
}

