/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.gas.dao.misure.model;

import biz.elabor.prebilling.common.model.StatoMisure;
import biz.elabor.prebilling.gas.dao.misure.model.MisuraGas;
import biz.elabor.prebilling.gas.dao.misure.model.TipoLettura;
import biz.elabor.prebilling.gas.services.tariffe.model.BasicIdFlussoGas;
import java.util.Date;

public class Igmg
extends BasicIdFlussoGas {
    private final String codicePdr;
    private final Date dataMisura;
    private final String preMatMis;
    private final String preMatConv;
    private final double preLetMis;
    private final double preLetConv;
    private final String postMatMis;
    private final String postMatConv;
    private final double postLetMis;
    private final double postLetConv;
    private final double postCoeff;
    private final double preCoeff;

    public Igmg(String id, String codicePdr, Date dataMisura, String preMatMis, String preMatConv, double preLetMis, double preLetConv, double preCoeff, String postMatMis, String postMatConv, double postLetMis, double postLetConv, double postCoeff, StatoMisure stato) {
        super(id, stato);
        this.codicePdr = codicePdr;
        this.dataMisura = dataMisura;
        this.preMatMis = preMatMis;
        this.preMatConv = preMatConv;
        this.preLetMis = preLetMis;
        this.preLetConv = preLetConv;
        this.preCoeff = preCoeff;
        this.postMatMis = postMatMis;
        this.postMatConv = postMatConv;
        this.postLetMis = postLetMis;
        this.postLetConv = postLetConv;
        this.postCoeff = postCoeff;
    }

    public String getCodicePdr() {
        return this.codicePdr;
    }

    public Date getDataMisura() {
        return this.dataMisura;
    }

    public String getPreMatMis() {
        return this.preMatMis;
    }

    public String getPreMatConv() {
        return this.preMatConv;
    }

    public double getPreLetMis() {
        return this.preLetMis;
    }

    public double getPreLetConv() {
        return this.preLetConv;
    }

    public String getPostMatMis() {
        return this.postMatMis;
    }

    public String getPostMatConv() {
        return this.postMatConv;
    }

    public double getPostLetMis() {
        return this.postLetMis;
    }

    private double getPreCoeff() {
        return this.preMatConv == null || this.preMatConv.trim().isEmpty() ? this.preCoeff : 1.0;
    }

    public double getPostLetConv() {
        return this.postLetConv;
    }

    public MisuraGas getMisuraPre() {
        double coeff = this.getPreCoeff();
        double segnanteMisuratore = coeff * this.preLetMis;
        double segnanteConvertitore = this.preLetConv;
        return new MisuraGas(null, "igmg", this.codicePdr, this.dataMisura, TipoLettura.EFFETTIVA, this.preMatMis, this.preMatConv, segnanteMisuratore, segnanteConvertitore, this.preCoeff, true, null);
    }

    public MisuraGas getMisuraPost() {
        double coeff = this.getPreCoeff();
        double segnanteMisuratore = coeff * this.postLetMis;
        double segnanteConvertitore = this.postLetConv;
        return new MisuraGas(null, "igmg", this.codicePdr, this.dataMisura, TipoLettura.EFFETTIVA, this.postMatMis, this.postMatConv, segnanteMisuratore, segnanteConvertitore, this.postCoeff, true, null);
    }
}

