/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.gas.services;

import biz.elabor.prebilling.common.PrebillingContext;
import biz.elabor.prebilling.gas.config.PrebillingGasConfiguration;
import biz.elabor.prebilling.gas.services.GasServiceStatus;
import biz.elabor.prebilling.gas.services.GasServiceStrategy;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import org.homelinux.elabor.tools.MemoryTools;

public class GasStrategiesManager {
    private final List<GasServiceStrategy> strategies;
    private final PrebillingGasConfiguration configuration;

    public GasStrategiesManager(PrebillingGasConfiguration configuration) {
        this.configuration = configuration;
        this.strategies = new ArrayList<GasServiceStrategy>();
    }

    public void addStrategy(GasServiceStrategy strategy) {
        this.strategies.add(strategy);
    }

    public boolean execute(GasServiceStatus status) {
        boolean logMemory = this.configuration.isLogMemory();
        Logger logger = status.getLogger();
        boolean ok = true;
        Iterator<GasServiceStrategy> iterator = this.strategies.iterator();
        while (ok && iterator.hasNext()) {
            GasServiceStrategy strategy = iterator.next();
            String className = strategy.getClass().getSimpleName();
            logger.info(String.valueOf(className) + " start");
            PrebillingContext.setContext(className, "start");
            ok = strategy.execute(status);
            logger.info(String.valueOf(className) + " end");
            if (!logMemory) continue;
            MemoryTools.logMemory(logger, className);
        }
        return ok;
    }
}

