/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.gas.services.checkconsumi;

import biz.elabor.prebilling.common.PrebillingError;
import biz.elabor.prebilling.common.StrategyCommonHelper;
import biz.elabor.prebilling.common.dao.MultipuntoEntry;
import biz.elabor.prebilling.common.model.Applicazione;
import biz.elabor.prebilling.common.model.ContrattiHelper;
import biz.elabor.prebilling.common.model.StatoMisure;
import biz.elabor.prebilling.common.model.TipoFlat;
import biz.elabor.prebilling.gas.config.PrebillingGasConfiguration;
import biz.elabor.prebilling.gas.dao.giada.GiadaGasDao;
import biz.elabor.prebilling.gas.dao.misure.MisureGasDao;
import biz.elabor.prebilling.gas.dao.misure.model.ConsumoDiretto;
import biz.elabor.prebilling.gas.dao.misure.model.ContrattoGas;
import biz.elabor.prebilling.gas.dao.misure.model.Igmg;
import biz.elabor.prebilling.gas.dao.misure.model.MisuraGas;
import biz.elabor.prebilling.gas.dao.misure.model.NoConverterException;
import biz.elabor.prebilling.gas.dao.misure.model.ProfiloPrelievo;
import biz.elabor.prebilling.gas.dao.misure.model.TipoLettura;
import biz.elabor.prebilling.gas.services.GasServiceStatus;
import biz.elabor.prebilling.gas.services.StrategyHelper;
import biz.elabor.prebilling.gas.services.common.ErroreElaborazioneGas;
import biz.elabor.prebilling.gas.services.common.IgmgResult;
import biz.elabor.prebilling.gas.services.common.MisuraGasResult;
import biz.elabor.prebilling.gas.services.tariffe.CoeffCorrChangedException;
import biz.elabor.prebilling.gas.services.tariffe.ConsumiGruppo;
import biz.elabor.prebilling.gas.services.tariffe.ConsumiMesePdr;
import biz.elabor.prebilling.gas.services.tariffe.ConvertitoreCheckingHandler;
import biz.elabor.prebilling.gas.services.tariffe.CounterChangedException;
import biz.elabor.prebilling.gas.services.tariffe.GiroContatoreSpurioException;
import biz.elabor.prebilling.gas.services.tariffe.MissingIngressoException;
import biz.elabor.prebilling.gas.services.tariffe.MissingMisuraException;
import biz.elabor.prebilling.gas.services.tariffe.MisuraGasException;
import biz.elabor.prebilling.gas.services.tariffe.TariffeGasHelper;
import biz.elabor.prebilling.gas.services.tariffe.model.Consumo;
import biz.elabor.prebilling.gas.services.tariffe.model.ConvertitoreHandler;
import biz.elabor.prebilling.gas.services.tariffe.model.MisuratoreHandler;
import biz.elabor.prebilling.gas.services.tariffe.model.TipoLettoreHandler;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.homelinux.elabor.calendar.CalendarTools;
import org.homelinux.elabor.calendar.ElaborCalendar;
import org.homelinux.elabor.calendar.Month;
import org.homelinux.elabor.db.DataNotFoundException;
import org.homelinux.elabor.db.MultipleRowException;
import org.homelinux.elabor.springtools.web.widgets.Message;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;
import org.homelinux.elabor.structures.TappoIterator;
import org.homelinux.elabor.structures.listmap.ListMap;
import org.homelinux.elabor.tools.MathUtils;
import org.javatuples.Quartet;
import org.javatuples.Triplet;

public class ConsumiGruppoService {
    private static final TipoLettoreHandler MIS_HANDLER = new MisuratoreHandler();
    private static final TipoLettoreHandler CONV_HANDLER = new ConvertitoreHandler();
    private static final TipoLettoreHandler CHECKING_CONV_HANDLER = new ConvertitoreCheckingHandler();
    private final int anno;
    private final Month mese;
    private final ListMap<String, ContrattoGas> contratti;
    private final Map<Set<String>, ConsumiGruppo> pdrAggregationMap;
    private final List<StatoMisure> stati;
    private final Map<String, Map<Date, MisuraGas>> misureCalcolate;
    private final boolean scivoloEnabled;
    private final boolean forceSopraSoglia;
    private final DateFormat dateFormat;
    private final TalkManager talkManager;
    private final PrebillingGasConfiguration configuration;
    private final GiadaGasDao giadaDao;
    private final MisureGasDao misureDao;
    private final GasServiceStatus status;

    public ConsumiGruppoService(int anno, Month mese, ListMap<String, ContrattoGas> contratti, Map<Set<String>, ConsumiGruppo> pdrAggregationMap, Map<String, Map<Date, MisuraGas>> misureCalcolate, boolean scivoloEnabled, boolean forceSopraSoglia, List<StatoMisure> stati, TalkManager talkManager, DateFormat dateFormat, PrebillingGasConfiguration configuration, GiadaGasDao giadaDao, MisureGasDao misureDao, GasServiceStatus status) {
        this.anno = anno;
        this.mese = mese;
        this.contratti = contratti;
        this.pdrAggregationMap = pdrAggregationMap;
        this.stati = stati;
        this.misureCalcolate = misureCalcolate;
        this.scivoloEnabled = scivoloEnabled;
        this.forceSopraSoglia = forceSopraSoglia;
        this.dateFormat = dateFormat;
        this.talkManager = talkManager;
        this.configuration = configuration;
        this.giadaDao = giadaDao;
        this.misureDao = misureDao;
        this.status = status;
    }

    public ConsumiGruppo getConsumiGruppo(ContrattoGas contratto) {
        String codicePdr = contratto.getCodice();
        ConsumiGruppo consumiGruppo = this.findConsumiGruppo(codicePdr);
        if (consumiGruppo == null) {
            Map<String, MultipuntoEntry> pdrMap = ConsumiGruppoService.getPdrMap(this.anno, this.mese, codicePdr, this.misureDao);
            consumiGruppo = this.calcolaConsumiGruppo(pdrMap);
            Set<String> pdrSet = pdrMap.keySet();
            this.pdrAggregationMap.put(pdrSet, consumiGruppo);
        }
        return consumiGruppo;
    }

    private ConsumiGruppo findConsumiGruppo(String codicePdr) {
        ConsumiGruppo consumiGruppo = null;
        for (Set<String> current : this.pdrAggregationMap.keySet()) {
            if (!current.contains(codicePdr)) continue;
            consumiGruppo = this.pdrAggregationMap.get(current);
            break;
        }
        return consumiGruppo;
    }

    private ConsumiGruppo calcolaConsumiGruppo(Map<String, MultipuntoEntry> pdrMap) {
        String codRaggruppamento = pdrMap.values().iterator().next().getCodRaggruppamento();
        ConsumiGruppo consumiGruppo = new ConsumiGruppo(codRaggruppamento, true);
        boolean dryRun = false;
        for (Map.Entry<String, MultipuntoEntry> pdrEntry : pdrMap.entrySet()) {
            String codicePdr = pdrEntry.getKey();
            MultipuntoEntry multipuntoEntry = pdrEntry.getValue();
            try {
                List<ContrattoGas> contrattiPdr = this.getContrattiPdr(codicePdr, multipuntoEntry);
                this.fillConsumiPdr(codicePdr, multipuntoEntry, contrattiPdr, consumiGruppo, dryRun);
            }
            catch (MisuraGasException exc) {
                consumiGruppo = new ConsumiGruppo(codRaggruppamento, false);
                dryRun = true;
            }
        }
        return consumiGruppo;
    }

    private void fillConsumiPdr(String codicePdr, MultipuntoEntry multipuntoEntry, List<ContrattoGas> contrattiPdr, ConsumiGruppo consumiGruppo, boolean dryRun) throws MisuraGasException {
        for (ContrattoGas contratto : contrattiPdr) {
            if (!consumiGruppo.isMissing(codicePdr)) continue;
            Date dataInizioTariffa = ContrattiHelper.getInizioTariffa(contratto, this.anno, this.mese);
            MisuraGas misuraPrecedente = ConsumiGruppoService.getMisuraPrecedente(codicePdr, dataInizioTariffa, this.misureCalcolate);
            ConsumiMesePdr consumiMesePdr = this.calcolaConsumiMesePdr(contratto, misuraPrecedente);
            if (dryRun) continue;
            consumiGruppo.addConsumi(codicePdr, consumiMesePdr, multipuntoEntry);
        }
        ConsumiMesePdr consumiPdr = consumiGruppo.getConsumiPdr(codicePdr);
        if (consumiPdr != null) {
            List<MisuraGas> misure = consumiPdr.getMisure();
            this.excludeConsumi(misure, contrattiPdr);
        }
    }

    public static MisuraGas getMisuraPrecedente(String codicePdr, Date data, Map<String, Map<Date, MisuraGas>> misureCalcolate) {
        MisuraGas misura = null;
        Map<Date, MisuraGas> mappaMisurePdr = misureCalcolate.get(codicePdr);
        if (mappaMisurePdr != null) {
            for (Map.Entry<Date, MisuraGas> entry : mappaMisurePdr.entrySet()) {
                Date dataMisura = entry.getKey();
                if (!dataMisura.before(data)) break;
                misura = entry.getValue();
            }
        }
        return misura;
    }

    private List<ContrattoGas> getContrattiPdr(String codicePdr, MultipuntoEntry multipuntoEntry) throws MissingMisuraException {
        List contrattiPdr = (List)this.contratti.get(codicePdr);
        if (contrattiPdr == null || contrattiPdr.isEmpty()) {
            Date dataInizioMese = CalendarTools.getDate(this.anno, this.mese, 1);
            String codRaggruppamento = "COD_RAGGRUPPAMENTO " + multipuntoEntry.getCodRaggruppamento();
            MissingMisuraException exc = new MissingMisuraException(ErroreElaborazioneGas.MISSING_CONTRATTO, codRaggruppamento, codicePdr, dataInizioMese);
            TariffeGasHelper.handleException(this.dateFormat, exc, this.talkManager);
            throw exc;
        }
        return contrattiPdr;
    }

    public static Map<String, MultipuntoEntry> getPdrMap(int anno, Month mese, String codicePdr, MisureGasDao misureDao) {
        Map<String, MultipuntoEntry> pdrMap = misureDao.getPdrMap(codicePdr, anno, mese);
        if (pdrMap.isEmpty()) {
            MultipuntoEntry multipuntoEntry = new MultipuntoEntry(codicePdr, codicePdr, null, null);
            pdrMap.put(codicePdr, multipuntoEntry);
        }
        return pdrMap;
    }

    private void excludeConsumi(List<MisuraGas> misure, List<ContrattoGas> contrattiPdr) {
        if (misure != null && !misure.isEmpty()) {
            Date dataInizioMese = CalendarTools.getDate(this.anno, this.mese, 1);
            Date dataFineMese = CalendarTools.getEndDate(this.anno, this.mese);
            ErroreElaborazioneGas errore = ErroreElaborazioneGas.CONTRATTO_CHIUSO;
            String message = errore.getMessage();
            for (MisuraGas misura : misure) {
                Date dataMisura = misura.getDataMisura();
                if (dataMisura.before(dataInizioMese) || dataMisura.after(dataFineMese) || !this.contrattiChiusi(misura, contrattiPdr)) continue;
                Message sentence = new Message(null, message);
                String codicePdr = misura.getCodicePdr();
                sentence.addParam(codicePdr);
                String descrizione = this.talkManager.getMessage(sentence);
                this.status.addMisuraResult(misura, StatoMisure.ESCLUSO, errore, descrizione);
            }
        }
    }

    private boolean contrattiChiusi(MisuraGas misura, List<ContrattoGas> contrattiPdr) {
        boolean chiuso = true;
        Date dataMisura = misura.getDataMisura();
        for (ContrattoGas contratto : contrattiPdr) {
            Date dataInizioTariffa = ContrattiHelper.getInizioTariffa(contratto, this.anno, this.mese);
            Date dataFineTariffa = ContrattiHelper.getFineTariffa(this.anno, this.mese, contratto);
            if (dataMisura.before(dataInizioTariffa) || dataMisura.after(dataFineTariffa)) continue;
            chiuso = false;
            break;
        }
        return chiuso;
    }

    private ConsumiMesePdr calcolaConsumiMesePdr(ContrattoGas contratto, MisuraGas misuraPrecedente) throws MisuraGasException {
        ConsumiMesePdr consumiDataPdr;
        if (contratto.isDiretto()) {
            Applicazione applicazione = this.status.getApplicazione(contratto);
            consumiDataPdr = this.calcolaConsumiDiretto(contratto, applicazione);
        } else {
            consumiDataPdr = this.getConsumiIndiretto(contratto, misuraPrecedente);
        }
        return consumiDataPdr;
    }

    private ConsumiMesePdr calcolaConsumiDiretto(ContrattoGas contratto, Applicazione applicazione) throws MissingMisuraException {
        String codiceRemi = contratto.getCodiceRemi();
        List<ConsumoDiretto> consumi = this.misureDao.getConsumiDiretti(codiceRemi, this.anno, this.mese, this.stati);
        TipoFlat tipoFlat = applicazione.getTipoFlat();
        double qtconsum = contratto.getQtconsum();
        boolean scivolo = consumi.isEmpty();
        if (scivolo && !this.scivoloEnabled && !tipoFlat.isFixingSwap()) {
            String azienda = contratto.getReseller();
            String codicePdr = contratto.getCodice();
            Date inizioContratto = ContrattiHelper.getInizioTariffa(contratto, this.anno, this.mese);
            MissingMisuraException exc = new MissingMisuraException(ErroreElaborazioneGas.MISSING_CONSUMI, azienda, codicePdr, inizioContratto);
            TariffeGasHelper.handleException(this.dateFormat, exc, this.talkManager);
            throw exc;
        }
        return new ConsumiMesePdr(consumi, null, null, null, null, null, null, 0.0, false, scivolo, null, qtconsum);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ConsumiMesePdr getConsumiIndiretto(ContrattoGas contratto, MisuraGas misuraPrecedente) throws MissingMisuraException, GiroContatoreSpurioException, CoeffCorrChangedException, MissingIngressoException {
        ConsumiMesePdr consumiMesePdr = null;
        String codicePdr = contratto.getCodice();
        List<Igmg> igmg = this.misureDao.getIgmg(codicePdr, this.anno, this.mese);
        List<MisuraGas> misureMensili = this.misureDao.getMisureMensili(codicePdr, this.anno, this.mese, this.talkManager);
        List<MisuraGas> misureRettificaMensili = this.misureDao.getMisureRettificaMensili(codicePdr, this.anno, this.mese, this.talkManager);
        List<MisuraGas> misurePeriodiche = this.misureDao.getMisurePeriodiche(codicePdr, this.anno, this.mese, this.talkManager);
        List<MisuraGas> misureRettificaPeriodiche = this.misureDao.getMisureRettificaPeriodiche(codicePdr, this.anno, this.mese, this.talkManager);
        List<MisuraGas> misureVoltura = this.misureDao.getMisureVoltura(codicePdr, this.anno, this.mese, this.talkManager);
        List<MisuraGas> misureRettificaVoltura = this.misureDao.getMisureRettificaVoltura(codicePdr, this.anno, this.mese, this.talkManager);
        try {
            String azienda = contratto.getReseller();
            List<MisuraGas> misureMensiliRettificate = this.rettificaMisure(misureMensili, misureRettificaMensili, azienda);
            List<MisuraGas> misurePeriodicheRettificate = this.rettificaMisure(misurePeriodiche, misureRettificaPeriodiche, azienda);
            List<MisuraGas> misureVolturaRettificate = this.rettificaMisure(misureVoltura, misureRettificaVoltura, azienda);
            List<MisuraGas> misure = this.rettificaMisure(misureMensiliRettificate, misurePeriodicheRettificate, azienda);
            misure = this.rettificaMisure(misure, misureVolturaRettificate, azienda);
            try {
                MisuraGas primaMisura = ConsumiGruppoService.getPrimaMisura(misure, igmg);
                String matrConvRif = ConsumiGruppoService.getMatricolaConv(primaMisura);
                MisuraGas misuraRiferimento = ConsumiGruppoService.getMisuraRiferimento(contratto, this.anno, this.mese, matrConvRif, misuraPrecedente, this.misureDao, this.talkManager);
                if (!misure.isEmpty()) return this.getConsumiIndiretto(contratto, misure, misureVolturaRettificate, misuraRiferimento, igmg);
                if (this.scivoloEnabled) {
                    ArrayList consumi = new ArrayList();
                    ArrayList<IgmgResult> igmgResults = new ArrayList<IgmgResult>();
                    ArrayList<MisuraGasResult> results = new ArrayList<MisuraGasResult>();
                    double qtconsum = contratto.getQtconsum();
                    return new ConsumiMesePdr(consumi, misure, misureVolturaRettificate, igmg, igmgResults, null, null, 0.0, false, true, results, qtconsum);
                }
                Date dataInizioTariffa = ContrattiHelper.getInizioTariffa(contratto, this.anno, this.mese);
                throw new MissingMisuraException(ErroreElaborazioneGas.MISSING_CONSUMI, azienda, codicePdr, dataInizioTariffa);
            }
            catch (CounterChangedException exc) {
                String message = exc.getMessage();
                Message sentence = new Message("tariffe", message);
                sentence.addParam(String.valueOf(codicePdr) + " / " + exc.getRiferimento());
                sentence.addParam(exc.getMatrMisOld());
                sentence.addParam(exc.getMatrMisNew());
                DateFormat shortDateFormat = StrategyHelper.getShortDateFormat();
                sentence.addParam(shortDateFormat.format(exc.getData()));
                sentence.addParam(exc.getFlusso());
                this.talkManager.addSentence(sentence);
                PrebillingError errore = exc.getErrore();
                String descrizione = this.talkManager.getMessage(sentence);
                Date dataFineMese = CalendarTools.getEndDate(this.anno, this.mese);
                this.status.addMisureResult(misurePeriodicheRettificate, dataFineMese, StatoMisure.SOSPESO, errore, descrizione);
                this.status.addIgmgResult(igmg, StatoMisure.SOSPESO, errore, descrizione);
                return consumiMesePdr;
            }
            catch (GiroContatoreSpurioException | MissingMisuraException exc) {
                PrebillingError errore = exc.getErrore();
                String descrizione = TariffeGasHelper.handleException(this.dateFormat, exc, this.talkManager);
                Date dataFineMese = CalendarTools.getEndDate(this.anno, this.mese);
                this.status.addMisureResult(misurePeriodicheRettificate, dataFineMese, StatoMisure.SOSPESO, errore, descrizione);
                this.status.addIgmgResult(igmg, StatoMisure.SOSPESO, errore, descrizione);
                throw exc;
            }
            catch (DataNotFoundException exc) {
                ErroreElaborazioneGas errore = StrategyHelper.getErrore(exc);
                String codice = String.valueOf(codicePdr) + " / " + contratto.getReseller();
                String key = exc.getKey();
                String message = exc.getMessage();
                String descrizione = TariffeGasHelper.handleException(codice, key, message, this.talkManager);
                Date dataFineMese = CalendarTools.getEndDate(this.anno, this.mese);
                this.status.addMisureResult(misurePeriodicheRettificate, dataFineMese, StatoMisure.SOSPESO, errore, descrizione);
                this.status.addIgmgResult(igmg, StatoMisure.SOSPESO, (PrebillingError)errore, descrizione);
                return consumiMesePdr;
            }
            catch (CoeffCorrChangedException exc) {
                String message = exc.getMessage();
                Message sentence = new Message("tariffe", message);
                sentence.addParam(String.valueOf(exc.getKey()) + " / " + exc.getRiferimento());
                double preCoeff = exc.getPreCoeff();
                double postCoeff = exc.getPostCoeff();
                Date preData = exc.getPreData();
                Date postData = exc.getData();
                sentence.addParam(String.valueOf(preCoeff));
                DateFormat shortDateFormat = StrategyHelper.getShortDateFormat();
                sentence.addParam(shortDateFormat.format(preData));
                sentence.addParam(String.valueOf(postCoeff));
                sentence.addParam(shortDateFormat.format(postData));
                this.talkManager.addSentence(sentence);
                PrebillingError errore = exc.getErrore();
                String descrizione = this.talkManager.getMessage(sentence);
                Date dataFineMese = CalendarTools.getEndDate(this.anno, this.mese);
                this.status.addMisureResult(misurePeriodicheRettificate, dataFineMese, StatoMisure.SOSPESO, errore, descrizione);
                this.status.addIgmgResult(igmg, StatoMisure.SOSPESO, errore, descrizione);
                throw exc;
            }
            catch (NoConverterException exc) {
                String message = exc.getMessage();
                String key = exc.getKey();
                Message sentence = new Message("tariffe", message);
                sentence.addParam(key);
                this.talkManager.addSentence(sentence);
                String descrizione = this.talkManager.getMessage(sentence);
                ErroreElaborazioneGas errore = StrategyHelper.getErrore(exc);
                Date dataFineMese = CalendarTools.getEndDate(this.anno, this.mese);
                this.status.addMisureResult(misurePeriodicheRettificate, dataFineMese, StatoMisure.SOSPESO, errore, descrizione);
                this.status.addIgmgResult(igmg, StatoMisure.SOSPESO, (PrebillingError)errore, descrizione);
                return consumiMesePdr;
            }
        }
        catch (MissingIngressoException exc) {
            PrebillingError errore = exc.getErrore();
            String descrizione = TariffeGasHelper.handleException(this.dateFormat, exc, this.talkManager);
            Date dataFineMese = CalendarTools.getEndDate(this.anno, this.mese);
            this.status.addMisureResult(misurePeriodiche, dataFineMese, StatoMisure.SOSPESO, errore, descrizione);
            this.status.addMisureResult(misureRettificaPeriodiche, dataFineMese, StatoMisure.SOSPESO, errore, descrizione);
            this.status.addIgmgResult(igmg, StatoMisure.SOSPESO, errore, descrizione);
            throw exc;
        }
    }

    private static MisuraGas getMisuraRiferimento(ContrattoGas contratto, int anno, Month mese, String matrConvRif, MisuraGas misRifMesePrec, MisureGasDao misureDao, TalkManager talkManager) throws MissingMisuraException, CoeffCorrChangedException {
        Date startDate = ContrattiHelper.getInizioTariffa(contratto, anno, mese);
        return ConsumiGruppoService.getMisuraRiferimento(contratto, startDate, matrConvRif, misRifMesePrec, misureDao, talkManager);
    }

    private static MisuraGas getMisuraRiferimento(ContrattoGas contratto, Date startDate, String matrConvRif, MisuraGas misRifMesePrecedente, MisureGasDao misureDao, TalkManager talkManager) throws MissingMisuraException, CoeffCorrChangedException {
        MisuraGas misuraContratto = TariffeGasHelper.getMisuraContratto(contratto, matrConvRif, startDate);
        MisuraGas misuraRiferimento = TariffeGasHelper.updateMisuraRiferimento(null, misuraContratto);
        misuraRiferimento = TariffeGasHelper.updateMisuraRiferimento(misuraRiferimento, misRifMesePrecedente);
        MisuraGas misuraPeriodicaRiferimento = misureDao.getMisuraPeriodicaRiferimento(contratto, startDate, talkManager);
        misuraRiferimento = TariffeGasHelper.updateMisuraRiferimento(misuraRiferimento, misuraPeriodicaRiferimento);
        MisuraGas misuraRettificaRiferimento = misureDao.getMisuraRettificaRiferimento(contratto, startDate, talkManager);
        if ((misuraRiferimento = TariffeGasHelper.updateMisuraRiferimento(misuraRiferimento, misuraRettificaRiferimento)) == null || misuraRiferimento.getDataMisura() == null) {
            String codice = contratto.getCodice();
            String azienda = contratto.getReseller();
            throw new MissingMisuraException(ErroreElaborazioneGas.MISSING_REFERENCE_MISURA, azienda, codice, startDate);
        }
        TariffeGasHelper.checkCoerenzaContratto(misuraContratto, misuraRiferimento, contratto.getReseller());
        return misuraRiferimento;
    }

    private List<MisuraGas> rettificaMisure(List<MisuraGas> misurePeriodiche, List<MisuraGas> misureRettifica, String azienda) throws MissingIngressoException {
        Date fineMese = CalendarTools.getEndDate(this.anno, this.mese);
        return this.rettificaMisure(fineMese, misurePeriodiche, misureRettifica, azienda);
    }

    private List<MisuraGas> rettificaMisure(Date dataFineMese, List<MisuraGas> misurePeriodiche, List<MisuraGas> misureRettifica, String azienda) throws MissingIngressoException {
        ArrayList<MisuraGas> misureRettificate = new ArrayList<MisuraGas>();
        MisuraGas tappo = new MisuraGas(null, null, null, CalendarTools.getEndOfTime(), TipoLettura.EFFETTIVA, null, null, 0.0, 0.0, 0.0, true, null);
        TappoIterator<MisuraGas> pIterator = new TappoIterator<MisuraGas>(misurePeriodiche.iterator(), tappo);
        TappoIterator<MisuraGas> rIterator = new TappoIterator<MisuraGas>(misureRettifica.iterator(), tappo);
        MisuraGas misura = (MisuraGas)pIterator.next();
        MisuraGas rettifica = (MisuraGas)rIterator.next();
        while (misura != tappo || rettifica != tappo) {
            MisuraGas candidate;
            TariffeGasHelper.checkIngresso(misura, azienda);
            TariffeGasHelper.checkIngresso(rettifica, azienda);
            Date dataMisura = misura.getDataMisura();
            Date dataRettifica = rettifica.getDataMisura();
            if (dataMisura.before(dataRettifica)) {
                candidate = misura;
                misura = (MisuraGas)pIterator.next();
                if (dataMisura.before(misura.getDataMisura())) {
                    misureRettificate.add(candidate);
                    continue;
                }
                ConsumiGruppoService.addMisuraObsoleta(candidate, dataFineMese, this.talkManager, this.status);
                continue;
            }
            if (dataMisura.after(dataRettifica)) {
                candidate = rettifica;
                rettifica = (MisuraGas)rIterator.next();
                if (dataRettifica.before(rettifica.getDataMisura())) {
                    misureRettificate.add(candidate);
                    continue;
                }
                ConsumiGruppoService.addRettificaObsoleta(candidate, dataFineMese, this.talkManager, this.status);
                continue;
            }
            ConsumiGruppoService.addMisuraObsoleta(misura, dataFineMese, this.talkManager, this.status);
            misura = (MisuraGas)pIterator.next();
        }
        ConsumiGruppoService.removeStimateNotLast(misureRettificate, dataFineMese, this.status, this.talkManager);
        return misureRettificate;
    }

    private static void addRettificaObsoleta(MisuraGas candidate, Date endDate, TalkManager talkManager, GasServiceStatus status) {
        if (!candidate.getDataMisura().after(endDate)) {
            ErroreElaborazioneGas errore = ErroreElaborazioneGas.OBSOLETO;
            String descrizione = StrategyHelper.getDescrizione(errore, null, talkManager);
            status.addRettificaResult(candidate, StatoMisure.OBSOLETO, errore, descrizione);
        }
    }

    private static void addMisuraObsoleta(MisuraGas candidate, Date endDate, TalkManager talkManager, GasServiceStatus status) {
        if (!candidate.getDataMisura().after(endDate)) {
            ErroreElaborazioneGas errore = ErroreElaborazioneGas.OBSOLETO;
            String descrizione = StrategyHelper.getDescrizione(errore, null, talkManager);
            status.addMisuraResult(candidate, StatoMisure.OBSOLETO, errore, descrizione);
        }
    }

    private static void removeStimateNotLast(List<MisuraGas> misureRettifica, Date dataFineMese, GasServiceStatus status, TalkManager talkManager) {
        if (!misureRettifica.isEmpty()) {
            Date lastDate = misureRettifica.get(misureRettifica.size() - 1).getDataMisura();
            Iterator<MisuraGas> iterator = misureRettifica.iterator();
            while (iterator.hasNext()) {
                MisuraGas misura = iterator.next();
                Date dataMisura = misura.getDataMisura();
                boolean last = dataMisura.equals(lastDate);
                boolean fineMese = dataMisura.equals(dataFineMese);
                if (!misura.isStimata()) continue;
                if (!last || last && !fineMese) {
                    iterator.remove();
                }
                if (dataMisura.after(dataFineMese) || misura.getStatoMisura().isElaborato()) continue;
                ErroreElaborazioneGas errore = ErroreElaborazioneGas.STIMA;
                String codicePdr = misura.getCodicePdr();
                DateFormat standardDateFormat = StrategyCommonHelper.getStandardDateFormat();
                String dataFmt = standardDateFormat.format(dataMisura);
                List<String> params = Arrays.asList(String.valueOf(codicePdr) + "/" + dataFmt);
                String descrizione = StrategyHelper.getDescrizione(errore, params, talkManager);
                status.addMisuraResult(misura, StatoMisure.ESCLUSO, errore, descrizione);
            }
        }
    }

    private ConsumiMesePdr getConsumiIndiretto(ContrattoGas contratto, List<MisuraGas> misure, List<MisuraGas> misureVoltura, MisuraGas misuraRiferimento, List<Igmg> igmgUtente) throws CounterChangedException, DataNotFoundException, CoeffCorrChangedException, NoConverterException, GiroContatoreSpurioException {
        Date dataInizioTariffa = ContrattiHelper.getInizioTariffa(contratto, this.anno, this.mese);
        Date endDate = CalendarTools.getNextMese(this.anno, this.mese);
        MisuraGas prevMisura = misuraRiferimento;
        String codicePdr = contratto.getCodice();
        Date endOfTime = CalendarTools.getEndOfTime();
        Igmg tappo = new Igmg(null, codicePdr, endOfTime, null, null, 0.0, 0.0, 0.0, null, null, 0.0, 0.0, 0.0, null);
        Iterator<Igmg> igmgIterator = igmgUtente.iterator();
        TappoIterator<Igmg> iterator = new TappoIterator<Igmg>(igmgIterator, tappo);
        Igmg igmg = iterator.next();
        ArrayList<IgmgResult> igmgResults = new ArrayList<IgmgResult>();
        boolean scivolo = false;
        ArrayList<Consumo> consumi = new ArrayList<Consumo>();
        ArrayList<MisuraGasResult> misureResults = new ArrayList<MisuraGasResult>();
        for (MisuraGas misura : misure) {
            Date dataPrevMisura = prevMisura.getDataMisura();
            Date dataMisura = misura.getDataMisura();
            Date dataIgmg = igmg.getDataMisura();
            if (!dataMisura.after(dataPrevMisura)) continue;
            Date dataAttesa = CalendarTools.nextDay(dataPrevMisura);
            if (!dataAttesa.before(endDate)) break;
            if (dataMisura.before(dataIgmg)) {
                Triplet<ErroreElaborazioneGas, String, Boolean> result = this.handleMisura(contratto, prevMisura, misura, dataAttesa, dataInizioTariffa, endDate, null, consumi);
                scivolo |= result.getValue2().booleanValue();
                ErroreElaborazioneGas erroreMisura = result.getValue0();
                if (erroreMisura != null && erroreMisura != ErroreElaborazioneGas.OK) {
                    String descrizione = result.getValue1();
                    MisuraGasResult misuraResult = new MisuraGasResult(misura, StatoMisure.ELABORATO, (PrebillingError)erroreMisura, descrizione);
                    misureResults.add(misuraResult);
                }
            } else {
                Triplet<IgmgResult, MisuraGasResult, Boolean> results = this.handleIgmg(contratto, prevMisura, igmg, misura, dataAttesa, dataInizioTariffa, endDate, consumi);
                IgmgResult igmgResult = results.getValue0();
                igmgResults.add(igmgResult);
                scivolo |= results.getValue2().booleanValue();
                MisuraGasResult misuraResult = results.getValue1();
                if (misuraResult != null) {
                    misureResults.add(misuraResult);
                    scivolo |= results.getValue2().booleanValue();
                }
                igmg = iterator.next();
            }
            prevMisura = misura;
        }
        double coeffCorr = misuraRiferimento.getCoeffCorr();
        Date dataFineMese = CalendarTools.getEndDate(this.anno, this.mese);
        boolean trattate = ConsumiGruppoService.isTrattate(misure, dataFineMese);
        double qtconsum = contratto.getQtconsum();
        return new ConsumiMesePdr(consumi, misure, misureVoltura, igmgUtente, igmgResults, null, null, coeffCorr, trattate, scivolo, misureResults, qtconsum);
    }

    private static String getMatricolaConv(MisuraGas primaMisura) {
        return primaMisura == null ? null : primaMisura.getMatrConv();
    }

    private static MisuraGas getPrimaMisura(List<MisuraGas> misureRettificate, List<Igmg> igmg) {
        MisuraGas primaMisura = null;
        Date dataPrimaMisura = null;
        if (!misureRettificate.isEmpty()) {
            primaMisura = misureRettificate.get(0);
            dataPrimaMisura = primaMisura.getDataMisura();
        }
        if (!igmg.isEmpty()) {
            MisuraGas primaMisuraIgmg = igmg.get(0).getMisuraPre();
            if (dataPrimaMisura == null || dataPrimaMisura.after(primaMisuraIgmg.getDataMisura())) {
                primaMisura = primaMisuraIgmg;
            }
        }
        return primaMisura;
    }

    private static boolean isTrattate(List<MisuraGas> misure, Date lastDate) {
        boolean trattate = false;
        if (!misure.isEmpty()) {
            trattate = true;
            Iterator<MisuraGas> iterator = misure.iterator();
            while (trattate && iterator.hasNext()) {
                MisuraGas misura = iterator.next();
                Date dataMisura = misura.getDataMisura();
                StatoMisure statoMisura = misura.getStatoMisura();
                trattate = statoMisura.isTrattato();
                if (!dataMisura.before(lastDate)) break;
            }
        }
        return trattate;
    }

    private Triplet<IgmgResult, MisuraGasResult, Boolean> handleIgmg(ContrattoGas contratto, MisuraGas prevMisura, Igmg igmg, MisuraGas misura, Date dataAttesa, Date startDate, Date endDate, List<Consumo> consumi) throws CounterChangedException, CoeffCorrChangedException, NoConverterException, DataNotFoundException, GiroContatoreSpurioException {
        MisuraGasResult misuraResult;
        MisuraGas misuraPre = igmg.getMisuraPre();
        Date dataIgmg = igmg.getDataMisura();
        Date dataFine = CalendarTools.min(endDate, CalendarTools.nextDay(dataIgmg));
        Triplet<ErroreElaborazioneGas, String, Boolean> preResult = this.handleMisura(contratto, prevMisura, misuraPre, dataAttesa, startDate, dataFine, dataIgmg, consumi);
        ErroreElaborazioneGas preErrore = preResult.getValue0();
        String preDescrizione = preResult.getValue1();
        IgmgResult igmgResult = new IgmgResult(igmg, StatoMisure.ELABORATO, (PrebillingError)preErrore, preDescrizione);
        boolean scivolo = preResult.getValue2();
        if (dataIgmg.before(endDate)) {
            MisuraGas misuraPost = igmg.getMisuraPost();
            Triplet<ErroreElaborazioneGas, String, Boolean> postResult = this.handleMisura(contratto, misuraPost, misura, dataIgmg, startDate, endDate, dataIgmg, consumi);
            ErroreElaborazioneGas postErrore = postResult.getValue0();
            String postDescrizione = postResult.getValue1();
            scivolo |= postResult.getValue2().booleanValue();
            misuraResult = new MisuraGasResult(misura, StatoMisure.ELABORATO, (PrebillingError)postErrore, postDescrizione);
        } else {
            misuraResult = null;
        }
        return new Triplet<IgmgResult, Object, Boolean>(igmgResult, misuraResult, scivolo);
    }

    private Triplet<ErroreElaborazioneGas, String, Boolean> handleMisura(ContrattoGas contratto, MisuraGas prevMisura, MisuraGas misura, Date dataAttesa, Date startDate, Date endDate, Date dataIgmg, List<Consumo> consumi) throws CounterChangedException, DataNotFoundException, CoeffCorrChangedException, NoConverterException, GiroContatoreSpurioException {
        Quartet<Double, ErroreElaborazioneGas, String, Boolean> consumo;
        double consumoCompl;
        Date dataMisura = misura.getDataMisura();
        String codicePdr = contratto.getCodice();
        Quartet<Double, ErroreElaborazioneGas, String, Boolean> consumoMis = this.getConsumoComplessivo(contratto, prevMisura, misura, MIS_HANDLER);
        double consumoComplMis = consumoMis.getValue0();
        TipoLettoreHandler convHandler = prevMisura.hasConvertitore() ? CHECKING_CONV_HANDLER : CONV_HANDLER;
        Quartet<Double, ErroreElaborazioneGas, String, Boolean> consumoConv = this.getConsumoComplessivo(contratto, prevMisura, misura, convHandler);
        double consumoComplConv = consumoConv.getValue0();
        boolean convertitore = misura.hasConvertitore();
        if (convertitore) {
            consumoCompl = consumoComplConv;
            consumo = consumoConv;
        } else {
            double coeffCorr = misura.getCoeffCorr();
            consumoCompl = consumoComplMis * coeffCorr;
            consumo = consumoMis;
        }
        String flusso = misura.getFlusso();
        if (dataMisura.equals(dataAttesa)) {
            double segnanteMis = misura.getSegnanteMisuratore();
            double segnanteConv = misura.getSegnanteConvertitore();
            TariffeGasHelper.handleConsumo(dataMisura, consumoCompl, convertitore, segnanteMis, segnanteConv, consumi, "", flusso);
        } else {
            Consumo lastConsumo;
            String cdProPre = contratto.getCdProPre();
            List<ProfiloPrelievo> profiliPrelievo = this.getProfiliPrelievo(cdProPre, dataAttesa, dataMisura);
            double sommaValoriProfili = ConsumiGruppoService.getSommaValoriProfili(profiliPrelievo);
            double coeffRip = consumoCompl / sommaValoriProfili;
            double coeffRipMis = consumoComplMis / sommaValoriProfili;
            double coeffRipConv = consumoComplConv / sommaValoriProfili;
            double consumoAssegnato = 0.0;
            double segnanteMis = prevMisura.getSegnanteMisuratore();
            double segnanteConv = prevMisura.getSegnanteConvertitore();
            Iterator<ProfiloPrelievo> ppIterator = profiliPrelievo.iterator();
            do {
                if (!ppIterator.hasNext()) {
                    ErroreElaborazioneGas errore = ErroreElaborazioneGas.MISSING_PROFILO;
                    String message = errore.getMessage();
                    int ordinal = errore.ordinal();
                    throw new DataNotFoundException(message, codicePdr, ordinal);
                }
                ProfiloPrelievo profiloPrelievo = ppIterator.next();
                Date dataValidita = profiloPrelievo.getDataValidita();
                if (!dataValidita.before(endDate)) break;
                if (dataValidita.before(startDate)) continue;
                double valoreProfilo = profiloPrelievo.getValore();
                if (dataValidita.equals(dataIgmg)) {
                    valoreProfilo /= 2.0;
                }
                double valCons = MathUtils.round(coeffRip * valoreProfilo, 6);
                double valConsMis = MathUtils.round(coeffRipMis * valoreProfilo, 6);
                segnanteMis = TariffeGasHelper.checkGiroContatore(contratto, segnanteMis + valConsMis);
                double valConsConv = MathUtils.round(coeffRipConv * valoreProfilo, 6);
                segnanteConv = TariffeGasHelper.checkGiroContatore(contratto, segnanteConv + valConsConv);
                consumoAssegnato += valCons;
                TariffeGasHelper.handleConsumo(dataValidita, valCons, convertitore, segnanteMis, segnanteConv, consumi, "R", flusso);
            } while (ppIterator.hasNext());
            if (dataMisura.equals((lastConsumo = consumi.get(consumi.size() - 1)).getDataMisura())) {
                double scarto = consumoCompl - consumoAssegnato;
                lastConsumo.addConsumo(scarto);
            }
        }
        ErroreElaborazioneGas errore = consumo.getValue1();
        String descrizione = consumo.getValue2();
        Boolean scivolo = consumo.getValue3();
        return new Triplet<ErroreElaborazioneGas, String, Boolean>(errore, descrizione, scivolo);
    }

    private static double getSommaValoriProfili(List<ProfiloPrelievo> profiliPrelievo) {
        double sommaValoriProfili = 0.0;
        for (ProfiloPrelievo profiloPrelievo : profiliPrelievo) {
            sommaValoriProfili += profiloPrelievo.getValore();
        }
        return sommaValoriProfili;
    }

    private List<ProfiloPrelievo> getProfiliPrelievo(String cdProPre, Date dataAttesa, Date dataMisura) throws DataNotFoundException, MultipleRowException {
        ArrayList<ProfiloPrelievo> profiliPrelievo = new ArrayList<ProfiloPrelievo>();
        ElaborCalendar calendar = new ElaborCalendar(dataAttesa);
        Date actualDate = calendar.getDate();
        while (!actualDate.after(dataMisura)) {
            ProfiloPrelievo profiloPrelievo = this.giadaDao.getProfiloPrelievo(cdProPre, actualDate);
            profiliPrelievo.add(profiloPrelievo);
            calendar.addGiorni(1);
            actualDate = calendar.getDate();
        }
        return profiliPrelievo;
    }

    /*
     * Enabled aggressive block sorting
     */
    private Quartet<Double, ErroreElaborazioneGas, String, Boolean> getConsumoComplessivo(ContrattoGas contratto, MisuraGas prevMisura, MisuraGas misura, TipoLettoreHandler handler) throws CounterChangedException, CoeffCorrChangedException, NoConverterException, GiroContatoreSpurioException {
        String flusso;
        Boolean scivolo;
        ErroreElaborazioneGas errore;
        double consumoComplessivo;
        block5: {
            int numCifre;
            block6: {
                TariffeGasHelper.checkContinuita(contratto, prevMisura, misura);
                numCifre = contratto.getNumCifre();
                double segnantePrev = handler.getSegnante(prevMisura);
                double segnanteMisura = handler.getSegnante(misura);
                consumoComplessivo = segnanteMisura - segnantePrev;
                errore = ErroreElaborazioneGas.OK;
                scivolo = Boolean.FALSE;
                flusso = misura.getFlusso();
                if (!(consumoComplessivo < 0.0)) break block5;
                if (!this.configuration.checkGiroContatore()) break block6;
                String flussoPre = prevMisura.getFlusso();
                if (Math.abs(consumoComplessivo) <= this.configuration.getTolleranzaConsumo() || flusso.toLowerCase().equals("igmg") && flussoPre.toLowerCase().equals("rgl")) {
                    consumoComplessivo = 0.0;
                    handler.setSegnante(misura, segnantePrev);
                    errore = ErroreElaborazioneGas.MISURA_RIALLINEATA;
                    break block5;
                } else {
                    double giroContatore = Math.pow(10.0, numCifre);
                    if ((consumoComplessivo += giroContatore) > giroContatore / 2.0) {
                        if (!this.forceSopraSoglia) {
                            String codicePdr = contratto.getCodice();
                            String azienda = contratto.getReseller();
                            Date dataMisura = misura.getDataMisura();
                            throw new GiroContatoreSpurioException(azienda, codicePdr, dataMisura, flusso);
                        }
                        errore = ErroreElaborazioneGas.GIRO_CONTATORE_SPURIO;
                        scivolo = Boolean.TRUE;
                    }
                }
                break block5;
            }
            double giroContatore = Math.pow(10.0, numCifre);
            consumoComplessivo += giroContatore;
        }
        Message sentence = new Message("consumo", errore.getMessage());
        String codicePdr = misura.getCodicePdr();
        String azienda = contratto.getReseller();
        sentence.addParam(String.valueOf(codicePdr) + " / " + azienda);
        Date dataMisura = misura.getDataMisura();
        sentence.addParam(this.dateFormat.format(dataMisura));
        sentence.addParam(flusso);
        String descrizione = this.talkManager.getMessage(sentence);
        if (!descrizione.isEmpty()) {
            this.talkManager.addSentence(sentence);
        }
        return new Quartet<Double, ErroreElaborazioneGas, String, Boolean>(consumoComplessivo, errore, descrizione, scivolo);
    }
}

