/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.gas.services.common;

import biz.elabor.prebilling.common.AbstractCheckStatusStrategy;
import biz.elabor.prebilling.common.dao.StatoElaborazione;
import biz.elabor.prebilling.common.dao.TipoStato;
import biz.elabor.prebilling.gas.Funzionalita;
import biz.elabor.prebilling.gas.config.ConfigurationHelper;
import biz.elabor.prebilling.gas.config.PrebillingGasConfiguration;
import biz.elabor.prebilling.gas.dao.misure.MisureGasDao;
import biz.elabor.prebilling.gas.services.GasServiceStatus;
import biz.elabor.prebilling.gas.services.GasServiceStrategy;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.homelinux.elabor.db.DataNotFoundException;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;

public class CheckGasStatusStrategy
extends AbstractCheckStatusStrategy
implements GasServiceStrategy {
    private final List<Funzionalita> funzionalita;
    private final String ambito;
    private final List<String> ambiti;
    private final PrebillingGasConfiguration configuration;
    private final MisureGasDao misuredao;

    public CheckGasStatusStrategy(Funzionalita funzionalita, String azienda, String message, PrebillingGasConfiguration configuration, MisureGasDao misuredao, TalkManager talkManager) {
        this(Arrays.asList(funzionalita), azienda, message, configuration, misuredao, talkManager);
    }

    public CheckGasStatusStrategy(List<Funzionalita> funzionalita, String azienda, String message, PrebillingGasConfiguration configuration, MisureGasDao misuredao, TalkManager talkManager) {
        super(azienda, message, talkManager);
        this.funzionalita = funzionalita;
        this.ambito = CheckGasStatusStrategy.getAmbito(azienda);
        this.ambiti = CheckGasStatusStrategy.getAmbiti(azienda);
        this.configuration = configuration;
        this.misuredao = misuredao;
    }

    @Override
    public boolean execute(GasServiceStatus status) {
        String idEsecuzione = status.getIdEsecuzione();
        Date date = this.configuration.getToDay();
        return this.execute(date, idEsecuzione);
    }

    @Override
    protected File getTmpFolder(String idEsecuzione) {
        return ConfigurationHelper.getTmpFolder(this.configuration, idEsecuzione, this.funzionalita.get(0));
    }

    @Override
    protected StatoElaborazione getStato() throws DataNotFoundException {
        return this.misuredao.getStato(this.funzionalita, this.ambiti);
    }

    @Override
    protected void saveStato(TipoStato stato, Date date, String idEsecuzione) {
        this.misuredao.saveStato(this.funzionalita.get(0), this.ambito, stato, date, idEsecuzione);
    }

    private static String getAmbito(String azienda) {
        return azienda.isEmpty() ? "*" : azienda;
    }

    private static List<String> getAmbiti(String azienda) {
        ArrayList<String> ambiti = new ArrayList<String>();
        if (azienda.isEmpty() || azienda.equals("*")) {
            ambiti.add("RESELLER-%");
        } else {
            ambiti.add("RESELLER-" + azienda);
            ambiti.add("RESELLER-*");
        }
        return ambiti;
    }
}

