/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.gas.services.consumi;

import biz.elabor.prebilling.common.StrategyCommonHelper;
import biz.elabor.prebilling.gas.config.ConfigurationGasInstance;
import biz.elabor.prebilling.gas.config.PrebillingGasConfiguration;
import biz.elabor.prebilling.gas.dao.misure.MisureGasDao;
import biz.elabor.prebilling.gas.services.consumi.ExportConsumiGasStrategiesHandler;
import biz.elabor.prebilling.gas.web.AbstractGasRequestHandler;
import biz.elabor.prebilling.gas.web.JsonGasRequestHandler;
import biz.elabor.prebilling.util.JsonHelper;
import biz.elabor.prebilling.util.Results;
import java.io.File;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import org.homelinux.elabor.springtools.web.check.InvalidParameterValue;
import org.homelinux.elabor.springtools.web.controllers.ControllerHelper;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;
import org.homelinux.elabor.tools.StringUtils;

public class ExportConsumiHandler
extends AbstractGasRequestHandler
implements JsonGasRequestHandler {
    private final String dataInizioTxt;
    private final String dataFineTxt;
    private final String[] codiciPdr;
    private final String azienda;
    private final String pathOutput;

    public ExportConsumiHandler(String dataInizioTxt, String dataFineTxt, String[] codiciPdr, String azienda, String pathOutput, TalkManager talkManager) {
        super("export_consumi", talkManager);
        this.dataInizioTxt = dataInizioTxt;
        this.dataFineTxt = dataFineTxt;
        this.codiciPdr = codiciPdr;
        this.azienda = StringUtils.isEmpty(azienda) ? "*" : azienda;
        this.pathOutput = pathOutput;
    }

    @Override
    public String handleRequest(ConfigurationGasInstance confInstance) throws InvalidParameterValue {
        DateFormat dateFormat = StrategyCommonHelper.getStandardDateFormat();
        Date dataInizio = ControllerHelper.checkData("data_inizio", this.dataInizioTxt, dateFormat);
        Date dataFine = ControllerHelper.checkData("data_fine", this.dataFineTxt, dateFormat);
        PrebillingGasConfiguration configuration = confInstance.getConfiguration();
        File outpuFolder = this.pathOutput.isEmpty() ? configuration.getConsumiOutputFolder(this.azienda) : new File(this.pathOutput);
        MisureGasDao misureDao = confInstance.getMisureDao();
        ExportConsumiGasStrategiesHandler consumiHandler = new ExportConsumiGasStrategiesHandler(dataInizio, dataFine, this.codiciPdr, this.azienda, outpuFolder, confInstance, this.talkManager);
        Results results = this.handleRequest(consumiHandler, configuration, misureDao);
        return JsonHelper.buildMessage(configuration, results, this.talkManager);
    }

    @Override
    protected LinkedHashMap<String, Object> getParams() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("data_inizio", this.dataInizioTxt);
        params.put("data_fine", this.dataFineTxt);
        List<String> pdrs = Arrays.asList(this.codiciPdr);
        params.put("pod", pdrs.subList(0, Math.min(10, pdrs.size())));
        params.put("path", this.pathOutput);
        return params;
    }

    @Override
    protected String getReseller() {
        return this.azienda;
    }
}

