/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.gas.services.pcs;

import biz.elabor.prebilling.gas.dao.misure.model.Cliente;
import java.util.List;

public class PcsRemi {
    private final Cliente cliente;
    private final List<Double> consumiMese;
    private final List<Double> pcsMese;
    private double pcsMedio;
    private double sommaValori;
    private double sommaConsumi;

    public PcsRemi(Cliente cliente, List<Double> consumiMese, List<Double> pcsMese) {
        this.cliente = cliente;
        this.consumiMese = consumiMese;
        this.pcsMese = pcsMese;
        this.calcola();
    }

    private void calcola() {
        this.sommaValori = 0.0;
        this.sommaConsumi = 0.0;
        int index = 0;
        for (Double consumo : this.consumiMese) {
            Double pcs = this.pcsMese.get(index);
            double value = pcs * consumo;
            this.sommaValori += value;
            this.sommaConsumi += consumo.doubleValue();
            ++index;
        }
        this.pcsMedio = this.sommaConsumi < 1.0E-6 ? 0.0 : this.sommaValori / this.sommaConsumi;
    }

    public List<Double> getConsumiMese() {
        return this.consumiMese;
    }

    public List<Double> getPcsMese() {
        return this.pcsMese;
    }

    public double getPcsMedio() {
        return this.pcsMedio;
    }

    public double getSommaValori() {
        return this.sommaValori;
    }

    public double getSommaConsumi() {
        return this.sommaConsumi;
    }

    public Cliente getCliente() {
        return this.cliente;
    }
}

