/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.gas.services.tariffe;

import biz.elabor.prebilling.gas.services.tariffe.ConsumiMesePdr;
import biz.elabor.prebilling.gas.services.tariffe.model.Consumo;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.homelinux.elabor.calendar.CalendarTools;
import org.homelinux.elabor.calendar.DateInterval;
import org.javatuples.Pair;

public class ConsumiGruppo {
    private final Map<String, Pair<ConsumiMesePdr, DateInterval>> mappaConsumiPdr;
    private final String codRaggruppamento;
    private final boolean ok;

    public ConsumiGruppo(String codRaggruppamento, boolean ok) {
        this.codRaggruppamento = codRaggruppamento;
        this.mappaConsumiPdr = new HashMap<String, Pair<ConsumiMesePdr, DateInterval>>();
        this.ok = ok;
    }

    public ConsumiMesePdr getConsumiPdr(String codicePdr) {
        Pair<ConsumiMesePdr, DateInterval> pairConsumiPdr = this.mappaConsumiPdr.get(codicePdr);
        return pairConsumiPdr == null ? null : pairConsumiPdr.getValue0();
    }

    public boolean isEmpty() {
        return this.mappaConsumiPdr.isEmpty();
    }

    public void addConsumi(String codicePdr, ConsumiMesePdr consumiDataPdr, DateInterval multipuntoInterval) {
        this.put(codicePdr, consumiDataPdr, multipuntoInterval);
    }

    private void put(String codicePdr, ConsumiMesePdr consumiPdr, DateInterval multipuntoInterval) {
        Pair<ConsumiMesePdr, DateInterval> result = new Pair<ConsumiMesePdr, DateInterval>(consumiPdr, multipuntoInterval);
        this.mappaConsumiPdr.put(codicePdr, result);
    }

    public boolean isMissing(String codicePdr) {
        return this.mappaConsumiPdr.get(codicePdr) == null;
    }

    public List<Consumo> getConsumiComplessiviGruppo() {
        ArrayList<Consumo> consumiComplessivi = new ArrayList<Consumo>();
        Set<Map.Entry<String, Pair<ConsumiMesePdr, DateInterval>>> entrySet = this.mappaConsumiPdr.entrySet();
        for (Map.Entry<String, Pair<ConsumiMesePdr, DateInterval>> entry : entrySet) {
            Pair<ConsumiMesePdr, DateInterval> pairConsumiPdr = entry.getValue();
            ConsumiMesePdr consumiPdr = pairConsumiPdr.getValue0();
            DateInterval multipuntoInterval = pairConsumiPdr.getValue1();
            Date inizio = multipuntoInterval.getInizio();
            Date fine = multipuntoInterval.getFine();
            if (consumiPdr == null) continue;
            for (Consumo consumoPdr : consumiPdr.getConsumi(inizio, fine)) {
                ConsumiGruppo.addConsumo(consumiComplessivi, consumoPdr);
            }
        }
        return consumiComplessivi;
    }

    public boolean isMultipunto(String codicePdr, Date dataInizioTariffa, Date dataFineTariffa) {
        DateInterval groupInterval = this.getGroupInterval(codicePdr);
        Date inizioGruppo = groupInterval.getInizio();
        Date fineGruppo = groupInterval.getFine();
        return inizioGruppo != null && CalendarTools.overlaps(inizioGruppo, fineGruppo, dataInizioTariffa, dataFineTariffa);
    }

    private static void addConsumo(List<Consumo> consumiComplessivi, Consumo consumoPdr) {
        Date dataMisura = consumoPdr.getDataMisura();
        double valore = consumoPdr.getValore();
        String flusso = consumoPdr.getFlusso();
        int index = 0;
        while (index < consumiComplessivi.size()) {
            Consumo current = consumiComplessivi.get(index);
            Date currentData = current.getDataMisura();
            if (!currentData.before(dataMisura)) {
                if (currentData.equals(dataMisura)) {
                    current.addConsumo(valore);
                    break;
                }
                Consumo complessivo = new Consumo(dataMisura, valore, flusso);
                consumiComplessivi.add(index, complessivo);
                break;
            }
            ++index;
        }
        if (index == consumiComplessivi.size()) {
            Consumo complessivo = new Consumo(dataMisura, valore, flusso);
            consumiComplessivi.add(complessivo);
        }
    }

    public DateInterval getGroupInterval(String codicePdr) {
        return this.mappaConsumiPdr.get(codicePdr).getValue1();
    }

    public List<Consumo> getConsumiComplessivi(String codicePdr, Date dataInizioTariffa, Date dataFineTariffa) {
        ConsumiMesePdr consumiPdr;
        List<Consumo> consumi = this.isMultipunto(codicePdr, dataInizioTariffa, dataFineTariffa) ? this.getConsumiComplessiviGruppo() : ((consumiPdr = this.getConsumiPdr(codicePdr)) == null ? null : consumiPdr.getConsumi(dataInizioTariffa, dataFineTariffa));
        return consumi;
    }

    public Set<String> getPdrSet() {
        return this.mappaConsumiPdr.keySet();
    }

    public boolean isTrattate() {
        boolean trattate = true;
        for (Pair<ConsumiMesePdr, DateInterval> pairConsumiPdr : this.mappaConsumiPdr.values()) {
            ConsumiMesePdr consumiPdr = pairConsumiPdr.getValue0();
            if (consumiPdr != null && consumiPdr.isTrattate()) continue;
            trattate = false;
            break;
        }
        return trattate;
    }

    public String getCodRaggruppamento() {
        return this.codRaggruppamento;
    }

    public double getConsumoTotaleFixingSwap() {
        double consumoTotaleFixingSwap = 0.0;
        for (Pair<ConsumiMesePdr, DateInterval> consumi : this.mappaConsumiPdr.values()) {
            double consumoFixingSwap = consumi.getValue0().getQtconsum();
            consumoTotaleFixingSwap += consumoFixingSwap;
        }
        return consumoTotaleFixingSwap;
    }

    public boolean isOk() {
        return this.ok;
    }
}

