/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.gas.services.tariffe;

import biz.elabor.prebilling.InconsistentOptionException;
import biz.elabor.prebilling.gas.config.PrebillingGasConfiguration;
import biz.elabor.prebilling.gas.dao.misure.MisureGasDao;
import biz.elabor.prebilling.gas.services.GasServiceStatus;
import biz.elabor.prebilling.gas.services.GasServiceStrategy;
import biz.elabor.prebilling.gas.services.tariffe.DownloadPrezziService;
import java.io.IOException;
import java.text.ParseException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.homelinux.elabor.calendar.Month;
import org.homelinux.elabor.db.DataNotFoundException;
import org.homelinux.elabor.springtools.web.widgets.Message;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;

public class DownloadPrezziGas
implements GasServiceStrategy {
    private final int anno;
    private final Month mese;
    private final MisureGasDao misureDao;
    private final String prezziBaseUrl;
    private final boolean bloccoIndice;
    private final TalkManager talkManager;

    public DownloadPrezziGas(int anno, Month mese, boolean bloccoIndice, MisureGasDao misureDao, PrebillingGasConfiguration configuration, TalkManager talkManager) {
        this.anno = anno;
        this.mese = mese;
        this.bloccoIndice = bloccoIndice;
        this.misureDao = misureDao;
        this.prezziBaseUrl = configuration.getPrezziBaseUrl();
        this.talkManager = talkManager;
    }

    @Override
    public boolean execute(GasServiceStatus status) {
        boolean ok;
        try {
            DownloadPrezziService.downloadPrezzi(this.anno, this.mese, null, this.prezziBaseUrl, this.bloccoIndice, this.misureDao, this.talkManager);
            ok = true;
        }
        catch (IOException exc) {
            ok = false;
            Message sentence = new Message("prezzi", "dwnl.failed");
            sentence.addParam(exc.toString());
            this.talkManager.addSentence(sentence);
            String userMessage = this.talkManager.getMessage(sentence);
            Logger logger = status.getLogger();
            logger.log(Level.SEVERE, userMessage, exc);
        }
        catch (ParseException exc) {
            ok = false;
            Message sentence = new Message("prezzi", "parse.errore");
            sentence.addParam(exc.toString());
            this.talkManager.addSentence(sentence);
            String userMessage = this.talkManager.getMessage(sentence);
            Logger logger = status.getLogger();
            logger.log(Level.SEVERE, userMessage, exc);
        }
        catch (DataNotFoundException exc) {
            ok = true;
            Message sentence = new Message("prezzi", exc.getMessage());
            sentence.addParam(exc.getKey());
            this.talkManager.addSentence(sentence);
        }
        catch (InconsistentOptionException exc) {
            ok = true;
        }
        return ok;
    }
}

