/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.gas.services.tariffe;

import biz.elabor.prebilling.InconsistentOptionException;
import biz.elabor.prebilling.common.MisuraException;
import biz.elabor.prebilling.common.StrategyCommonHelper;
import biz.elabor.prebilling.common.utils.MissingCodicePerseoException;
import biz.elabor.prebilling.gas.dao.misure.MisureGasDao;
import biz.elabor.prebilling.gas.dao.misure.model.OffertaGas;
import biz.elabor.prebilling.gas.dao.misure.model.PrezzoGas;
import biz.elabor.prebilling.gas.services.StrategyHelper;
import biz.elabor.prebilling.gas.services.common.ErroreElaborazioneGas;
import biz.elabor.prebilling.gas.services.tariffe.MissingPrezziException;
import biz.elabor.prebilling.gas.services.tariffe.OffertaGasCondition;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Logger;
import org.homelinux.elabor.arrays.Filter;
import org.homelinux.elabor.calendar.ElaborCalendar;
import org.homelinux.elabor.calendar.Month;
import org.homelinux.elabor.db.DataNotFoundException;
import org.homelinux.elabor.springtools.web.widgets.Message;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;
import org.homelinux.elabor.structures.listmap.SafeListMap;
import org.homelinux.elabor.tools.MathUtils;
import org.homelinux.elabor.tools.StringUtils;

class DownloadPrezziService {
    DownloadPrezziService() {
    }

    public static void updatePrezzi(Map<Date, PrezzoGas> prezziPerseo, List<PrezzoGas> prezziDb, String indice, boolean bloccoIndice, MisureGasDao misureDao, TalkManager talkManager) throws InconsistentOptionException {
        LinkedHashSet<PrezzoGas> prezziToSave = new LinkedHashSet<PrezzoGas>();
        DownloadPrezziService.checkPrezziMancanti(prezziPerseo, prezziDb, prezziToSave);
        DownloadPrezziService.checkVariazioniPrezzo(prezziPerseo, prezziDb, indice, prezziToSave, bloccoIndice, talkManager);
        DownloadPrezziService.savePrezzi(prezziToSave, misureDao);
    }

    private static void savePrezzi(Set<PrezzoGas> prezziToSave, MisureGasDao misureDao) {
        for (PrezzoGas prezzo : prezziToSave) {
            misureDao.savePrezzo(prezzo.getIndice(), prezzo.getData(), prezzo.getValore());
        }
    }

    private static void checkVariazioniPrezzo(Map<Date, PrezzoGas> prezziPerseo, List<PrezzoGas> prezziDb, String indice, Set<PrezzoGas> prezziToSave, boolean bloccoIndice, TalkManager talkManager) throws InconsistentOptionException {
        for (PrezzoGas prezzoDb : prezziDb) {
            Date data = prezzoDb.getData();
            PrezzoGas prezzoPerseo = prezziPerseo.get(data);
            double valorePerseo = prezzoPerseo.getValore();
            double valoreDb = prezzoDb.getValore();
            if (MathUtils.round(valorePerseo, 3) == valoreDb) continue;
            ErroreElaborazioneGas errore = ErroreElaborazioneGas.PRICE_CHANGES;
            String message = errore.getMessage();
            Message sentence = new Message("prezzi", message);
            sentence.addParam(indice);
            DateFormat dateFormat = StrategyCommonHelper.getStandardDateFormat();
            sentence.addParam(dateFormat.format(data));
            sentence.addParam(indice);
            talkManager.addSentence(sentence);
            if (bloccoIndice) {
                throw new InconsistentOptionException(indice, data, null, 0.0, 0.0, errore);
            }
            prezziToSave.add(prezzoPerseo);
        }
    }

    private static void checkPrezziMancanti(Map<Date, PrezzoGas> prezziPerseo, List<PrezzoGas> prezziDb, Set<PrezzoGas> prezziToSave) {
        Iterator<PrezzoGas> iteratorDb = prezziDb.iterator();
        PrezzoGas prezzoDb = iteratorDb.hasNext() ? iteratorDb.next() : null;
        for (Map.Entry<Date, PrezzoGas> entryPrezzoPerseo : prezziPerseo.entrySet()) {
            Date dataDb;
            Date dataPerseo = entryPrezzoPerseo.getKey();
            Date date = dataDb = prezzoDb == null ? null : prezzoDb.getData();
            if (!dataPerseo.equals(dataDb)) {
                prezziToSave.add(entryPrezzoPerseo.getValue());
            }
            PrezzoGas prezzoGas = prezzoDb = iteratorDb.hasNext() ? iteratorDb.next() : null;
        }
    }

    public static void downloadPrezzi(int anno, Month mese, String onlyIndice, String prezziBaseUrl, boolean bloccoIndice, MisureGasDao misureDao, TalkManager talkManager) throws IOException, ParseException, DataNotFoundException, InconsistentOptionException {
        if (prezziBaseUrl != null && !prezziBaseUrl.trim().isEmpty()) {
            SafeListMap<String, PrezzoGas> prezziMap = misureDao.getPrezzi(anno, mese);
            Iterable<OffertaGas> offerte = DownloadPrezziService.getOfferte(misureDao, onlyIndice);
            for (OffertaGas offerta : offerte) {
                String indice;
                Message sentence;
                String message;
                String key = offerta.getIndice();
                List<PrezzoGas> prezziDb = DownloadPrezziService.getPrezziOfferta(key, prezziMap);
                try {
                    Logger logger = talkManager.getLogger();
                    Map<Date, PrezzoGas> prezziPerseo = DownloadPrezziService.downloadPrezzi(offerta, anno, mese, prezziBaseUrl, logger);
                    DownloadPrezziService.updatePrezzi(prezziPerseo, prezziDb, offerta.getIndice(), bloccoIndice, misureDao, talkManager);
                }
                catch (MisuraException exc) {
                    message = exc.getMessage();
                    sentence = new Message("prezzi", message);
                    indice = exc.getKey();
                    sentence.addParam(indice);
                    Date data = exc.getData();
                    DateFormat dateFormat = StrategyCommonHelper.getStandardDateFormat();
                    sentence.addParam(dateFormat.format(data));
                    talkManager.addSentence(sentence);
                }
                catch (MissingCodicePerseoException exc) {
                    message = ErroreElaborazioneGas.MISSING_ID_PERSEO.getMessage();
                    sentence = new Message("prezzi", message);
                    indice = exc.getReference();
                    sentence.addParam(indice);
                    talkManager.addSentence(sentence);
                }
            }
        }
    }

    private static List<PrezzoGas> getPrezziOfferta(String key, SafeListMap<String, PrezzoGas> prezziMap) {
        ArrayList<PrezzoGas> prezzi;
        try {
            prezzi = (ArrayList<PrezzoGas>)prezziMap.get(key);
        }
        catch (DataNotFoundException exc) {
            prezzi = new ArrayList<PrezzoGas>();
        }
        return prezzi;
    }

    private static Iterable<OffertaGas> getOfferte(MisureGasDao misureDao, String onlyIndice) throws DataNotFoundException {
        Iterable<Object> offerteGas = misureDao.getOfferte();
        if (!StringUtils.isEmpty(onlyIndice) && !onlyIndice.equals("0")) {
            OffertaGasCondition condition = new OffertaGasCondition(onlyIndice);
            Filter<OffertaGas> filter = new Filter<OffertaGas>(condition);
            List<OffertaGas> offerte = filter.filter(offerteGas);
            offerteGas = offerte;
        }
        if (!offerteGas.iterator().hasNext()) {
            throw new DataNotFoundException("missing.offerte", onlyIndice);
        }
        return offerteGas;
    }

    private static Map<Date, PrezzoGas> downloadPrezzi(OffertaGas offerta, int anno, Month mese, String prezziBaseUrl, Logger logger) throws IOException, ParseException, MissingCodicePerseoException, MissingPrezziException {
        ElaborCalendar calendar = new ElaborCalendar(anno, mese);
        Date startDate = calendar.getDate();
        String startDateFmt = StrategyHelper.getPlainDateFormat().format(startDate);
        calendar.addMesi(1);
        calendar.addGiorni(-1);
        Date endDate = calendar.getDate();
        String endDateFmt = StrategyHelper.getPlainDateFormat().format(endDate);
        String idPerseo = offerta.getIdPerseo();
        if (StringUtils.isEmpty(idPerseo)) {
            throw new MissingCodicePerseoException(offerta.getIndice(), "prezzi");
        }
        URL url = new URL(String.valueOf(prezziBaseUrl) + "/" + idPerseo + "?startDate=" + startDateFmt + "&endDate=" + endDateFmt + "&dates=true" + "&simulation=0" + "&scenario=0");
        logger.info(url.toString());
        String indice = offerta.getIndice();
        return DownloadPrezziService.buildPrezzi(url, indice);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static Map<Date, PrezzoGas> buildPrezzi(URL url, String indice) throws IOException, ParseException, MissingPrezziException {
        TreeMap<Date, PrezzoGas> prezzi = new TreeMap<Date, PrezzoGas>();
        Throwable throwable = null;
        Object var4_5 = null;
        try {
            InputStream inputStream = url.openStream();
            try {
                block19: {
                    InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
                    try {
                        try (BufferedReader bufferedReader = new BufferedReader(inputStreamReader);){
                            String line = bufferedReader.readLine();
                            while ((line = bufferedReader.readLine()) != null) {
                                PrezzoGas prezzo = DownloadPrezziService.buildPrezzo(line, indice);
                                prezzi.put(prezzo.getData(), prezzo);
                            }
                        }
                        if (inputStreamReader == null) break block19;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        if (inputStreamReader == null) throw throwable;
                        inputStreamReader.close();
                        throw throwable;
                    }
                    inputStreamReader.close();
                }
                if (inputStream == null) return prezzi;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                if (inputStream == null) throw throwable;
                inputStream.close();
                throw throwable;
            }
            inputStream.close();
            return prezzi;
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
                throw throwable;
            }
            if (throwable == throwable4) throw throwable;
            throwable.addSuppressed(throwable4);
            throw throwable;
        }
    }

    private static PrezzoGas buildPrezzo(String line, String indice) throws ParseException, MissingPrezziException {
        String[] row = line.split(",");
        Date data = StrategyHelper.getLongDateFormat().parse(row[0]);
        Double prezzo = Double.valueOf(row[1]);
        if (prezzo.isNaN()) {
            throw new MissingPrezziException(indice, data);
        }
        return new PrezzoGas(indice, data, prezzo);
    }
}

