/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.gas.web.checkconsumi;

import biz.elabor.prebilling.gas.config.ConfigurationGasInstance;
import biz.elabor.prebilling.gas.config.PrebillingGasConfiguration;
import biz.elabor.prebilling.gas.dao.misure.MisureGasDao;
import biz.elabor.prebilling.gas.web.AbstractGasRequestHandler;
import biz.elabor.prebilling.gas.web.JsonGasRequestHandler;
import biz.elabor.prebilling.gas.web.checkconsumi.CheckConsumiGasStrategiesHandler;
import biz.elabor.prebilling.util.JsonHelper;
import biz.elabor.prebilling.util.Results;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import org.homelinux.elabor.springtools.web.check.InvalidParameterValue;
import org.homelinux.elabor.springtools.web.controllers.ControllerHelper;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;

public class CheckConsumiGasJsonPostHandler
extends AbstractGasRequestHandler
implements JsonGasRequestHandler {
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("MM/yyyy");
    public static final String PDR = "pdr";
    public static final String INIZIO = "inizio";
    public static final String FINE = "fine";
    public static final String TARIFFA = "tariffa";
    public static final String LETTURA = "lettura";
    public static final String PCS = "pcs";
    private final String inizioStr;
    private final String fineStr;
    private final List<String> pdrs;
    private final String target;
    private final boolean tariffa;
    private final boolean lettura;
    private final boolean pcs;

    public CheckConsumiGasJsonPostHandler(String inizio, String fine, List<String> pdrs, String target, boolean tariffa, boolean lettura, boolean pcs, TalkManager talkManager) {
        super("check.consumi", talkManager);
        this.inizioStr = inizio;
        this.fineStr = fine;
        this.pdrs = pdrs;
        this.target = target;
        this.tariffa = tariffa;
        this.lettura = lettura;
        this.pcs = pcs;
    }

    @Override
    public String handleRequest(ConfigurationGasInstance instance) throws InvalidParameterValue {
        Date inizio = ControllerHelper.checkData(INIZIO, this.inizioStr, DATE_FORMAT);
        Date fine = ControllerHelper.checkData(FINE, this.fineStr, DATE_FORMAT);
        ControllerHelper.checkEmpty(PDR, this.pdrs);
        PrebillingGasConfiguration configuration = instance.getConfiguration();
        MisureGasDao misureDao = instance.getMisureDao();
        CheckConsumiGasStrategiesHandler consumiHandler = new CheckConsumiGasStrategiesHandler(inizio, fine, this.pdrs, this.target, this.tariffa, this.lettura, this.pcs, instance, this.talkManager);
        Results results = this.handleRequest(consumiHandler, configuration, misureDao);
        return JsonHelper.buildMessage(configuration, results, this.talkManager);
    }

    @Override
    protected LinkedHashMap<String, Object> getParams() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put(INIZIO, this.inizioStr);
        params.put(FINE, this.fineStr);
        params.put("codici_pdr", this.pdrs.subList(0, Math.min(10, this.pdrs.size())));
        params.put("target", this.target);
        params.put(TARIFFA, this.tariffa);
        params.put(LETTURA, this.lettura);
        params.put(PCS, this.pcs);
        return params;
    }

    @Override
    protected String getReseller() {
        return null;
    }
}

