/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.gas.web.pcs;

import biz.elabor.prebilling.common.dao.TipoStato;
import biz.elabor.prebilling.gas.Funzionalita;
import biz.elabor.prebilling.gas.config.ConfigurationGasInstance;
import biz.elabor.prebilling.gas.services.GasStrategiesManager;
import biz.elabor.prebilling.gas.services.common.CheckGasStatusStrategy;
import biz.elabor.prebilling.gas.services.common.FileCopyStrategy;
import biz.elabor.prebilling.gas.services.common.UpdateStatusStrategy;
import biz.elabor.prebilling.gas.services.pcs.DownloadConsumiPcsStrategy;
import biz.elabor.prebilling.gas.services.pcs.ExportPcsStrategy;
import biz.elabor.prebilling.gas.web.AbstractGasStrategiesHandler;
import org.homelinux.elabor.calendar.Month;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;

public class PcsGasStrategiesHandler
extends AbstractGasStrategiesHandler {
    private final int anno;
    private final Month mese;
    private final String target;

    public PcsGasStrategiesHandler(int anno, Month mese, String target, ConfigurationGasInstance instanceConfiguration, TalkManager talkManager) {
        super(instanceConfiguration, talkManager);
        this.anno = anno;
        this.mese = mese;
        this.target = target;
    }

    @Override
    public GasStrategiesManager buildStrategiesManager() {
        GasStrategiesManager manager = new GasStrategiesManager(this.configuration);
        manager.addStrategy(new CheckGasStatusStrategy(Funzionalita.PCS_GAS, "*", "check", this.configuration, this.misureDao, this.talkManager));
        manager.addStrategy(new UpdateStatusStrategy(Funzionalita.PCS_GAS, "*", TipoStato.IN_ESECUZIONE, this.misureDao, this.configuration));
        manager.addStrategy(new DownloadConsumiPcsStrategy(this.anno, this.mese, this.misureDao, this.giadaDao, this.configuration, this.talkManager));
        manager.addStrategy(new ExportPcsStrategy(this.anno, this.mese, this.target, this.configuration, Funzionalita.PCS_GAS));
        manager.addStrategy(new UpdateStatusStrategy(Funzionalita.PCS_GAS, "*", TipoStato.COPIA_FILE, this.misureDao, this.configuration));
        manager.addStrategy(new FileCopyStrategy(Funzionalita.PCS_GAS, this.configuration, this.talkManager));
        manager.addStrategy(new UpdateStatusStrategy(Funzionalita.PCS_GAS, "*", TipoStato.NO_ESECUZIONE, this.misureDao, this.configuration));
        return manager;
    }
}

