/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.gas.web.prezzi;

import biz.elabor.prebilling.gas.config.ConfigurationGasInstance;
import biz.elabor.prebilling.gas.config.PrebillingGasConfiguration;
import biz.elabor.prebilling.gas.dao.misure.MisureGasDao;
import biz.elabor.prebilling.gas.web.AbstractGasRequestHandler;
import biz.elabor.prebilling.gas.web.JsonGasRequestHandler;
import biz.elabor.prebilling.gas.web.prezzi.PrezziGasStrategiesHandler;
import biz.elabor.prebilling.util.JsonHelper;
import biz.elabor.prebilling.util.Results;
import java.util.LinkedHashMap;
import org.homelinux.elabor.calendar.Month;
import org.homelinux.elabor.springtools.web.check.InvalidParameterValue;
import org.homelinux.elabor.springtools.web.controllers.ControllerHelper;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;

public class PrezziGasJsonPostHandler
extends AbstractGasRequestHandler
implements JsonGasRequestHandler {
    private final String annoInizioTxt;
    private final String meseInizioTxt;
    private final String annoFineTxt;
    private final String meseFineTxt;
    private final String indice;
    private final boolean bloccoIndice;

    public PrezziGasJsonPostHandler(String annoInizioTxt, String meseInizioTxt, String annoFineTxt, String meseFineTxt, String indice, boolean bloccoIndice, TalkManager talkManager) {
        super("prezzi", talkManager);
        this.annoInizioTxt = annoInizioTxt;
        this.meseInizioTxt = meseInizioTxt;
        this.annoFineTxt = annoFineTxt;
        this.meseFineTxt = meseFineTxt;
        this.indice = indice;
        this.bloccoIndice = bloccoIndice;
    }

    @Override
    public String handleRequest(ConfigurationGasInstance instance) throws InvalidParameterValue {
        int annoInizio = ControllerHelper.checkInt("annoInizio", this.annoInizioTxt);
        Month meseInizio = ControllerHelper.checkEnum("meseInizio", this.meseInizioTxt, Month.class);
        int annoFine = ControllerHelper.checkInt("annoFine", this.annoFineTxt);
        Month meseFine = ControllerHelper.checkEnum("meseFine", this.meseFineTxt, Month.class);
        PrebillingGasConfiguration configuration = instance.getConfiguration();
        MisureGasDao misureDao = instance.getMisureDao();
        PrezziGasStrategiesHandler prezziHandler = new PrezziGasStrategiesHandler(annoInizio, meseInizio, annoFine, meseFine, this.indice, this.bloccoIndice, instance, this.talkManager);
        Results results = this.handleRequest(prezziHandler, configuration, misureDao);
        return JsonHelper.buildMessage(configuration, results, this.talkManager);
    }

    @Override
    protected LinkedHashMap<String, Object> getParams() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("annoinizio", this.annoInizioTxt);
        params.put("meseinizio", this.meseInizioTxt);
        params.put("annofine", this.annoFineTxt);
        params.put("mesefine", this.meseFineTxt);
        params.put("indice", this.indice);
        params.put("blocco_indice", this.bloccoIndice);
        return params;
    }

    @Override
    protected String getReseller() {
        return null;
    }
}

