/*
 * Decompiled with CFR 0.152.
 */
package biz.elabor.prebilling.gas.web.tariffe;

import biz.elabor.prebilling.gas.config.ConfigurationGasInstance;
import biz.elabor.prebilling.gas.config.PrebillingGasConfiguration;
import biz.elabor.prebilling.gas.dao.misure.MisureGasDao;
import biz.elabor.prebilling.gas.web.AbstractGasRequestHandler;
import biz.elabor.prebilling.gas.web.JsonGasRequestHandler;
import biz.elabor.prebilling.gas.web.tariffe.TariffeGasStrategiesHandler;
import biz.elabor.prebilling.util.JsonHelper;
import biz.elabor.prebilling.util.Results;
import java.util.LinkedHashMap;
import org.homelinux.elabor.calendar.Month;
import org.homelinux.elabor.springtools.web.check.InvalidParameterValue;
import org.homelinux.elabor.springtools.web.controllers.ControllerHelper;
import org.homelinux.elabor.springtools.web.widgets.TalkManager;
import org.homelinux.elabor.tools.StringUtils;

public class TariffeGasJsonPostHandler
extends AbstractGasRequestHandler
implements JsonGasRequestHandler {
    private final String annoTxt;
    private final String meseTxt;
    private final String reseller;
    private final String onlyPdr;
    private final boolean scivoloEnabled;
    private final boolean forceSopraSoglia;
    private final boolean bloccoIndice;

    public TariffeGasJsonPostHandler(String annoTxt, String meseTxt, String reseller, String onlyPdr, boolean scivoloEnabled, boolean forceSopraSoglia, boolean bloccoIndice, TalkManager talkManager) {
        super("tariffe", talkManager);
        this.annoTxt = annoTxt;
        this.meseTxt = meseTxt;
        this.reseller = StringUtils.isEmpty(reseller) ? "*" : reseller;
        this.onlyPdr = onlyPdr;
        this.scivoloEnabled = scivoloEnabled;
        this.forceSopraSoglia = forceSopraSoglia;
        this.bloccoIndice = bloccoIndice;
    }

    @Override
    public String handleRequest(ConfigurationGasInstance instance) throws InvalidParameterValue {
        int anno = ControllerHelper.checkInt("anno", this.annoTxt);
        Month mese = ControllerHelper.checkEnum("mese", this.meseTxt, Month.class);
        PrebillingGasConfiguration configuration = instance.getConfiguration();
        MisureGasDao misureDao = instance.getMisureDao();
        TariffeGasStrategiesHandler tariffeHandler = new TariffeGasStrategiesHandler(anno, mese, this.reseller, this.onlyPdr, this.scivoloEnabled, this.forceSopraSoglia, this.bloccoIndice, instance, this.talkManager);
        Results results = this.handleRequest(tariffeHandler, configuration, misureDao);
        return JsonHelper.buildMessage(configuration, results, this.talkManager);
    }

    @Override
    protected LinkedHashMap<String, Object> getParams() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("anno", this.annoTxt);
        params.put("mese", this.meseTxt);
        params.put("pdr", this.onlyPdr);
        params.put("scivolo", this.scivoloEnabled);
        params.put("forzatura_consumo", this.forceSopraSoglia);
        params.put("blocco_indice", this.bloccoIndice);
        return params;
    }

    @Override
    protected String getReseller() {
        return this.reseller;
    }
}

