/*
 * Decompiled with CFR 0.152.
 */
package com.graphbuilder.curve;

import com.graphbuilder.curve.ControlStringParseException;
import com.graphbuilder.math.Expression;
import com.graphbuilder.math.ExpressionParseException;
import com.graphbuilder.math.ExpressionTree;
import com.graphbuilder.math.FuncMap;
import com.graphbuilder.math.VarMap;

public class GroupIterator {
    protected String controlString = null;
    protected int[] group = null;
    protected int index_i = 0;
    protected int count_j = 0;

    public GroupIterator(String controlString, int n2) {
        if (controlString == null) {
            throw new IllegalArgumentException("control string cannot be null");
        }
        this.group = GroupIterator.parseControlString(controlString, n2);
        this.controlString = controlString;
    }

    public GroupIterator(int[] group) {
        if (group == null) {
            throw new IllegalArgumentException("group array cannot be null");
        }
        if (group.length == 0) {
            throw new IllegalArgumentException("group array length cannot be 0");
        }
        if (group.length % 2 != 0) {
            throw new IllegalArgumentException("group array must have even length");
        }
        double log10 = Math.log(10.0);
        int numDigits = 0;
        int[] arr = new int[group.length];
        for (int i2 = 0; i2 < arr.length; ++i2) {
            arr[i2] = group[i2];
            int x = arr[i2];
            if (x < 0) {
                ++numDigits;
                x = -x;
            }
            numDigits += (int)(Math.log(x) / log10) + 1;
        }
        this.group = arr;
        StringBuffer sb = new StringBuffer(numDigits + arr.length / 2 + (arr.length - 1));
        sb.append(arr[0]);
        sb.append(":");
        sb.append(arr[1]);
        for (int i3 = 2; i3 < group.length; i3 += 2) {
            sb.append(",");
            sb.append(group[i3]);
            sb.append(":");
            sb.append(group[i3 + 1]);
        }
        this.controlString = sb.toString();
    }

    public static int[] parseControlString(String controlString, int n2) {
        String s2 = controlString;
        int sLength = s2.length();
        int numGroups = 1;
        int b2 = 0;
        for (int i2 = 0; i2 < sLength; ++i2) {
            char c2 = s2.charAt(i2);
            if (c2 == ',' && b2 == 0) {
                ++numGroups;
                continue;
            }
            if (c2 == '(') {
                ++b2;
                continue;
            }
            if (c2 != ')') continue;
            --b2;
        }
        if (b2 != 0) {
            throw new ControlStringParseException("round brackets do not balance");
        }
        int[] group = new int[2 * numGroups];
        int j2 = 0;
        int k2 = 0;
        int colon = -1;
        VarMap vm = new VarMap();
        FuncMap fm = new FuncMap();
        fm.loadDefaultFunctions();
        for (int i3 = 0; i3 <= sLength; ++i3) {
            int c3 = 32;
            if (i3 < sLength) {
                c3 = s2.charAt(i3);
            }
            if (i3 == sLength || c3 == 44 && b2 == 0) {
                if (colon == -1) {
                    Expression x = GroupIterator.setVariables(s2, vm, n2, j2, i3);
                    group[k2] = (int)Math.round(x.eval(vm, fm));
                    group[k2 + 1] = group[k2];
                    k2 += 2;
                } else {
                    Expression x1 = GroupIterator.setVariables(s2, vm, n2, j2, colon);
                    group[k2++] = (int)Math.round(x1.eval(vm, fm));
                    Expression x2 = GroupIterator.setVariables(s2, vm, n2, colon + 1, i3);
                    group[k2++] = (int)Math.round(x2.eval(vm, fm));
                }
                j2 = i3 + 1;
                colon = -1;
                continue;
            }
            if (c3 == 40) {
                ++b2;
                continue;
            }
            if (c3 == 41) {
                --b2;
                continue;
            }
            if (c3 != 58) continue;
            colon = i3;
        }
        return group;
    }

    private static Expression setVariables(String s2, VarMap vm, int n2, int j2, int i2) {
        Expression x = null;
        try {
            x = ExpressionTree.parse(s2.substring(j2, i2));
        }
        catch (ExpressionParseException epe) {
            throw new ControlStringParseException("error parsing expression", j2, i2, epe);
        }
        if (x == null) {
            throw new ControlStringParseException("control substring is empty", j2, i2);
        }
        String[] v = x.getVariableNames();
        if (v.length > 1) {
            throw new ControlStringParseException("too many variables", j2, i2);
        }
        if (v.length == 1) {
            vm.setValue(v[0], n2);
        }
        return x;
    }

    public String getControlString() {
        return this.controlString;
    }

    public int getGroupLength() {
        return this.group.length;
    }

    public int getGroupValue(int index) {
        if (index < 0 || index >= this.group.length) {
            throw new IllegalArgumentException("required: (index >= 0 && index < group.length) but: (index = " + index + ", group.length = " + this.group.length + ")");
        }
        return this.group[index];
    }

    public int getGroupSize() {
        int size = 0;
        for (int i2 = 0; i2 < this.group.length; i2 += 2) {
            int dif = this.group[i2] - this.group[i2 + 1];
            if (dif < 0) {
                dif = -dif;
            }
            size += dif + 1;
        }
        return size;
    }

    public void copyGroupArray(int[] arr) {
        if (arr == null) {
            throw new IllegalArgumentException("specified array cannot be null");
        }
        if (arr.length < this.group.length) {
            throw new IllegalArgumentException("specified array is too small");
        }
        for (int i2 = 0; i2 < this.group.length; ++i2) {
            arr[i2] = this.group[i2];
        }
    }

    public boolean hasNext() {
        return this.index_i < this.group.length;
    }

    public int next() {
        int x = this.group[this.index_i];
        int y = this.group[this.index_i + 1];
        if (x <= y) {
            if ((x += this.count_j) >= y) {
                this.count_j = 0;
                this.index_i += 2;
            } else {
                ++this.count_j;
            }
        } else if ((x -= this.count_j) <= y) {
            this.count_j = 0;
            this.index_i += 2;
        } else {
            ++this.count_j;
        }
        return x;
    }

    public void set(int index_i, int count_j) {
        if (index_i < 0) {
            throw new IllegalArgumentException("index_i >= 0 required");
        }
        if (index_i % 2 == 1) {
            throw new IllegalArgumentException("index_i must be an even number");
        }
        if (count_j < 0) {
            throw new IllegalArgumentException("count_j >= 0 required");
        }
        this.index_i = index_i;
        this.count_j = count_j;
    }

    public int index_i() {
        return this.index_i;
    }

    public int count_j() {
        return this.count_j;
    }

    public void reset() {
        this.index_i = 0;
        this.count_j = 0;
    }

    public boolean isInRange(int min, int max) {
        for (int i2 = 0; i2 < this.group.length; ++i2) {
            if (this.group[i2] >= min && this.group[i2] < max) continue;
            return false;
        }
        return true;
    }
}

