/*
 * Decompiled with CFR 0.152.
 */
package com.graphbuilder.struc;

public class LinkedList {
    protected Node head = null;
    protected Node tail = null;
    protected int size = 0;

    protected Node createNode(Object o2) {
        return new Node(this, o2);
    }

    protected void insertBefore(Node n2, Object o2) {
        Node p2 = this.createNode(o2);
        if (this.size == 0) {
            this.head = p2;
            this.tail = p2;
        } else if (n2 == this.head) {
            p2.next = this.head;
            this.head.prev = p2;
            this.head = p2;
        } else {
            n2.prev.next = p2;
            p2.prev = n2.prev;
            n2.prev = p2;
            p2.next = n2;
        }
        ++this.size;
    }

    protected void insertAfter(Node n2, Object o2) {
        Node p2 = this.createNode(o2);
        if (this.size == 0) {
            this.head = p2;
            this.tail = p2;
        } else if (n2 == this.tail) {
            p2.prev = this.tail;
            this.tail.next = p2;
            this.tail = p2;
        } else {
            n2.next.prev = p2;
            p2.next = n2.next;
            n2.next = p2;
            p2.prev = n2;
        }
        ++this.size;
    }

    protected Object removeNode(Node n2) {
        if (this.size == 0) {
            return null;
        }
        Object o2 = n2.userObject;
        if (n2 == this.head) {
            this.head = this.head.next;
            if (this.head == null) {
                this.tail = null;
            } else {
                this.head.prev = null;
            }
        } else if (n2 == this.tail) {
            this.tail = this.tail.prev;
            this.tail.next = null;
        } else {
            n2.prev.next = n2.next;
            n2.next.prev = n2.prev;
        }
        n2.list = null;
        --this.size;
        return o2;
    }

    public Node getHead() {
        return this.head;
    }

    public Node getTail() {
        return this.tail;
    }

    public void addToHead(Object o2) {
        this.insertBefore(this.head, o2);
    }

    public void addToTail(Object o2) {
        this.insertAfter(this.tail, o2);
    }

    public Object removeHead() {
        return this.removeNode(this.head);
    }

    public Object removeTail() {
        return this.removeNode(this.tail);
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(6 * this.size);
        sb.append("[");
        Node n2 = this.head;
        if (n2 != null) {
            sb.append(n2.userObject);
            n2 = n2.next;
        }
        while (n2 != null) {
            sb.append(", ");
            sb.append(n2.userObject);
            n2 = n2.next;
        }
        return sb.append("]").toString();
    }

    public static class Node {
        protected LinkedList list = null;
        protected Node next = null;
        protected Node prev = null;
        protected Object userObject = null;

        protected Node(LinkedList list, Object userObject) {
            this.list = list;
            this.userObject = userObject;
        }

        public LinkedList list() {
            return this.list;
        }

        public Node next() {
            return this.next;
        }

        public Node prev() {
            return this.prev;
        }

        public Object getUserObject() {
            return this.userObject;
        }

        public void setUserObject(Object userObject) {
            this.userObject = userObject;
        }

        public void insertBefore(Object o2) {
            this.list.insertBefore(this, o2);
        }

        public void insertAfter(Object o2) {
            this.list.insertAfter(this, o2);
        }

        public void remove() {
            this.list.removeNode(this);
        }
    }
}

