/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.jackcess;

import java.nio.ByteBuffer;

public final class ByteUtil {
    private static final String[] HEX_CHARS = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "A", "B", "C", "D", "E", "F"};

    private ByteUtil() {
    }

    public static byte[] to3ByteInt(int i2) {
        byte[] rtn = new byte[]{(byte)(i2 & 0xFF), (byte)(i2 >>> 8 & 0xFF), (byte)(i2 >>> 16 & 0xFF)};
        return rtn;
    }

    public static int get3ByteInt(ByteBuffer buffer, int offset) {
        int rtn = buffer.get(offset) & 0xFF;
        rtn += (buffer.get(offset + 1) & 0xFF) << 8;
        rtn += (buffer.get(offset + 2) & 0xFF) << 16;
        return rtn &= 0xFFFFFF;
    }

    public static String toHexString(ByteBuffer buffer, int size) {
        return ByteUtil.toHexString(buffer, 0, size);
    }

    public static String toHexString(ByteBuffer buffer, int offset, int size) {
        StringBuffer rtn = new StringBuffer();
        int position = buffer.position();
        buffer.position(offset);
        for (int i2 = 0; i2 < size; ++i2) {
            byte b2 = buffer.get();
            byte h2 = (byte)(b2 & 0xF0);
            h2 = (byte)(h2 >>> 4);
            h2 = (byte)(h2 & 0xF);
            rtn.append(HEX_CHARS[h2]);
            h2 = (byte)(b2 & 0xF);
            rtn.append(HEX_CHARS[h2] + " ");
            if ((i2 + 1) % 4 == 0) {
                rtn.append(" ");
            }
            if ((i2 + 1) % 24 != 0) continue;
            rtn.append("\n");
        }
        buffer.position(position);
        return rtn.toString();
    }
}

