/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.jackcess;

import com.healthmarketscience.jackcess.JetFormat;
import com.healthmarketscience.jackcess.PageChannel;
import com.healthmarketscience.jackcess.UsageMap;
import java.io.IOException;
import java.nio.ByteBuffer;

public class ReferenceUsageMap
extends UsageMap {
    private ByteBuffer _mapPageBuffer;
    private int _mapPageNum;

    public ReferenceUsageMap(PageChannel pageChannel, ByteBuffer dataBuffer, int pageNum, JetFormat format, short rowStart) throws IOException {
        super(pageChannel, dataBuffer, pageNum, format, rowStart);
        this._mapPageBuffer = pageChannel.createPageBuffer();
        for (int i2 = 0; i2 < 17; ++i2) {
            this._mapPageNum = dataBuffer.getInt(this.getRowStart() + format.OFFSET_REFERENCE_MAP_PAGE_NUMBERS + 4 * i2);
            if (this._mapPageNum <= 0) continue;
            pageChannel.readPage(this._mapPageBuffer, this._mapPageNum);
            byte pageType = this._mapPageBuffer.get();
            if (pageType != 5) {
                throw new IOException("Looking for usage map at page " + this._mapPageNum + ", but page type is " + pageType);
            }
            this._mapPageBuffer.position(format.OFFSET_USAGE_MAP_PAGE_DATA);
            this.setStartOffset(this._mapPageBuffer.position());
            this.processMap(this._mapPageBuffer, i2, 0);
        }
    }

    protected void addOrRemovePageNumber(int pageNumber, boolean add) throws IOException {
        int pageIndex = (int)Math.floor(pageNumber / this.getFormat().PAGES_PER_USAGE_MAP_PAGE);
        int mapPageNumber = this.getDataBuffer().getInt(this.calculateMapPagePointerOffset(pageIndex));
        if (mapPageNumber > 0) {
            if (this._mapPageNum != mapPageNumber) {
                this.getPageChannel().readPage(this._mapPageBuffer, mapPageNumber);
                this._mapPageNum = mapPageNumber;
            }
        } else {
            this.createNewUsageMapPage(pageIndex);
        }
        this.updateMap(pageNumber, pageNumber - this.getFormat().PAGES_PER_USAGE_MAP_PAGE * pageIndex, 1 << (pageNumber - this.getFormat().PAGES_PER_USAGE_MAP_PAGE * pageIndex) % 8, this._mapPageBuffer, add);
        this.getPageChannel().writePage(this._mapPageBuffer, this._mapPageNum);
    }

    private void createNewUsageMapPage(int pageIndex) throws IOException {
        this._mapPageBuffer = this.getPageChannel().createPageBuffer();
        this._mapPageBuffer.put((byte)5);
        this._mapPageBuffer.put((byte)1);
        this._mapPageBuffer.putShort((short)0);
        this._mapPageNum = this.getPageChannel().writeNewPage(this._mapPageBuffer);
        this.getDataBuffer().putInt(this.calculateMapPagePointerOffset(pageIndex), this._mapPageNum);
        this.getPageChannel().writePage(this.getDataBuffer(), this.getDataPageNumber());
    }

    private int calculateMapPagePointerOffset(int pageIndex) {
        return this.getRowStart() + this.getFormat().OFFSET_REFERENCE_MAP_PAGE_NUMBERS + pageIndex * 4;
    }
}

