/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.jackcess;

import com.healthmarketscience.jackcess.ByteUtil;
import com.healthmarketscience.jackcess.InlineUsageMap;
import com.healthmarketscience.jackcess.JetFormat;
import com.healthmarketscience.jackcess.PageChannel;
import com.healthmarketscience.jackcess.ReferenceUsageMap;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class UsageMap {
    private static final Log LOG = LogFactory.getLog(UsageMap.class);
    public static final byte MAP_TYPE_INLINE = 0;
    public static final byte MAP_TYPE_REFERENCE = 1;
    private int _currentPageIndex = 0;
    private int _dataPageNum;
    private int _startOffset;
    private short _rowStart;
    private JetFormat _format;
    private List _pageNumbers = new ArrayList();
    private ByteBuffer _dataBuffer;
    private PageChannel _pageChannel;

    public static UsageMap read(PageChannel pageChannel, int pageNum, byte rowNum, JetFormat format) throws IOException {
        UsageMap rtn;
        ByteBuffer dataBuffer = pageChannel.createPageBuffer();
        pageChannel.readPage(dataBuffer, pageNum);
        short rowStart = dataBuffer.getShort(format.OFFSET_ROW_START + 2 * rowNum);
        int rowEnd = rowNum == 0 ? format.PAGE_SIZE - 1 : (dataBuffer.getShort(format.OFFSET_ROW_START + (rowNum - 1) * 2) & 0xFFF) - 1;
        dataBuffer.limit(rowEnd + 1);
        byte mapType = dataBuffer.get(rowStart);
        if (mapType == 0) {
            rtn = new InlineUsageMap(pageChannel, dataBuffer, pageNum, format, rowStart);
        } else if (mapType == 1) {
            rtn = new ReferenceUsageMap(pageChannel, dataBuffer, pageNum, format, rowStart);
        } else {
            throw new IOException("Unrecognized map type: " + mapType);
        }
        return rtn;
    }

    public UsageMap(PageChannel pageChannel, ByteBuffer dataBuffer, int pageNum, JetFormat format, short rowStart) throws IOException {
        this._pageChannel = pageChannel;
        this._dataBuffer = dataBuffer;
        this._dataPageNum = pageNum;
        this._format = format;
        this._rowStart = rowStart;
        this._dataBuffer.position(this._rowStart + format.OFFSET_MAP_START);
        this._startOffset = this._dataBuffer.position();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Usage map block:\n" + ByteUtil.toHexString(this._dataBuffer, this._rowStart, dataBuffer.limit() - this._rowStart));
        }
    }

    protected short getRowStart() {
        return this._rowStart;
    }

    public List getPageNumbers() {
        return this._pageNumbers;
    }

    protected void setStartOffset(int startOffset) {
        this._startOffset = startOffset;
    }

    protected int getStartOffset() {
        return this._startOffset;
    }

    protected ByteBuffer getDataBuffer() {
        return this._dataBuffer;
    }

    protected int getDataPageNumber() {
        return this._dataPageNum;
    }

    protected PageChannel getPageChannel() {
        return this._pageChannel;
    }

    protected JetFormat getFormat() {
        return this._format;
    }

    public void reset() {
        this._currentPageIndex = 0;
    }

    public boolean getNextPage(ByteBuffer buffer) throws IOException {
        if (this._pageNumbers.size() > this._currentPageIndex) {
            Integer pageNumber = (Integer)this._pageNumbers.get(this._currentPageIndex++);
            this._pageChannel.readPage(buffer, pageNumber);
            return true;
        }
        return false;
    }

    protected void processMap(ByteBuffer buffer, int pageIndex, int startPage) {
        int byteCount = 0;
        while (buffer.hasRemaining()) {
            byte b2 = buffer.get();
            for (int i2 = 0; i2 < 8; ++i2) {
                if ((b2 & 1 << i2) == 0) continue;
                Integer pageNumber = new Integer(startPage + byteCount * 8 + i2 + pageIndex * this._format.PAGES_PER_USAGE_MAP_PAGE);
                this._pageNumbers.add(pageNumber);
            }
            ++byteCount;
        }
    }

    public void addPageNumber(int pageNumber) throws IOException {
        if (LOG.isDebugEnabled() && this._pageNumbers.contains(new Integer(pageNumber))) {
            throw new IOException("Page number " + pageNumber + " already in usage map");
        }
        this.addOrRemovePageNumber(pageNumber, true);
    }

    public void removePageNumber(int pageNumber) throws IOException {
        this.addOrRemovePageNumber(pageNumber, false);
    }

    protected void updateMap(int absolutePageNumber, int relativePageNumber, int bitmask, ByteBuffer buffer, boolean add) {
        int offset = relativePageNumber / 8;
        byte b2 = buffer.get(this._startOffset + offset);
        if (add) {
            b2 = (byte)(b2 | bitmask);
            this._pageNumbers.add(new Integer(absolutePageNumber));
        } else {
            b2 = (byte)(b2 & ~bitmask);
        }
        buffer.put(this._startOffset + offset, b2);
    }

    public String toString() {
        return "page numbers: " + this._pageNumbers;
    }

    protected abstract void addOrRemovePageNumber(int var1, boolean var2) throws IOException;
}

