/*
 * Decompiled with CFR 0.152.
 */
package com.toedter.calendar;

import com.toedter.calendar.IDateEvaluator;
import com.toedter.calendar.MinMaxDateEvaluator;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.text.DateFormatSymbols;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class JDayChooser
extends JPanel
implements ActionListener,
KeyListener,
FocusListener {
    private static final long serialVersionUID = 5876398337018781820L;
    protected JButton[] days;
    protected JButton[] weeks;
    protected JButton selectedDay;
    protected JPanel weekPanel;
    protected JPanel dayPanel;
    protected int day;
    protected Color oldDayBackgroundColor;
    protected Color selectedColor;
    protected Color sundayForeground;
    protected Color weekdayForeground;
    protected Color decorationBackgroundColor;
    protected String[] dayNames;
    protected Calendar calendar;
    protected Calendar today;
    protected Locale locale;
    protected boolean initialized;
    protected boolean weekOfYearVisible;
    protected boolean decorationBackgroundVisible = true;
    protected boolean decorationBordersVisible;
    protected boolean dayBordersVisible;
    private boolean alwaysFireDayProperty;
    protected int maxDayCharacters;
    protected List dateEvaluators;
    protected MinMaxDateEvaluator minMaxDateEvaluator;

    public JDayChooser() {
        this(false);
    }

    public JDayChooser(boolean bl) {
        int n2;
        this.setName("JDayChooser");
        this.setBackground(Color.blue);
        this.dateEvaluators = new ArrayList(1);
        this.minMaxDateEvaluator = new MinMaxDateEvaluator();
        this.addDateEvaluator(this.minMaxDateEvaluator);
        this.weekOfYearVisible = bl;
        this.locale = Locale.getDefault();
        this.days = new JButton[49];
        this.selectedDay = null;
        this.calendar = Calendar.getInstance(this.locale);
        this.today = (Calendar)this.calendar.clone();
        this.setLayout(new BorderLayout());
        this.dayPanel = new JPanel();
        this.dayPanel.setLayout(new GridLayout(7, 7));
        this.sundayForeground = new Color(164, 0, 0);
        this.weekdayForeground = new Color(0, 90, 164);
        this.decorationBackgroundColor = new Color(210, 228, 238);
        for (n2 = 0; n2 < 7; ++n2) {
            for (int i2 = 0; i2 < 7; ++i2) {
                int n3 = i2 + 7 * n2;
                if (n2 == 0) {
                    this.days[n3] = new DecoratorButton();
                } else {
                    this.days[n3] = new JButton("x"){
                        private static final long serialVersionUID = -7433645992591669725L;

                        public void paint(Graphics graphics) {
                            if ("Windows".equals(UIManager.getLookAndFeel().getID()) && JDayChooser.this.selectedDay == this) {
                                graphics.setColor(JDayChooser.this.selectedColor);
                                graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
                            }
                            super.paint(graphics);
                        }
                    };
                    this.days[n3].addActionListener(this);
                    this.days[n3].addKeyListener(this);
                    this.days[n3].addFocusListener(this);
                }
                this.days[n3].setMargin(new Insets(0, 0, 0, 0));
                this.days[n3].setFocusPainted(false);
                this.dayPanel.add(this.days[n3]);
            }
        }
        this.weekPanel = new JPanel();
        this.weekPanel.setLayout(new GridLayout(7, 1));
        this.weeks = new JButton[7];
        for (n2 = 0; n2 < 7; ++n2) {
            this.weeks[n2] = new DecoratorButton();
            this.weeks[n2].setMargin(new Insets(0, 0, 0, 0));
            this.weeks[n2].setFocusPainted(false);
            this.weeks[n2].setForeground(new Color(100, 100, 100));
            if (n2 != 0) {
                this.weeks[n2].setText("0" + (n2 + 1));
            }
            this.weekPanel.add(this.weeks[n2]);
        }
        this.init();
        this.setDay(Calendar.getInstance().get(5));
        this.add((Component)this.dayPanel, "Center");
        if (bl) {
            this.add((Component)this.weekPanel, "West");
        }
        this.initialized = true;
        this.updateUI();
    }

    protected void init() {
        JButton jButton = new JButton();
        this.oldDayBackgroundColor = jButton.getBackground();
        this.selectedColor = new Color(160, 160, 160);
        Date date = this.calendar.getTime();
        this.calendar = Calendar.getInstance(this.locale);
        this.calendar.setTime(date);
        this.drawDayNames();
        this.drawDays();
    }

    private void drawDayNames() {
        int n2 = this.calendar.getFirstDayOfWeek();
        DateFormatSymbols dateFormatSymbols = new DateFormatSymbols(this.locale);
        this.dayNames = dateFormatSymbols.getShortWeekdays();
        int n3 = n2;
        for (int i2 = 0; i2 < 7; ++i2) {
            if (this.maxDayCharacters > 0 && this.maxDayCharacters < 5 && this.dayNames[n3].length() >= this.maxDayCharacters) {
                this.dayNames[n3] = this.dayNames[n3].substring(0, this.maxDayCharacters);
            }
            this.days[i2].setText(this.dayNames[n3]);
            if (n3 == 1) {
                this.days[i2].setForeground(this.sundayForeground);
            } else {
                this.days[i2].setForeground(this.weekdayForeground);
            }
            if (n3 < 7) {
                ++n3;
                continue;
            }
            n3 -= 6;
        }
    }

    protected void initDecorations() {
        for (int i2 = 0; i2 < 7; ++i2) {
            this.days[i2].setContentAreaFilled(this.decorationBackgroundVisible);
            this.days[i2].setBorderPainted(this.decorationBordersVisible);
            this.days[i2].invalidate();
            this.days[i2].repaint();
            this.weeks[i2].setContentAreaFilled(this.decorationBackgroundVisible);
            this.weeks[i2].setBorderPainted(this.decorationBordersVisible);
            this.weeks[i2].invalidate();
            this.weeks[i2].repaint();
        }
    }

    protected void drawWeeks() {
        Calendar calendar = (Calendar)this.calendar.clone();
        for (int i2 = 1; i2 < 7; ++i2) {
            calendar.set(5, i2 * 7 - 6);
            int n2 = calendar.get(3);
            String string = Integer.toString(n2);
            if (n2 < 10) {
                string = "0" + string;
            }
            this.weeks[i2].setText(string);
            if (i2 != 5 && i2 != 6) continue;
            this.weeks[i2].setVisible(this.days[i2 * 7].isVisible());
        }
    }

    protected void drawDays() {
        int n2;
        Calendar calendar = (Calendar)this.calendar.clone();
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        int n3 = calendar.getFirstDayOfWeek();
        calendar.set(5, 1);
        int n4 = calendar.get(7) - n3;
        if (n4 < 0) {
            n4 += 7;
        }
        for (n2 = 0; n2 < n4; ++n2) {
            this.days[n2 + 7].setVisible(false);
            this.days[n2 + 7].setText("");
        }
        calendar.add(2, 1);
        Date date = calendar.getTime();
        calendar.add(2, -1);
        Date date2 = calendar.getTime();
        int n5 = 0;
        Color color = this.getForeground();
        while (date2.before(date)) {
            this.days[n2 + n5 + 7].setText(Integer.toString(n5 + 1));
            this.days[n2 + n5 + 7].setVisible(true);
            if (calendar.get(6) == this.today.get(6) && calendar.get(1) == this.today.get(1)) {
                this.days[n2 + n5 + 7].setForeground(this.sundayForeground);
            } else {
                this.days[n2 + n5 + 7].setForeground(color);
            }
            if (n5 + 1 == this.day) {
                this.days[n2 + n5 + 7].setBackground(this.selectedColor);
                this.selectedDay = this.days[n2 + n5 + 7];
            } else {
                this.days[n2 + n5 + 7].setBackground(this.oldDayBackgroundColor);
            }
            Iterator iterator = this.dateEvaluators.iterator();
            this.days[n2 + n5 + 7].setEnabled(true);
            while (iterator.hasNext()) {
                IDateEvaluator iDateEvaluator = (IDateEvaluator)iterator.next();
                if (iDateEvaluator.isSpecial(date2)) {
                    this.days[n2 + n5 + 7].setForeground(iDateEvaluator.getSpecialForegroundColor());
                    this.days[n2 + n5 + 7].setBackground(iDateEvaluator.getSpecialBackroundColor());
                    this.days[n2 + n5 + 7].setToolTipText(iDateEvaluator.getSpecialTooltip());
                    this.days[n2 + n5 + 7].setEnabled(true);
                }
                if (!iDateEvaluator.isInvalid(date2)) continue;
                this.days[n2 + n5 + 7].setForeground(iDateEvaluator.getInvalidForegroundColor());
                this.days[n2 + n5 + 7].setBackground(iDateEvaluator.getInvalidBackroundColor());
                this.days[n2 + n5 + 7].setToolTipText(iDateEvaluator.getInvalidTooltip());
                this.days[n2 + n5 + 7].setEnabled(false);
            }
            ++n5;
            calendar.add(5, 1);
            date2 = calendar.getTime();
        }
        for (int i2 = n5 + n2 + 7; i2 < 49; ++i2) {
            this.days[i2].setVisible(false);
            this.days[i2].setText("");
        }
        this.drawWeeks();
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        if (!this.initialized) {
            super.setLocale(locale);
        } else {
            this.locale = locale;
            super.setLocale(locale);
            this.init();
        }
    }

    public void setDay(int n2) {
        if (n2 < 1) {
            n2 = 1;
        }
        Calendar calendar = (Calendar)this.calendar.clone();
        calendar.set(5, 1);
        calendar.add(2, 1);
        calendar.add(5, -1);
        int n3 = calendar.get(5);
        if (n2 > n3) {
            n2 = n3;
        }
        int n4 = this.day;
        this.day = n2;
        if (this.selectedDay != null) {
            this.selectedDay.setBackground(this.oldDayBackgroundColor);
            this.selectedDay.repaint();
        }
        for (int i2 = 7; i2 < 49; ++i2) {
            if (!this.days[i2].getText().equals(Integer.toString(this.day))) continue;
            this.selectedDay = this.days[i2];
            this.selectedDay.setBackground(this.selectedColor);
            break;
        }
        if (this.alwaysFireDayProperty) {
            this.firePropertyChange("day", 0, this.day);
        } else {
            this.firePropertyChange("day", n4, this.day);
        }
    }

    public void setAlwaysFireDayProperty(boolean bl) {
        this.alwaysFireDayProperty = bl;
    }

    public int getDay() {
        return this.day;
    }

    public void setMonth(int n2) {
        this.calendar.set(2, n2);
        int n3 = this.calendar.getActualMaximum(5);
        if (this.day > n3) {
            this.day = n3;
        }
        this.drawDays();
    }

    public void setYear(int n2) {
        this.calendar.set(1, n2);
        this.drawDays();
    }

    public void setCalendar(Calendar calendar) {
        this.calendar = calendar;
        this.drawDays();
    }

    public void setFont(Font font) {
        int n2;
        if (this.days != null) {
            for (n2 = 0; n2 < 49; ++n2) {
                this.days[n2].setFont(font);
            }
        }
        if (this.weeks != null) {
            for (n2 = 0; n2 < 7; ++n2) {
                this.weeks[n2].setFont(font);
            }
        }
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        if (this.days != null) {
            for (int i2 = 7; i2 < 49; ++i2) {
                this.days[i2].setForeground(color);
            }
            this.drawDays();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        JButton jButton = (JButton)actionEvent.getSource();
        String string = jButton.getText();
        int n2 = new Integer(string);
        this.setDay(n2);
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void focusLost(FocusEvent focusEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        int n2 = keyEvent.getKeyCode() == 38 ? -7 : (keyEvent.getKeyCode() == 40 ? 7 : (keyEvent.getKeyCode() == 37 ? -1 : (keyEvent.getKeyCode() == 39 ? 1 : 0)));
        int n3 = this.getDay() + n2;
        if (n3 >= 1 && n3 <= this.calendar.getMaximum(5)) {
            this.setDay(n3);
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void setEnabled(boolean bl) {
        int n2;
        super.setEnabled(bl);
        for (n2 = 0; n2 < this.days.length; n2 = (int)((short)(n2 + 1))) {
            if (this.days[n2] == null) continue;
            this.days[n2].setEnabled(bl);
        }
        for (n2 = 0; n2 < this.weeks.length; n2 = (int)((short)(n2 + 1))) {
            if (this.weeks[n2] == null) continue;
            this.weeks[n2].setEnabled(bl);
        }
    }

    public boolean isWeekOfYearVisible() {
        return this.weekOfYearVisible;
    }

    public void setWeekOfYearVisible(boolean bl) {
        if (bl == this.weekOfYearVisible) {
            return;
        }
        if (bl) {
            this.add((Component)this.weekPanel, "West");
        } else {
            this.remove(this.weekPanel);
        }
        this.weekOfYearVisible = bl;
        this.validate();
        this.dayPanel.validate();
    }

    public JPanel getDayPanel() {
        return this.dayPanel;
    }

    public Color getDecorationBackgroundColor() {
        return this.decorationBackgroundColor;
    }

    public void setDecorationBackgroundColor(Color color) {
        int n2;
        this.decorationBackgroundColor = color;
        if (this.days != null) {
            for (n2 = 0; n2 < 7; ++n2) {
                this.days[n2].setBackground(color);
            }
        }
        if (this.weeks != null) {
            for (n2 = 0; n2 < 7; ++n2) {
                this.weeks[n2].setBackground(color);
            }
        }
    }

    public Color getSundayForeground() {
        return this.sundayForeground;
    }

    public Color getWeekdayForeground() {
        return this.weekdayForeground;
    }

    public void setSundayForeground(Color color) {
        this.sundayForeground = color;
        this.drawDayNames();
        this.drawDays();
    }

    public void setWeekdayForeground(Color color) {
        this.weekdayForeground = color;
        this.drawDayNames();
        this.drawDays();
    }

    public void setFocus() {
        if (this.selectedDay != null) {
            this.selectedDay.requestFocus();
        }
    }

    public boolean isDecorationBackgroundVisible() {
        return this.decorationBackgroundVisible;
    }

    public void setDecorationBackgroundVisible(boolean bl) {
        this.decorationBackgroundVisible = bl;
        this.initDecorations();
    }

    public boolean isDecorationBordersVisible() {
        return this.decorationBordersVisible;
    }

    public boolean isDayBordersVisible() {
        return this.dayBordersVisible;
    }

    public void setDecorationBordersVisible(boolean bl) {
        this.decorationBordersVisible = bl;
        this.initDecorations();
    }

    public void setDayBordersVisible(boolean bl) {
        this.dayBordersVisible = bl;
        if (this.initialized) {
            for (int i2 = 7; i2 < 49; ++i2) {
                if ("Windows".equals(UIManager.getLookAndFeel().getID())) {
                    this.days[i2].setContentAreaFilled(bl);
                } else {
                    this.days[i2].setContentAreaFilled(true);
                }
                this.days[i2].setBorderPainted(bl);
            }
        }
    }

    public void updateUI() {
        super.updateUI();
        this.setFont(Font.decode("Dialog Plain 11"));
        if (this.weekPanel != null) {
            this.weekPanel.updateUI();
        }
        if (this.initialized) {
            if ("Windows".equals(UIManager.getLookAndFeel().getID())) {
                this.setDayBordersVisible(false);
                this.setDecorationBackgroundVisible(true);
                this.setDecorationBordersVisible(false);
            } else {
                this.setDayBordersVisible(true);
                this.setDecorationBackgroundVisible(this.decorationBackgroundVisible);
                this.setDecorationBordersVisible(this.decorationBordersVisible);
            }
        }
    }

    public void setSelectableDateRange(Date date, Date date2) {
        this.minMaxDateEvaluator.setMaxSelectableDate(date2);
        this.minMaxDateEvaluator.setMinSelectableDate(date);
        this.drawDays();
    }

    public Date setMaxSelectableDate(Date date) {
        Date date2 = this.minMaxDateEvaluator.setMaxSelectableDate(date);
        this.drawDays();
        return date2;
    }

    public Date setMinSelectableDate(Date date) {
        Date date2 = this.minMaxDateEvaluator.setMinSelectableDate(date);
        this.drawDays();
        return date2;
    }

    public Date getMaxSelectableDate() {
        return this.minMaxDateEvaluator.getMaxSelectableDate();
    }

    public Date getMinSelectableDate() {
        return this.minMaxDateEvaluator.getMinSelectableDate();
    }

    public int getMaxDayCharacters() {
        return this.maxDayCharacters;
    }

    public void setMaxDayCharacters(int n2) {
        if (n2 == this.maxDayCharacters) {
            return;
        }
        this.maxDayCharacters = n2 < 0 || n2 > 4 ? 0 : n2;
        this.drawDayNames();
        this.drawDays();
        this.invalidate();
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame("JDayChooser");
        jFrame.getContentPane().add(new JDayChooser());
        jFrame.pack();
        jFrame.setVisible(true);
    }

    public void addDateEvaluator(IDateEvaluator iDateEvaluator) {
        this.dateEvaluators.add(iDateEvaluator);
    }

    public void removeDateEvaluator(IDateEvaluator iDateEvaluator) {
        this.dateEvaluators.remove(iDateEvaluator);
    }

    class DecoratorButton
    extends JButton {
        private static final long serialVersionUID = -5306477668406547496L;

        public DecoratorButton() {
            this.setBackground(JDayChooser.this.decorationBackgroundColor);
            this.setContentAreaFilled(JDayChooser.this.decorationBackgroundVisible);
            this.setBorderPainted(JDayChooser.this.decorationBordersVisible);
        }

        public void addMouseListener(MouseListener mouseListener) {
        }

        public boolean isFocusable() {
            return false;
        }

        public void paint(Graphics graphics) {
            if ("Windows".equals(UIManager.getLookAndFeel().getID())) {
                if (JDayChooser.this.decorationBackgroundVisible) {
                    graphics.setColor(JDayChooser.this.decorationBackgroundColor);
                } else {
                    graphics.setColor(JDayChooser.this.days[7].getBackground());
                }
                graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
                if (this.isBorderPainted()) {
                    this.setContentAreaFilled(true);
                } else {
                    this.setContentAreaFilled(false);
                }
            }
            super.paint(graphics);
        }
    }
}

