/*
 * Decompiled with CFR 0.152.
 */
package jxl.biff.drawing;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import jxl.biff.drawing.Drawing;
import jxl.biff.drawing.DrawingData;
import jxl.biff.drawing.DrawingGroup;
import jxl.biff.drawing.DrawingGroupObject;
import jxl.biff.drawing.EscherContainer;
import jxl.biff.drawing.MsoDrawingRecord;
import jxl.biff.drawing.Origin;
import jxl.biff.drawing.ShapeType;
import jxl.common.Assert;
import jxl.common.Logger;

public class Drawing2
implements DrawingGroupObject {
    private static Logger logger = Logger.getLogger(Drawing.class);
    private EscherContainer readSpContainer;
    private MsoDrawingRecord msoDrawingRecord;
    private boolean initialized = false;
    private File imageFile;
    private byte[] imageData;
    private int objectId;
    private int blipId;
    private double x;
    private double y;
    private double width;
    private double height;
    private int referenceCount;
    private EscherContainer escherData;
    private Origin origin;
    private DrawingGroup drawingGroup;
    private DrawingData drawingData;
    private ShapeType type;
    private int shapeId;
    private int drawingNumber;

    public Drawing2(MsoDrawingRecord mso, DrawingData dd, DrawingGroup dg) {
        this.drawingGroup = dg;
        this.msoDrawingRecord = mso;
        this.drawingData = dd;
        this.initialized = false;
        this.origin = Origin.READ;
        this.drawingData.addRawData(this.msoDrawingRecord.getData());
        this.drawingGroup.addDrawing(this);
        Assert.verify(mso != null);
        this.initialize();
    }

    protected Drawing2(DrawingGroupObject dgo, DrawingGroup dg) {
        Drawing2 d2 = (Drawing2)dgo;
        Assert.verify(d2.origin == Origin.READ);
        this.msoDrawingRecord = d2.msoDrawingRecord;
        this.initialized = false;
        this.origin = Origin.READ;
        this.drawingData = d2.drawingData;
        this.drawingGroup = dg;
        this.drawingNumber = d2.drawingNumber;
        this.drawingGroup.addDrawing(this);
    }

    public Drawing2(double x, double y, double w, double h2, File image) {
        this.imageFile = image;
        this.initialized = true;
        this.origin = Origin.WRITE;
        this.x = x;
        this.y = y;
        this.width = w;
        this.height = h2;
        this.referenceCount = 1;
        this.type = ShapeType.PICTURE_FRAME;
    }

    public Drawing2(double x, double y, double w, double h2, byte[] image) {
        this.imageData = image;
        this.initialized = true;
        this.origin = Origin.WRITE;
        this.x = x;
        this.y = y;
        this.width = w;
        this.height = h2;
        this.referenceCount = 1;
        this.type = ShapeType.PICTURE_FRAME;
    }

    private void initialize() {
        this.initialized = true;
    }

    @Override
    public final void setObjectId(int objid, int bip, int sid) {
        this.objectId = objid;
        this.blipId = bip;
        this.shapeId = sid;
        if (this.origin == Origin.READ) {
            this.origin = Origin.READ_WRITE;
        }
    }

    @Override
    public final int getObjectId() {
        if (!this.initialized) {
            this.initialize();
        }
        return this.objectId;
    }

    @Override
    public int getShapeId() {
        if (!this.initialized) {
            this.initialize();
        }
        return this.shapeId;
    }

    @Override
    public final int getBlipId() {
        if (!this.initialized) {
            this.initialize();
        }
        return this.blipId;
    }

    @Override
    public MsoDrawingRecord getMsoDrawingRecord() {
        return this.msoDrawingRecord;
    }

    @Override
    public EscherContainer getSpContainer() {
        if (!this.initialized) {
            this.initialize();
        }
        Assert.verify(this.origin == Origin.READ);
        return this.getReadSpContainer();
    }

    @Override
    public void setDrawingGroup(DrawingGroup dg) {
        this.drawingGroup = dg;
    }

    @Override
    public DrawingGroup getDrawingGroup() {
        return this.drawingGroup;
    }

    @Override
    public Origin getOrigin() {
        return this.origin;
    }

    @Override
    public int getReferenceCount() {
        return this.referenceCount;
    }

    @Override
    public void setReferenceCount(int r2) {
        this.referenceCount = r2;
    }

    @Override
    public double getX() {
        if (!this.initialized) {
            this.initialize();
        }
        return this.x;
    }

    @Override
    public void setX(double x) {
        if (this.origin == Origin.READ) {
            if (!this.initialized) {
                this.initialize();
            }
            this.origin = Origin.READ_WRITE;
        }
        this.x = x;
    }

    @Override
    public double getY() {
        if (!this.initialized) {
            this.initialize();
        }
        return this.y;
    }

    @Override
    public void setY(double y) {
        if (this.origin == Origin.READ) {
            if (!this.initialized) {
                this.initialize();
            }
            this.origin = Origin.READ_WRITE;
        }
        this.y = y;
    }

    @Override
    public double getWidth() {
        if (!this.initialized) {
            this.initialize();
        }
        return this.width;
    }

    @Override
    public void setWidth(double w) {
        if (this.origin == Origin.READ) {
            if (!this.initialized) {
                this.initialize();
            }
            this.origin = Origin.READ_WRITE;
        }
        this.width = w;
    }

    @Override
    public double getHeight() {
        if (!this.initialized) {
            this.initialize();
        }
        return this.height;
    }

    @Override
    public void setHeight(double h2) {
        if (this.origin == Origin.READ) {
            if (!this.initialized) {
                this.initialize();
            }
            this.origin = Origin.READ_WRITE;
        }
        this.height = h2;
    }

    private EscherContainer getReadSpContainer() {
        if (!this.initialized) {
            this.initialize();
        }
        return this.readSpContainer;
    }

    @Override
    public byte[] getImageData() {
        Assert.verify(false);
        Assert.verify(this.origin == Origin.READ || this.origin == Origin.READ_WRITE);
        if (!this.initialized) {
            this.initialize();
        }
        return this.drawingGroup.getImageData(this.blipId);
    }

    @Override
    public byte[] getImageBytes() throws IOException {
        Assert.verify(false);
        if (this.origin == Origin.READ || this.origin == Origin.READ_WRITE) {
            return this.getImageData();
        }
        Assert.verify(this.origin == Origin.WRITE);
        if (this.imageFile == null) {
            Assert.verify(this.imageData != null);
            return this.imageData;
        }
        byte[] data = new byte[(int)this.imageFile.length()];
        FileInputStream fis = new FileInputStream(this.imageFile);
        fis.read(data, 0, data.length);
        fis.close();
        return data;
    }

    @Override
    public ShapeType getType() {
        return this.type;
    }

    @Override
    public void writeAdditionalRecords(jxl.write.biff.File outputFile) throws IOException {
    }

    @Override
    public void writeTailRecords(jxl.write.biff.File outputFile) throws IOException {
    }

    public double getColumn() {
        return this.getX();
    }

    public double getRow() {
        return this.getY();
    }

    @Override
    public boolean isFirst() {
        return this.msoDrawingRecord.isFirst();
    }

    @Override
    public boolean isFormObject() {
        return false;
    }

    public void removeRow(int r2) {
        if (this.y > (double)r2) {
            this.setY(r2);
        }
    }

    @Override
    public String getImageFilePath() {
        Assert.verify(false);
        return null;
    }
}

