/*
 * Decompiled with CFR 0.152.
 */
package jxl.demo;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Iterator;
import jxl.Cell;
import jxl.CellType;
import jxl.FormulaCell;
import jxl.Sheet;
import jxl.Workbook;
import jxl.biff.CellReferenceHelper;
import jxl.biff.formula.FormulaException;

public class Formulas {
    public Formulas(Workbook w, OutputStream out, String encoding) throws IOException {
        if (encoding == null || !encoding.equals("UnicodeBig")) {
            encoding = "UTF8";
        }
        try {
            OutputStreamWriter osw = new OutputStreamWriter(out, encoding);
            BufferedWriter bw = new BufferedWriter(osw);
            ArrayList<String> parseErrors = new ArrayList<String>();
            for (int sheet = 0; sheet < w.getNumberOfSheets(); ++sheet) {
                Sheet s2 = w.getSheet(sheet);
                bw.write(s2.getName());
                bw.newLine();
                Cell[] row = null;
                Cell c2 = null;
                for (int i2 = 0; i2 < s2.getRows(); ++i2) {
                    row = s2.getRow(i2);
                    for (int j2 = 0; j2 < row.length; ++j2) {
                        c2 = row[j2];
                        if (c2.getType() != CellType.NUMBER_FORMULA && c2.getType() != CellType.STRING_FORMULA && c2.getType() != CellType.BOOLEAN_FORMULA && c2.getType() != CellType.DATE_FORMULA && c2.getType() != CellType.FORMULA_ERROR) continue;
                        FormulaCell nfc = (FormulaCell)c2;
                        StringBuffer sb = new StringBuffer();
                        CellReferenceHelper.getCellReference(c2.getColumn(), c2.getRow(), sb);
                        try {
                            bw.write("Formula in " + sb.toString() + " value:  " + c2.getContents());
                            bw.flush();
                            bw.write(" formula: " + nfc.getFormula());
                            bw.flush();
                            bw.newLine();
                            continue;
                        }
                        catch (FormulaException e2) {
                            bw.newLine();
                            parseErrors.add(s2.getName() + '!' + sb.toString() + ": " + e2.getMessage());
                        }
                    }
                }
            }
            bw.flush();
            bw.close();
            if (parseErrors.size() > 0) {
                System.err.println();
                System.err.println("There were " + parseErrors.size() + " errors");
                Iterator i3 = parseErrors.iterator();
                while (i3.hasNext()) {
                    System.err.println(i3.next());
                }
            }
        }
        catch (UnsupportedEncodingException e3) {
            System.err.println(e3.toString());
        }
    }
}

