/*
 * Decompiled with CFR 0.152.
 */
package jxl.write.biff;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import jxl.Cell;
import jxl.CellType;
import jxl.Range;
import jxl.WorkbookSettings;
import jxl.biff.SheetRangeImpl;
import jxl.common.Assert;
import jxl.common.Logger;
import jxl.write.Blank;
import jxl.write.WritableSheet;
import jxl.write.WriteException;
import jxl.write.biff.File;
import jxl.write.biff.MergedCellsRecord;
import jxl.write.biff.WritableSheetImpl;

class MergedCells {
    private static Logger logger = Logger.getLogger(MergedCells.class);
    private ArrayList ranges = new ArrayList();
    private WritableSheet sheet;
    private static final int maxRangesPerSheet = 1020;

    public MergedCells(WritableSheet ws) {
        this.sheet = ws;
    }

    void add(Range r2) {
        this.ranges.add(r2);
    }

    void insertRow(int row) {
        SheetRangeImpl sr2 = null;
        for (SheetRangeImpl sr2 : this.ranges) {
            sr2.insertRow(row);
        }
    }

    void insertColumn(int col) {
        SheetRangeImpl sr2 = null;
        for (SheetRangeImpl sr2 : this.ranges) {
            sr2.insertColumn(col);
        }
    }

    void removeColumn(int col) {
        SheetRangeImpl sr = null;
        Iterator i2 = this.ranges.iterator();
        while (i2.hasNext()) {
            sr = (SheetRangeImpl)i2.next();
            if (sr.getTopLeft().getColumn() == col && sr.getBottomRight().getColumn() == col) {
                i2.remove();
                continue;
            }
            sr.removeColumn(col);
        }
    }

    void removeRow(int row) {
        SheetRangeImpl sr = null;
        Iterator i2 = this.ranges.iterator();
        while (i2.hasNext()) {
            sr = (SheetRangeImpl)i2.next();
            if (sr.getTopLeft().getRow() == row && sr.getBottomRight().getRow() == row) {
                i2.remove();
                continue;
            }
            sr.removeRow(row);
        }
    }

    Range[] getMergedCells() {
        Range[] cells = new Range[this.ranges.size()];
        for (int i2 = 0; i2 < cells.length; ++i2) {
            cells[i2] = (Range)this.ranges.get(i2);
        }
        return cells;
    }

    void unmergeCells(Range r2) {
        int index = this.ranges.indexOf(r2);
        if (index != -1) {
            this.ranges.remove(index);
        }
    }

    private void checkIntersections() {
        ArrayList<SheetRangeImpl> newcells = new ArrayList<SheetRangeImpl>(this.ranges.size());
        for (SheetRangeImpl r2 : this.ranges) {
            Iterator i2 = newcells.iterator();
            SheetRangeImpl range = null;
            boolean intersects = false;
            while (i2.hasNext() && !intersects) {
                range = (SheetRangeImpl)i2.next();
                if (!range.intersects(r2)) continue;
                logger.warn("Could not merge cells " + r2 + " as they clash with an existing set of merged cells.");
                intersects = true;
            }
            if (intersects) continue;
            newcells.add(r2);
        }
        this.ranges = newcells;
    }

    private void checkRanges() {
        try {
            SheetRangeImpl range = null;
            for (int i2 = 0; i2 < this.ranges.size(); ++i2) {
                range = (SheetRangeImpl)this.ranges.get(i2);
                Cell tl = range.getTopLeft();
                Cell br = range.getBottomRight();
                boolean found = false;
                for (int c2 = tl.getColumn(); c2 <= br.getColumn(); ++c2) {
                    for (int r2 = tl.getRow(); r2 <= br.getRow(); ++r2) {
                        Cell cell = this.sheet.getCell(c2, r2);
                        if (cell.getType() == CellType.EMPTY) continue;
                        if (!found) {
                            found = true;
                            continue;
                        }
                        logger.warn("Range " + range + " contains more than one data cell.  " + "Setting the other cells to blank.");
                        Blank b2 = new Blank(c2, r2);
                        this.sheet.addCell(b2);
                    }
                }
            }
        }
        catch (WriteException e2) {
            Assert.verify(false);
        }
    }

    void write(File outputFile) throws IOException {
        if (this.ranges.size() == 0) {
            return;
        }
        WorkbookSettings ws = ((WritableSheetImpl)this.sheet).getWorkbookSettings();
        if (!ws.getMergedCellCheckingDisabled()) {
            this.checkIntersections();
            this.checkRanges();
        }
        if (this.ranges.size() < 1020) {
            MergedCellsRecord mcr = new MergedCellsRecord(this.ranges);
            outputFile.write(mcr);
            return;
        }
        int numRecordsRequired = this.ranges.size() / 1020 + 1;
        int pos = 0;
        for (int i2 = 0; i2 < numRecordsRequired; ++i2) {
            int numranges = Math.min(1020, this.ranges.size() - pos);
            ArrayList cells = new ArrayList(numranges);
            for (int j2 = 0; j2 < numranges; ++j2) {
                cells.add(this.ranges.get(pos + j2));
            }
            MergedCellsRecord mcr = new MergedCellsRecord(cells);
            outputFile.write(mcr);
            pos += numranges;
        }
    }
}

