/*
 * Decompiled with CFR 0.152.
 */
package jxl.write.biff;

import jxl.SheetSettings;
import jxl.biff.DoubleHelper;
import jxl.biff.IntegerHelper;
import jxl.biff.Type;
import jxl.biff.WritableRecordData;
import jxl.common.Logger;
import jxl.format.PageOrder;
import jxl.format.PageOrientation;
import jxl.format.PaperSize;

class SetupRecord
extends WritableRecordData {
    Logger logger = Logger.getLogger(SetupRecord.class);
    private byte[] data;
    private double headerMargin;
    private double footerMargin;
    private PageOrientation orientation;
    private PageOrder order;
    private int paperSize;
    private int scaleFactor;
    private int pageStart;
    private int fitWidth;
    private int fitHeight;
    private int horizontalPrintResolution;
    private int verticalPrintResolution;
    private int copies;
    private boolean initialized;

    public SetupRecord(SheetSettings s2) {
        super(Type.SETUP);
        this.orientation = s2.getOrientation();
        this.order = s2.getPageOrder();
        this.headerMargin = s2.getHeaderMargin();
        this.footerMargin = s2.getFooterMargin();
        this.paperSize = s2.getPaperSize().getValue();
        this.horizontalPrintResolution = s2.getHorizontalPrintResolution();
        this.verticalPrintResolution = s2.getVerticalPrintResolution();
        this.fitWidth = s2.getFitWidth();
        this.fitHeight = s2.getFitHeight();
        this.pageStart = s2.getPageStart();
        this.scaleFactor = s2.getScaleFactor();
        this.copies = s2.getCopies();
        this.initialized = true;
    }

    public void setOrientation(PageOrientation o2) {
        this.orientation = o2;
    }

    public void setOrder(PageOrder o2) {
        this.order = o2;
    }

    public void setMargins(double hm, double fm) {
        this.headerMargin = hm;
        this.footerMargin = fm;
    }

    public void setPaperSize(PaperSize ps) {
        this.paperSize = ps.getValue();
    }

    @Override
    public byte[] getData() {
        this.data = new byte[34];
        IntegerHelper.getTwoBytes(this.paperSize, this.data, 0);
        IntegerHelper.getTwoBytes(this.scaleFactor, this.data, 2);
        IntegerHelper.getTwoBytes(this.pageStart, this.data, 4);
        IntegerHelper.getTwoBytes(this.fitWidth, this.data, 6);
        IntegerHelper.getTwoBytes(this.fitHeight, this.data, 8);
        int options = 0;
        if (this.order == PageOrder.RIGHT_THEN_DOWN) {
            options |= 1;
        }
        if (this.orientation == PageOrientation.PORTRAIT) {
            options |= 2;
        }
        if (this.pageStart != 0) {
            options |= 0x80;
        }
        if (!this.initialized) {
            options |= 4;
        }
        IntegerHelper.getTwoBytes(options, this.data, 10);
        IntegerHelper.getTwoBytes(this.horizontalPrintResolution, this.data, 12);
        IntegerHelper.getTwoBytes(this.verticalPrintResolution, this.data, 14);
        DoubleHelper.getIEEEBytes(this.headerMargin, this.data, 16);
        DoubleHelper.getIEEEBytes(this.footerMargin, this.data, 24);
        IntegerHelper.getTwoBytes(this.copies, this.data, 32);
        return this.data;
    }
}

