/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.auxiliary.disk.jdbc.mysql;

import java.sql.SQLException;
import java.util.Map;
import org.apache.commons.jcs.auxiliary.disk.jdbc.JDBCDiskCache;
import org.apache.commons.jcs.auxiliary.disk.jdbc.TableState;
import org.apache.commons.jcs.auxiliary.disk.jdbc.dsfactory.DataSourceFactory;
import org.apache.commons.jcs.auxiliary.disk.jdbc.mysql.MySQLDiskCacheAttributes;
import org.apache.commons.jcs.engine.behavior.ICacheElement;
import org.apache.commons.jcs.engine.behavior.ICompositeCacheManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MySQLDiskCache<K, V>
extends JDBCDiskCache<K, V> {
    private static final Log log = LogFactory.getLog(MySQLDiskCache.class);
    private final MySQLDiskCacheAttributes mySQLDiskCacheAttributes;

    public MySQLDiskCache(MySQLDiskCacheAttributes attributes, DataSourceFactory dsFactory, TableState tableState, ICompositeCacheManager compositeCacheManager) throws SQLException {
        super(attributes, dsFactory, tableState, compositeCacheManager);
        this.mySQLDiskCacheAttributes = attributes;
        if (log.isDebugEnabled()) {
            log.debug("MySQLDiskCacheAttributes = " + attributes);
        }
    }

    @Override
    protected ICacheElement<K, V> processGet(K key) {
        if (this.getTableState().getState() == 2 && this.mySQLDiskCacheAttributes.isBalkDuringOptimization()) {
            return null;
        }
        return super.processGet(key);
    }

    @Override
    protected Map<K, ICacheElement<K, V>> processGetMatching(String pattern) {
        if (this.getTableState().getState() == 2 && this.mySQLDiskCacheAttributes.isBalkDuringOptimization()) {
            return null;
        }
        return super.processGetMatching(pattern);
    }

    @Override
    public String constructLikeParameterFromPattern(String pattern) {
        String likePattern = pattern.replaceAll("\\.\\+", "%");
        likePattern = likePattern.replaceAll("\\.", "_");
        if (log.isDebugEnabled()) {
            log.debug("pattern = [" + likePattern + "]");
        }
        return likePattern;
    }

    @Override
    protected void processUpdate(ICacheElement<K, V> element) {
        if (this.getTableState().getState() == 2 && this.mySQLDiskCacheAttributes.isBalkDuringOptimization()) {
            return;
        }
        super.processUpdate(element);
    }

    @Override
    protected int deleteExpired() {
        if (this.getTableState().getState() == 2 && this.mySQLDiskCacheAttributes.isBalkDuringOptimization()) {
            return -1;
        }
        return super.deleteExpired();
    }
}

