/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.auxiliary.lateral;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.jcs.auxiliary.AbstractAuxiliaryCache;
import org.apache.commons.jcs.auxiliary.AuxiliaryCacheAttributes;
import org.apache.commons.jcs.auxiliary.lateral.LateralCacheNoWait;
import org.apache.commons.jcs.auxiliary.lateral.behavior.ILateralCacheAttributes;
import org.apache.commons.jcs.auxiliary.lateral.behavior.ILateralCacheListener;
import org.apache.commons.jcs.engine.CacheStatus;
import org.apache.commons.jcs.engine.behavior.ICacheElement;
import org.apache.commons.jcs.engine.behavior.ICacheType;
import org.apache.commons.jcs.engine.stats.StatElement;
import org.apache.commons.jcs.engine.stats.Stats;
import org.apache.commons.jcs.engine.stats.behavior.IStats;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LateralCacheNoWaitFacade<K, V>
extends AbstractAuxiliaryCache<K, V> {
    private static final Log log = LogFactory.getLog(LateralCacheNoWaitFacade.class);
    public LateralCacheNoWait<K, V>[] noWaits;
    private final String cacheName;
    private ILateralCacheListener<K, V> listener;
    private final ILateralCacheAttributes lateralCacheAttributes;
    private boolean disposed = false;

    public LateralCacheNoWaitFacade(ILateralCacheListener<K, V> listener, LateralCacheNoWait<K, V>[] noWaits, ILateralCacheAttributes cattr) {
        if (log.isDebugEnabled()) {
            log.debug("CONSTRUCTING NO WAIT FACADE");
        }
        this.listener = listener;
        this.noWaits = noWaits;
        this.cacheName = cattr.getCacheName();
        this.lateralCacheAttributes = cattr;
    }

    public boolean containsNoWait(LateralCacheNoWait<K, V> noWait) {
        for (int i2 = 0; i2 < this.noWaits.length; ++i2) {
            if (!noWait.equals(this.noWaits[i2])) continue;
            return true;
        }
        return false;
    }

    public synchronized boolean addNoWait(LateralCacheNoWait<K, V> noWait) {
        if (noWait == null) {
            return false;
        }
        if (this.containsNoWait(noWait)) {
            if (log.isDebugEnabled()) {
                log.debug("No Wait already contained, [" + noWait + "]");
            }
            return false;
        }
        LateralCacheNoWait[] newArray = new LateralCacheNoWait[this.noWaits.length + 1];
        System.arraycopy(this.noWaits, 0, newArray, 0, this.noWaits.length);
        newArray[this.noWaits.length] = noWait;
        this.noWaits = newArray;
        return true;
    }

    public synchronized boolean removeNoWait(LateralCacheNoWait<K, V> noWait) {
        if (noWait == null) {
            return false;
        }
        int position = -1;
        for (int i2 = 0; i2 < this.noWaits.length; ++i2) {
            if (!noWait.equals(this.noWaits[i2])) continue;
            position = i2;
            break;
        }
        if (position == -1) {
            return false;
        }
        LateralCacheNoWait[] newArray = new LateralCacheNoWait[this.noWaits.length - 1];
        System.arraycopy(this.noWaits, 0, newArray, 0, position);
        if (this.noWaits.length != position) {
            System.arraycopy(this.noWaits, position + 1, newArray, position, this.noWaits.length - position - 1);
        }
        this.noWaits = newArray;
        return true;
    }

    @Override
    public void update(ICacheElement<K, V> ce) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug("updating through lateral cache facade, noWaits.length = " + this.noWaits.length);
        }
        try {
            for (int i2 = 0; i2 < this.noWaits.length; ++i2) {
                this.noWaits[i2].update(ce);
            }
        }
        catch (Exception ex) {
            log.error(ex);
        }
    }

    @Override
    public ICacheElement<K, V> get(K key) {
        for (int i2 = 0; i2 < this.noWaits.length; ++i2) {
            try {
                ICacheElement<K, V> obj = this.noWaits[i2].get(key);
                if (obj == null) continue;
                return obj;
            }
            catch (Exception ex) {
                log.error("Failed to get", ex);
            }
        }
        return null;
    }

    @Override
    public Map<K, ICacheElement<K, V>> getMultiple(Set<K> keys) {
        HashMap<K, ICacheElement<K, V>> elements = new HashMap<K, ICacheElement<K, V>>();
        if (keys != null && !keys.isEmpty()) {
            for (K key : keys) {
                ICacheElement<K, V> element = this.get(key);
                if (element == null) continue;
                elements.put(key, element);
            }
        }
        return elements;
    }

    @Override
    public Map<K, ICacheElement<K, V>> getMatching(String pattern) {
        HashMap<K, ICacheElement<K, V>> elements = new HashMap<K, ICacheElement<K, V>>();
        for (int i2 = 0; i2 < this.noWaits.length; ++i2) {
            try {
                elements.putAll(this.noWaits[i2].getMatching(pattern));
                continue;
            }
            catch (Exception ex) {
                log.error("Failed to get", ex);
            }
        }
        return elements;
    }

    @Override
    public Set<K> getKeySet() throws IOException {
        HashSet allKeys = new HashSet();
        for (int i2 = 0; i2 < this.noWaits.length; ++i2) {
            Set keys;
            LateralCacheNoWait<K, V> aux = this.noWaits[i2];
            if (aux == null || (keys = aux.getKeySet()) == null) continue;
            allKeys.addAll(keys);
        }
        return allKeys;
    }

    @Override
    public boolean remove(K key) {
        try {
            for (int i2 = 0; i2 < this.noWaits.length; ++i2) {
                this.noWaits[i2].remove(key);
            }
        }
        catch (Exception ex) {
            log.error(ex);
        }
        return false;
    }

    @Override
    public void removeAll() {
        try {
            for (int i2 = 0; i2 < this.noWaits.length; ++i2) {
                this.noWaits[i2].removeAll();
            }
        }
        catch (Exception ex) {
            log.error(ex);
        }
    }

    @Override
    public void dispose() {
        try {
            if (this.listener != null) {
                this.listener.dispose();
                this.listener = null;
            }
            for (int i2 = 0; i2 < this.noWaits.length; ++i2) {
                this.noWaits[i2].dispose();
            }
        }
        catch (Exception ex) {
            log.error(ex);
        }
        finally {
            this.disposed = true;
        }
    }

    @Override
    public int getSize() {
        return 0;
    }

    @Override
    public ICacheType.CacheType getCacheType() {
        return ICacheType.CacheType.LATERAL_CACHE;
    }

    @Override
    public String getCacheName() {
        return "";
    }

    @Override
    public CacheStatus getStatus() {
        int i2;
        if (this.disposed) {
            return CacheStatus.DISPOSED;
        }
        if (this.noWaits.length == 0 || this.listener != null) {
            return CacheStatus.ALIVE;
        }
        CacheStatus[] statii = new CacheStatus[this.noWaits.length];
        for (i2 = 0; i2 < this.noWaits.length; ++i2) {
            statii[i2] = this.noWaits[i2].getStatus();
        }
        for (i2 = 0; i2 < this.noWaits.length; ++i2) {
            if (statii[i2] != CacheStatus.ALIVE) continue;
            return CacheStatus.ALIVE;
        }
        for (i2 = 0; i2 < this.noWaits.length; ++i2) {
            if (statii[i2] != CacheStatus.ERROR) continue;
            return CacheStatus.ERROR;
        }
        return CacheStatus.DISPOSED;
    }

    @Override
    public AuxiliaryCacheAttributes getAuxiliaryCacheAttributes() {
        return this.lateralCacheAttributes;
    }

    public String toString() {
        return "LateralCacheNoWaitFacade: " + this.cacheName;
    }

    @Override
    public String getEventLoggingExtraInfo() {
        return "Lateral Cache No Wait";
    }

    @Override
    public String getStats() {
        return this.getStatistics().toString();
    }

    @Override
    public IStats getStatistics() {
        Stats stats = new Stats();
        stats.setTypeName("Lateral Cache No Wait Facade");
        ArrayList elems = new ArrayList();
        if (this.noWaits != null) {
            elems.add(new StatElement<Integer>("Number of No Waits", this.noWaits.length));
            for (LateralCacheNoWait<K, V> lcnw : this.noWaits) {
                if (lcnw == null) continue;
                IStats sStats = lcnw.getStatistics();
                elems.addAll(sStats.getStatElements());
            }
        }
        stats.setStatElements(elems);
        return stats;
    }
}

