/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.auxiliary.remote;

import java.util.List;
import org.apache.commons.jcs.auxiliary.remote.AbstractRemoteCacheNoWaitFacade;
import org.apache.commons.jcs.auxiliary.remote.RemoteCacheAttributes;
import org.apache.commons.jcs.auxiliary.remote.RemoteCacheFactory;
import org.apache.commons.jcs.auxiliary.remote.RemoteCacheFailoverRunner;
import org.apache.commons.jcs.auxiliary.remote.RemoteCacheNoWait;
import org.apache.commons.jcs.auxiliary.remote.behavior.IRemoteCacheAttributes;
import org.apache.commons.jcs.auxiliary.remote.server.behavior.RemoteType;
import org.apache.commons.jcs.engine.CacheStatus;
import org.apache.commons.jcs.engine.behavior.ICache;
import org.apache.commons.jcs.engine.behavior.ICompositeCacheManager;
import org.apache.commons.jcs.engine.behavior.IElementSerializer;
import org.apache.commons.jcs.engine.logging.behavior.ICacheEventLogger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RemoteCacheNoWaitFacade<K, V>
extends AbstractRemoteCacheNoWaitFacade<K, V> {
    private static final Log log = LogFactory.getLog(RemoteCacheNoWaitFacade.class);
    private final RemoteCacheFactory cacheFactory;

    public RemoteCacheNoWaitFacade(List<RemoteCacheNoWait<K, V>> noWaits, IRemoteCacheAttributes rca, ICacheEventLogger cacheEventLogger, IElementSerializer elementSerializer, RemoteCacheFactory cacheFactory) {
        super(noWaits, rca, cacheEventLogger, elementSerializer);
        this.cacheFactory = cacheFactory;
    }

    @Deprecated
    public RemoteCacheNoWaitFacade(List<ICache<K, V>> noWaits, RemoteCacheAttributes rca, ICompositeCacheManager cacheMgr, ICacheEventLogger cacheEventLogger, IElementSerializer elementSerializer, RemoteCacheFactory cacheFactory) {
        super(noWaits, rca, cacheMgr, cacheEventLogger, elementSerializer);
        this.cacheFactory = cacheFactory;
    }

    @Override
    protected void failover(RemoteCacheNoWait<K, V> rcnw) {
        if (log.isDebugEnabled()) {
            log.debug("in failover for " + rcnw);
        }
        if (this.getAuxiliaryCacheAttributes().getRemoteType() == RemoteType.LOCAL) {
            if (rcnw.getStatus() == CacheStatus.ERROR) {
                RemoteCacheFailoverRunner runner = new RemoteCacheFailoverRunner(this, this.cacheFactory);
                runner.setDaemon(true);
                runner.start();
                runner.notifyError();
                if (this.getCacheEventLogger() != null) {
                    this.getCacheEventLogger().logApplicationEvent("RemoteCacheNoWaitFacade", "InitiatedFailover", rcnw + " was in error.");
                }
            } else if (log.isInfoEnabled()) {
                log.info("The noWait is not in error");
            }
        }
    }
}

