/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.auxiliary.remote.http.client;

import java.io.IOException;
import org.apache.commons.jcs.auxiliary.remote.AbstractRemoteAuxiliaryCache;
import org.apache.commons.jcs.auxiliary.remote.behavior.IRemoteCacheListener;
import org.apache.commons.jcs.auxiliary.remote.http.client.RemoteHttpCacheAttributes;
import org.apache.commons.jcs.auxiliary.remote.http.client.RemoteHttpCacheMonitor;
import org.apache.commons.jcs.engine.ZombieCacheServiceNonLocal;
import org.apache.commons.jcs.engine.behavior.ICacheServiceNonLocal;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RemoteHttpCache<K, V>
extends AbstractRemoteAuxiliaryCache<K, V> {
    private static final Log log = LogFactory.getLog(RemoteHttpCache.class);
    private RemoteHttpCacheMonitor monitor;
    private RemoteHttpCacheAttributes remoteHttpCacheAttributes;

    public RemoteHttpCache(RemoteHttpCacheAttributes remoteHttpCacheAttributes, ICacheServiceNonLocal<K, V> remote, IRemoteCacheListener<K, V> listener, RemoteHttpCacheMonitor monitor) {
        super(remoteHttpCacheAttributes, remote, listener);
        this.remoteHttpCacheAttributes = remoteHttpCacheAttributes;
        this.monitor = monitor;
    }

    @Override
    protected void handleException(Exception ex, String msg, String eventName) throws IOException {
        if (!(this.getRemoteCacheService() instanceof ZombieCacheServiceNonLocal)) {
            String message = "Disabling remote cache due to error: " + msg;
            this.logError(this.cacheName, "", message);
            log.error(message, ex);
            this.setRemoteCacheService(new ZombieCacheServiceNonLocal(this.getRemoteCacheAttributes().getZombieQueueMaxSize()));
            this.monitor.notifyError(this);
        }
        if (ex instanceof IOException) {
            throw (IOException)ex;
        }
        throw new IOException(ex.getMessage());
    }

    @Override
    public String getEventLoggingExtraInfo() {
        return null;
    }

    public RemoteHttpCacheAttributes getRemoteHttpCacheAttributes() {
        return this.remoteHttpCacheAttributes;
    }
}

