/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.auxiliary.remote.server;

import java.io.IOException;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.rmi.server.RMISocketFactory;
import java.rmi.server.UnicastRemoteObject;
import java.rmi.server.Unreferenced;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.jcs.access.exception.CacheException;
import org.apache.commons.jcs.auxiliary.remote.RemoteUtils;
import org.apache.commons.jcs.auxiliary.remote.behavior.IRemoteCacheListener;
import org.apache.commons.jcs.auxiliary.remote.server.RemoteCacheServerFactory;
import org.apache.commons.jcs.auxiliary.remote.server.behavior.IRemoteCacheServer;
import org.apache.commons.jcs.auxiliary.remote.server.behavior.IRemoteCacheServerAttributes;
import org.apache.commons.jcs.auxiliary.remote.server.behavior.RemoteType;
import org.apache.commons.jcs.engine.CacheEventQueueFactory;
import org.apache.commons.jcs.engine.CacheListeners;
import org.apache.commons.jcs.engine.behavior.ICacheElement;
import org.apache.commons.jcs.engine.behavior.ICacheEventQueue;
import org.apache.commons.jcs.engine.behavior.ICacheListener;
import org.apache.commons.jcs.engine.control.CompositeCache;
import org.apache.commons.jcs.engine.control.CompositeCacheManager;
import org.apache.commons.jcs.engine.logging.CacheEvent;
import org.apache.commons.jcs.engine.logging.behavior.ICacheEvent;
import org.apache.commons.jcs.engine.logging.behavior.ICacheEventLogger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RemoteCacheServer<K, V>
extends UnicastRemoteObject
implements IRemoteCacheServer<K, V>,
Unreferenced {
    public static final String DFEAULT_REMOTE_CONFIGURATION_FILE = "/remote.cache.ccf";
    private static final long serialVersionUID = -8072345435941473116L;
    private static final Log log = LogFactory.getLog(RemoteCacheServer.class);
    private static final boolean timing = true;
    private int puts = 0;
    private final transient ConcurrentMap<String, CacheListeners<K, V>> cacheListenersMap = new ConcurrentHashMap<String, CacheListeners<K, V>>();
    private final transient ConcurrentMap<String, CacheListeners<K, V>> clusterListenersMap = new ConcurrentHashMap<String, CacheListeners<K, V>>();
    private transient CompositeCacheManager cacheManager;
    private final ConcurrentMap<Long, RemoteType> idTypeMap = new ConcurrentHashMap<Long, RemoteType>();
    private final ConcurrentMap<Long, String> idIPMap = new ConcurrentHashMap<Long, String>();
    private final int[] listenerId = new int[1];
    final IRemoteCacheServerAttributes remoteCacheServerAttributes;
    private final int logInterval = 100;
    private transient ICacheEventLogger cacheEventLogger;
    private ReentrantLock cacheListenersLock = new ReentrantLock();
    private ReentrantLock clusterListenersLock = new ReentrantLock();

    protected RemoteCacheServer(IRemoteCacheServerAttributes rcsa, Properties config) throws RemoteException {
        super(rcsa.getServicePort());
        this.remoteCacheServerAttributes = rcsa;
        this.init(config);
    }

    protected RemoteCacheServer(IRemoteCacheServerAttributes rcsa, Properties config, RMISocketFactory customRMISocketFactory) throws RemoteException {
        super(rcsa.getServicePort(), customRMISocketFactory, customRMISocketFactory);
        this.remoteCacheServerAttributes = rcsa;
        this.init(config);
    }

    @Deprecated
    protected RemoteCacheServer(IRemoteCacheServerAttributes rcsa) throws RemoteException {
        super(rcsa.getServicePort());
        this.remoteCacheServerAttributes = rcsa;
        this.init(rcsa.getConfigFileName());
    }

    @Deprecated
    protected RemoteCacheServer(IRemoteCacheServerAttributes rcsa, RMISocketFactory customRMISocketFactory) throws RemoteException {
        super(rcsa.getServicePort(), customRMISocketFactory, customRMISocketFactory);
        this.remoteCacheServerAttributes = rcsa;
        this.init(rcsa.getConfigFileName());
    }

    @Deprecated
    private void init(String propFile) throws RemoteException {
        String propFileName = propFile == null ? DFEAULT_REMOTE_CONFIGURATION_FILE : propFile;
        Properties prop = null;
        try {
            prop = RemoteUtils.loadProps(propFileName);
        }
        catch (IOException e2) {
            throw new RemoteException(e2.getMessage(), e2);
        }
        this.init(prop);
    }

    private void init(Properties prop) throws RemoteException {
        try {
            this.cacheManager = this.createCacheManager(prop);
        }
        catch (CacheException e2) {
            throw new RemoteException(e2.getMessage(), e2);
        }
        String[] list = this.cacheManager.getCacheNames();
        for (int i2 = 0; i2 < list.length; ++i2) {
            String name = list[i2];
            CompositeCache cache = this.cacheManager.getCache(name);
            this.cacheListenersMap.put(name, new CacheListeners(cache));
        }
    }

    private CompositeCacheManager createCacheManager(Properties prop) throws CacheException {
        CompositeCacheManager hub = CompositeCacheManager.getUnconfiguredInstance();
        hub.configure(prop);
        return hub;
    }

    public void put(ICacheElement<K, V> item) throws IOException {
        this.update(item);
    }

    @Override
    public void update(ICacheElement<K, V> item) throws IOException {
        this.update(item, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(ICacheElement<K, V> item, long requesterId) throws IOException {
        ICacheEvent<ICacheElement<K, V>> cacheEvent = this.createICacheEvent(item, requesterId, "update");
        try {
            this.processUpdate(item, requesterId);
        }
        finally {
            this.logICacheEvent(cacheEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processUpdate(ICacheElement<K, V> item, long requesterId) {
        long start = 0L;
        start = System.currentTimeMillis();
        this.logUpdateInfo(item);
        try {
            CacheListeners<K, V> cacheDesc = this.getCacheListeners(item.getCacheName());
            item.getVal();
            boolean fromCluster = this.isRequestFromCluster(requesterId);
            if (log.isDebugEnabled()) {
                log.debug("In update, requesterId = [" + requesterId + "] fromCluster = " + fromCluster);
            }
            CacheListeners<K, V> cacheListeners = cacheDesc;
            synchronized (cacheListeners) {
                block17: {
                    try {
                        CompositeCache c2 = (CompositeCache)cacheDesc.cache;
                        if (fromCluster) {
                            if (log.isDebugEnabled()) {
                                log.debug("Put FROM cluster, NOT updating other auxiliaries for region.  requesterId [" + requesterId + "]");
                            }
                            c2.localUpdate(item);
                        } else {
                            if (log.isDebugEnabled()) {
                                log.debug("Put NOT from cluster, updating other auxiliaries for region.  requesterId [" + requesterId + "]");
                            }
                            c2.update(item);
                        }
                    }
                    catch (Exception ce) {
                        if (!log.isInfoEnabled()) break block17;
                        log.info("Exception caught updating item. requesterId [" + requesterId + "] " + ce.getMessage());
                    }
                }
                if (!fromCluster || fromCluster && this.remoteCacheServerAttributes.isLocalClusterConsistency()) {
                    ICacheEventQueue<K, V>[] qlist = this.getEventQList(cacheDesc, requesterId);
                    if (log.isDebugEnabled()) {
                        log.debug("qlist.length = " + qlist.length);
                    }
                    for (int i2 = 0; i2 < qlist.length; ++i2) {
                        qlist[i2].addPutEvent(item);
                    }
                }
            }
        }
        catch (IOException e2) {
            if (this.cacheEventLogger != null) {
                this.cacheEventLogger.logError("RemoteCacheServer", "update", e2.getMessage() + " REGION: " + item.getCacheName() + " ITEM: " + item);
            }
            log.error("Trouble in Update. requesterId [" + requesterId + "]", e2);
        }
        long end = System.currentTimeMillis();
        if (log.isDebugEnabled()) {
            log.debug("put took " + String.valueOf(end - start) + " ms.");
        }
    }

    private void logUpdateInfo(ICacheElement<K, V> item) {
        ++this.puts;
        if (log.isInfoEnabled() && this.puts % 100 == 0) {
            log.info("puts = " + this.puts);
        }
        if (log.isDebugEnabled()) {
            log.debug("In update, put [" + item.getKey() + "] in [" + item.getCacheName() + "]");
        }
    }

    @Override
    public ICacheElement<K, V> get(String cacheName, K key) throws IOException {
        return this.get(cacheName, key, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ICacheElement<K, V> get(String cacheName, K key, long requesterId) throws IOException {
        ICacheElement<K, V> element = null;
        ICacheEvent<K> cacheEvent = this.createICacheEvent(cacheName, key, requesterId, "get");
        try {
            element = this.processGet(cacheName, key, requesterId);
        }
        finally {
            this.logICacheEvent(cacheEvent);
        }
        return element;
    }

    private ICacheElement<K, V> processGet(String cacheName, K key, long requesterId) {
        CacheListeners<K, V> cacheDesc;
        boolean fromCluster;
        block3: {
            fromCluster = this.isRequestFromCluster(requesterId);
            if (log.isDebugEnabled()) {
                log.debug("get [" + key + "] from cache [" + cacheName + "] requesterId = [" + requesterId + "] fromCluster = " + fromCluster);
            }
            cacheDesc = null;
            try {
                cacheDesc = this.getCacheListeners(cacheName);
            }
            catch (Exception e2) {
                log.error("Problem getting listeners.", e2);
                if (this.cacheEventLogger == null) break block3;
                this.cacheEventLogger.logError("RemoteCacheServer", "get", e2.getMessage() + cacheName + " KEY: " + key);
            }
        }
        ICacheElement<K, V> element = this.getFromCacheListeners(key, fromCluster, cacheDesc, null);
        return element;
    }

    private ICacheElement<K, V> getFromCacheListeners(K key, boolean fromCluster, CacheListeners<K, V> cacheDesc, ICacheElement<K, V> element) {
        ICacheElement<K, V> returnElement = element;
        if (cacheDesc != null) {
            CompositeCache c2 = (CompositeCache)cacheDesc.cache;
            if (!fromCluster && this.remoteCacheServerAttributes.isAllowClusterGet()) {
                if (log.isDebugEnabled()) {
                    log.debug("NonLocalGet. fromCluster [" + fromCluster + "] AllowClusterGet [" + this.remoteCacheServerAttributes.isAllowClusterGet() + "]");
                }
                returnElement = c2.get(key);
            } else {
                if (log.isDebugEnabled()) {
                    log.debug("LocalGet.  fromCluster [" + fromCluster + "] AllowClusterGet [" + this.remoteCacheServerAttributes.isAllowClusterGet() + "]");
                }
                returnElement = c2.localGet(key);
            }
        }
        return returnElement;
    }

    @Override
    public Map<K, ICacheElement<K, V>> getMatching(String cacheName, String pattern) throws IOException {
        return this.getMatching(cacheName, pattern, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<K, ICacheElement<K, V>> getMatching(String cacheName, String pattern, long requesterId) throws IOException {
        ICacheEvent<String> cacheEvent = this.createICacheEvent(cacheName, pattern, requesterId, "getMatching");
        try {
            Map<K, ICacheElement<K, V>> map = this.processGetMatching(cacheName, pattern, requesterId);
            return map;
        }
        finally {
            this.logICacheEvent(cacheEvent);
        }
    }

    protected Map<K, ICacheElement<K, V>> processGetMatching(String cacheName, String pattern, long requesterId) {
        CacheListeners<K, V> cacheDesc;
        boolean fromCluster;
        block3: {
            fromCluster = this.isRequestFromCluster(requesterId);
            if (log.isDebugEnabled()) {
                log.debug("getMatching [" + pattern + "] from cache [" + cacheName + "] requesterId = [" + requesterId + "] fromCluster = " + fromCluster);
            }
            cacheDesc = null;
            try {
                cacheDesc = this.getCacheListeners(cacheName);
            }
            catch (Exception e2) {
                log.error("Problem getting listeners.", e2);
                if (this.cacheEventLogger == null) break block3;
                this.cacheEventLogger.logError("RemoteCacheServer", "getMatching", e2.getMessage() + cacheName + " pattern: " + pattern);
            }
        }
        return this.getMatchingFromCacheListeners(pattern, fromCluster, cacheDesc);
    }

    private Map<K, ICacheElement<K, V>> getMatchingFromCacheListeners(String pattern, boolean fromCluster, CacheListeners<K, V> cacheDesc) {
        Map elements = null;
        if (cacheDesc != null) {
            CompositeCache c2 = (CompositeCache)cacheDesc.cache;
            if (!fromCluster && this.remoteCacheServerAttributes.isAllowClusterGet()) {
                if (log.isDebugEnabled()) {
                    log.debug("NonLocalGetMatching. fromCluster [" + fromCluster + "] AllowClusterGet [" + this.remoteCacheServerAttributes.isAllowClusterGet() + "]");
                }
                elements = c2.getMatching(pattern);
            } else {
                if (log.isDebugEnabled()) {
                    log.debug("LocalGetMatching.  fromCluster [" + fromCluster + "] AllowClusterGet [" + this.remoteCacheServerAttributes.isAllowClusterGet() + "]");
                }
                elements = c2.localGetMatching(pattern);
            }
        }
        return elements;
    }

    @Override
    public Map<K, ICacheElement<K, V>> getMultiple(String cacheName, Set<K> keys) throws IOException {
        return this.getMultiple(cacheName, keys, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<K, ICacheElement<K, V>> getMultiple(String cacheName, Set<K> keys, long requesterId) throws IOException {
        ICacheEvent<Serializable> cacheEvent = this.createICacheEvent(cacheName, (Serializable)((Object)keys), requesterId, "getMultiple");
        try {
            Map<K, ICacheElement<K, V>> map = this.processGetMultiple(cacheName, keys, requesterId);
            return map;
        }
        finally {
            this.logICacheEvent(cacheEvent);
        }
    }

    private Map<K, ICacheElement<K, V>> processGetMultiple(String cacheName, Set<K> keys, long requesterId) {
        boolean fromCluster = this.isRequestFromCluster(requesterId);
        if (log.isDebugEnabled()) {
            log.debug("getMultiple [" + keys + "] from cache [" + cacheName + "] requesterId = [" + requesterId + "] fromCluster = " + fromCluster);
        }
        CacheListeners<K, V> cacheDesc = this.getCacheListeners(cacheName);
        Map<K, ICacheElement<K, V>> elements = this.getMultipleFromCacheListeners(keys, null, fromCluster, cacheDesc);
        return elements;
    }

    private boolean isRequestFromCluster(long requesterId) {
        RemoteType remoteTypeL = (RemoteType)((Object)this.idTypeMap.get(requesterId));
        return remoteTypeL == RemoteType.CLUSTER;
    }

    private Map<K, ICacheElement<K, V>> getMultipleFromCacheListeners(Set<K> keys, Map<K, ICacheElement<K, V>> elements, boolean fromCluster, CacheListeners<K, V> cacheDesc) {
        Map<K, ICacheElement<K, V>> returnElements = elements;
        if (cacheDesc != null) {
            CompositeCache c2 = (CompositeCache)cacheDesc.cache;
            if (!fromCluster && this.remoteCacheServerAttributes.isAllowClusterGet()) {
                if (log.isDebugEnabled()) {
                    log.debug("NonLocalGetMultiple. fromCluster [" + fromCluster + "] AllowClusterGet [" + this.remoteCacheServerAttributes.isAllowClusterGet() + "]");
                }
                returnElements = c2.getMultiple(keys);
            } else {
                if (log.isDebugEnabled()) {
                    log.debug("LocalGetMultiple.  fromCluster [" + fromCluster + "] AllowClusterGet [" + this.remoteCacheServerAttributes.isAllowClusterGet() + "]");
                }
                returnElements = c2.localGetMultiple(keys);
            }
        }
        return returnElements;
    }

    @Override
    public Set<K> getKeySet(String cacheName) throws IOException {
        return this.processGetKeySet(cacheName);
    }

    protected Set<K> processGetKeySet(String cacheName) {
        CacheListeners<K, V> cacheDesc = null;
        try {
            cacheDesc = this.getCacheListeners(cacheName);
        }
        catch (Exception e2) {
            log.error("Problem getting listeners.", e2);
        }
        if (cacheDesc == null) {
            return Collections.emptySet();
        }
        CompositeCache c2 = (CompositeCache)cacheDesc.cache;
        return c2.getKeySet();
    }

    @Override
    public void remove(String cacheName, K key) throws IOException {
        this.remove(cacheName, key, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(String cacheName, K key, long requesterId) throws IOException {
        ICacheEvent<K> cacheEvent = this.createICacheEvent(cacheName, key, requesterId, "remove");
        try {
            this.processRemove(cacheName, key, requesterId);
        }
        finally {
            this.logICacheEvent(cacheEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processRemove(String cacheName, K key, long requesterId) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug("remove [" + key + "] from cache [" + cacheName + "]");
        }
        CacheListeners cacheDesc = (CacheListeners)this.cacheListenersMap.get(cacheName);
        boolean fromCluster = this.isRequestFromCluster(requesterId);
        if (cacheDesc != null) {
            CacheListeners cacheListeners = cacheDesc;
            synchronized (cacheListeners) {
                boolean removeSuccess = false;
                CompositeCache c2 = (CompositeCache)cacheDesc.cache;
                if (fromCluster) {
                    if (log.isDebugEnabled()) {
                        log.debug("Remove FROM cluster, NOT updating other auxiliaries for region");
                    }
                    removeSuccess = c2.localRemove(key);
                } else {
                    if (log.isDebugEnabled()) {
                        log.debug("Remove NOT from cluster, updating other auxiliaries for region");
                    }
                    removeSuccess = c2.remove(key);
                }
                if (log.isDebugEnabled()) {
                    log.debug("remove [" + key + "] from cache [" + cacheName + "] success (was it found) = " + removeSuccess);
                }
                if (!fromCluster || fromCluster && this.remoteCacheServerAttributes.isLocalClusterConsistency()) {
                    ICacheEventQueue<K, V>[] qlist = this.getEventQList(cacheDesc, requesterId);
                    for (int i2 = 0; i2 < qlist.length; ++i2) {
                        qlist[i2].addRemoveEvent(key);
                    }
                }
            }
        }
    }

    @Override
    public void removeAll(String cacheName) throws IOException {
        this.removeAll(cacheName, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAll(String cacheName, long requesterId) throws IOException {
        ICacheEvent<String> cacheEvent = this.createICacheEvent(cacheName, "all", requesterId, "removeAll");
        try {
            this.processRemoveAll(cacheName, requesterId);
        }
        finally {
            this.logICacheEvent(cacheEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processRemoveAll(String cacheName, long requesterId) throws IOException {
        CacheListeners cacheDesc = (CacheListeners)this.cacheListenersMap.get(cacheName);
        boolean fromCluster = this.isRequestFromCluster(requesterId);
        if (cacheDesc != null) {
            CacheListeners cacheListeners = cacheDesc;
            synchronized (cacheListeners) {
                CompositeCache c2 = (CompositeCache)cacheDesc.cache;
                if (fromCluster) {
                    if (log.isDebugEnabled()) {
                        log.debug("RemoveALL FROM cluster, NOT updating other auxiliaries for region");
                    }
                    c2.localRemoveAll();
                } else {
                    if (log.isDebugEnabled()) {
                        log.debug("RemoveALL NOT from cluster, updating other auxiliaries for region");
                    }
                    c2.removeAll();
                }
                if (!fromCluster || fromCluster && this.remoteCacheServerAttributes.isLocalClusterConsistency()) {
                    ICacheEventQueue<K, V>[] qlist = this.getEventQList(cacheDesc, requesterId);
                    for (int i2 = 0; i2 < qlist.length; ++i2) {
                        qlist[i2].addRemoveAllEvent();
                    }
                }
            }
        }
    }

    int getPutCount() {
        return this.puts;
    }

    @Override
    public void dispose(String cacheName) throws IOException {
        this.dispose(cacheName, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose(String cacheName, long requesterId) throws IOException {
        ICacheEvent<String> cacheEvent = this.createICacheEvent(cacheName, "none", requesterId, "dispose");
        try {
            this.processDispose(cacheName, requesterId);
        }
        finally {
            this.logICacheEvent(cacheEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processDispose(String cacheName, long requesterId) throws IOException {
        CacheListeners cacheDesc;
        if (log.isInfoEnabled()) {
            log.info("Dispose request received from listener [" + requesterId + "]");
        }
        if ((cacheDesc = (CacheListeners)this.cacheListenersMap.get(cacheName)) != null) {
            CacheListeners cacheListeners = cacheDesc;
            synchronized (cacheListeners) {
                ICacheEventQueue<K, V>[] qlist = this.getEventQList(cacheDesc, requesterId);
                for (int i2 = 0; i2 < qlist.length; ++i2) {
                    qlist[i2].addDisposeEvent();
                }
                this.cacheManager.freeCache(cacheName);
            }
        }
    }

    @Override
    public void release() throws IOException {
        for (CacheListeners cacheDesc : this.cacheListenersMap.values()) {
            ICacheEventQueue<K, V>[] qlist = this.getEventQList(cacheDesc, 0L);
            for (int i2 = 0; i2 < qlist.length; ++i2) {
                qlist[i2].addDisposeEvent();
            }
        }
        this.cacheManager.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CacheListeners<K, V> getCacheListeners(String cacheName) {
        CacheListeners cacheListeners = (CacheListeners)this.cacheListenersMap.get(cacheName);
        if (cacheListeners == null) {
            this.cacheListenersLock.lock();
            try {
                cacheListeners = (CacheListeners)this.cacheListenersMap.get(cacheName);
                if (cacheListeners == null) {
                    CompositeCache cache = this.cacheManager.getCache(cacheName);
                    cacheListeners = new CacheListeners(cache);
                    this.cacheListenersMap.put(cacheName, cacheListeners);
                }
            }
            finally {
                this.cacheListenersLock.unlock();
            }
        }
        return cacheListeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CacheListeners<K, V> getClusterListeners(String cacheName) {
        CacheListeners cacheListeners = (CacheListeners)this.clusterListenersMap.get(cacheName);
        if (cacheListeners == null) {
            this.clusterListenersLock.lock();
            try {
                cacheListeners = (CacheListeners)this.clusterListenersMap.get(cacheName);
                if (cacheListeners == null) {
                    CompositeCache cache = this.cacheManager.getCache(cacheName);
                    cacheListeners = new CacheListeners(cache);
                    this.clusterListenersMap.put(cacheName, cacheListeners);
                }
            }
            finally {
                this.clusterListenersLock.unlock();
            }
        }
        return cacheListeners;
    }

    private ICacheEventQueue<K, V>[] getEventQList(CacheListeners<K, V> cacheListeners, long requesterId) {
        ICacheEventQueue[] list = cacheListeners.eventQMap.values().toArray(new ICacheEventQueue[0]);
        int count = 0;
        for (int i2 = 0; i2 < list.length; ++i2) {
            ICacheEventQueue q2 = list[i2];
            if (q2.isWorking() && q2.getListenerId() != requesterId) {
                ++count;
                continue;
            }
            list[i2] = null;
        }
        if (count == list.length) {
            return list;
        }
        ICacheEventQueue[] qq = new ICacheEventQueue[count];
        count = 0;
        for (int i3 = 0; i3 < list.length; ++i3) {
            if (list[i3] == null) continue;
            qq[count++] = list[i3];
        }
        return qq;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <KK, VV> void cleanupEventQMap(Map<Long, ICacheEventQueue<KK, VV>> eventQMap) {
        Map<Long, ICacheEventQueue<KK, VV>> map = eventQMap;
        synchronized (map) {
            Iterator<Map.Entry<Long, ICacheEventQueue<KK, VV>>> itr = eventQMap.entrySet().iterator();
            while (itr.hasNext()) {
                Map.Entry<Long, ICacheEventQueue<KK, VV>> e2 = itr.next();
                ICacheEventQueue<KK, VV> q2 = e2.getValue();
                if (q2.isWorking()) continue;
                itr.remove();
                log.warn("Cache event queue " + q2 + " is not working and removed from cache server.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <KK, VV> void addCacheListener(String cacheName, ICacheListener<KK, VV> listener) throws IOException {
        CacheListeners<K, V> cacheListeners;
        if (cacheName == null || listener == null) {
            throw new IllegalArgumentException("cacheName and listener must not be null");
        }
        IRemoteCacheListener ircl = (IRemoteCacheListener)listener;
        String listenerAddress = ircl.getLocalHostAddress();
        RemoteType remoteType = ircl.getRemoteType();
        if (remoteType == RemoteType.CLUSTER) {
            log.debug("adding cluster listener, listenerAddress [" + listenerAddress + "]");
            cacheListeners = this.getClusterListeners(cacheName);
        } else {
            log.debug("adding normal listener, listenerAddress [" + listenerAddress + "]");
            cacheListeners = this.getCacheListeners(cacheName);
        }
        ConcurrentMap<Long, ICacheEventQueue<KK, VV>> eventQMap = cacheListeners.eventQMap;
        RemoteCacheServer.cleanupEventQMap(eventQMap);
        Class<ICacheListener> clazz = ICacheListener.class;
        synchronized (ICacheListener.class) {
            long id;
            block15: {
                id = 0L;
                try {
                    id = listener.getListenerId();
                    if (id == 0L) {
                        long listenerIdB = this.nextListenerId();
                        if (log.isDebugEnabled()) {
                            log.debug("listener id=" + (listenerIdB & 0xFFL) + " addded for cache [" + cacheName + "], listenerAddress [" + listenerAddress + "]");
                        }
                        listener.setListenerId(listenerIdB);
                        id = listenerIdB;
                        String message = "Adding vm listener under new id = [" + listenerIdB + "], listenerAddress [" + listenerAddress + "]";
                        this.logApplicationEvent("RemoteCacheServer", "addCacheListener", message);
                        if (log.isInfoEnabled()) {
                            log.info(message);
                        }
                    } else {
                        String message = "Adding listener under existing id = [" + id + "], listenerAddress [" + listenerAddress + "]";
                        this.logApplicationEvent("RemoteCacheServer", "addCacheListener", message);
                        if (log.isInfoEnabled()) {
                            log.info(message);
                        }
                    }
                    this.idTypeMap.put(id, remoteType);
                    if (listenerAddress != null) {
                        this.idIPMap.put(id, listenerAddress);
                    }
                }
                catch (IOException ioe) {
                    String message = "Problem setting listener id, listenerAddress [" + listenerAddress + "]";
                    log.error(message, ioe);
                    if (this.cacheEventLogger == null) break block15;
                    this.cacheEventLogger.logError("RemoteCacheServer", "addCacheListener", message + " - " + ioe.getMessage());
                }
            }
            CacheEventQueueFactory<KK, VV> fact = new CacheEventQueueFactory<KK, VV>();
            ICacheEventQueue q2 = fact.createCacheEventQueue(listener, id, cacheName, this.remoteCacheServerAttributes.getEventQueuePoolName(), this.remoteCacheServerAttributes.getEventQueueType());
            eventQMap.put(listener.getListenerId(), q2);
            if (log.isInfoEnabled()) {
                log.info(cacheListeners);
            }
            // ** MonitorExit[var8_8] (shouldn't be in output)
            return;
        }
    }

    public <KK, VV> void addCacheListener(ICacheListener<KK, VV> listener) throws IOException {
        for (String cacheName : this.cacheListenersMap.keySet()) {
            this.addCacheListener(cacheName, listener);
            if (!log.isDebugEnabled()) continue;
            log.debug("Adding listener for cache [" + cacheName + "]");
        }
    }

    public <KK, VV> void removeCacheListener(String cacheName, ICacheListener<KK, VV> listener) throws IOException {
        this.removeCacheListener(cacheName, listener.getListenerId());
    }

    public void removeCacheListener(String cacheName, long listenerId) {
        String message = "Removing listener for cache region = [" + cacheName + "] and listenerId [" + listenerId + "]";
        this.logApplicationEvent("RemoteCacheServer", "removeCacheListener", message);
        if (log.isInfoEnabled()) {
            log.info(message);
        }
        boolean isClusterListener = this.isRequestFromCluster(listenerId);
        CacheListeners<K, V> cacheDesc = null;
        cacheDesc = isClusterListener ? this.getClusterListeners(cacheName) : this.getCacheListeners(cacheName);
        ConcurrentMap eventQMap = cacheDesc.eventQMap;
        RemoteCacheServer.cleanupEventQMap(eventQMap);
        ICacheEventQueue q2 = (ICacheEventQueue)eventQMap.remove(listenerId);
        if (q2 != null) {
            if (log.isDebugEnabled()) {
                log.debug("Found queue for cache region = [" + cacheName + "] and listenerId  [" + listenerId + "]");
            }
            q2.destroy();
            RemoteCacheServer.cleanupEventQMap(eventQMap);
        } else if (log.isDebugEnabled()) {
            log.debug("Did not find queue for cache region = [" + cacheName + "] and listenerId [" + listenerId + "]");
        }
        this.idTypeMap.remove(listenerId);
        this.idIPMap.remove(listenerId);
        if (log.isInfoEnabled()) {
            log.info("After removing listener [" + listenerId + "] cache region " + cacheName + "'s listener size [" + cacheDesc.eventQMap.size() + "]");
        }
    }

    public <KK, VV> void removeCacheListener(ICacheListener<KK, VV> listener) throws IOException {
        for (String cacheName : this.cacheListenersMap.keySet()) {
            this.removeCacheListener(cacheName, listener);
            if (!log.isInfoEnabled()) continue;
            log.info("Removing listener for cache [" + cacheName + "]");
        }
    }

    @Override
    public void shutdown() throws IOException {
        this.shutdown("", 1099);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown(String host, int port) throws IOException {
        if (log.isInfoEnabled()) {
            log.info("Received shutdown request. Shutting down server.");
        }
        int[] nArray = this.listenerId;
        synchronized (this.listenerId) {
            for (String cacheName : this.cacheListenersMap.keySet()) {
                for (int i2 = 0; i2 <= this.listenerId[0]; ++i2) {
                    this.removeCacheListener(cacheName, i2);
                }
                if (!log.isInfoEnabled()) continue;
                log.info("Removing listener for cache [" + cacheName + "]");
            }
            this.cacheListenersMap.clear();
            this.clusterListenersMap.clear();
            // ** MonitorExit[var3_3] (shouldn't be in output)
            RemoteCacheServerFactory.shutdownImpl(host, port);
            this.cacheManager.shutDown();
            return;
        }
    }

    @Override
    public void unreferenced() {
        if (log.isInfoEnabled()) {
            log.info("*** Server now unreferenced and subject to GC. ***");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long nextListenerId() {
        long id = 0L;
        if (this.listenerId[0] == Integer.MAX_VALUE) {
            int[] nArray = this.listenerId;
            synchronized (this.listenerId) {
                id = this.listenerId[0];
                this.listenerId[0] = 0;
                // ** MonitorExit[var3_2] (shouldn't be in output)
            }
        }
        int[] nArray = this.listenerId;
        synchronized (this.listenerId) {
            this.listenerId[0] = this.listenerId[0] + 1;
            id = this.listenerId[0];
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return id;
        }
    }

    @Override
    public String getStats() throws IOException {
        return this.cacheManager.getStats();
    }

    private ICacheEvent<ICacheElement<K, V>> createICacheEvent(ICacheElement<K, V> item, long requesterId, String eventName) {
        if (this.cacheEventLogger == null) {
            return new CacheEvent<ICacheElement<K, V>>();
        }
        String ipAddress = this.getExtraInfoForRequesterId(requesterId);
        return this.cacheEventLogger.createICacheEvent("RemoteCacheServer", item.getCacheName(), eventName, ipAddress, item);
    }

    private <T> ICacheEvent<T> createICacheEvent(String cacheName, T key, long requesterId, String eventName) {
        if (this.cacheEventLogger == null) {
            return new CacheEvent();
        }
        String ipAddress = this.getExtraInfoForRequesterId(requesterId);
        return this.cacheEventLogger.createICacheEvent("RemoteCacheServer", cacheName, eventName, ipAddress, key);
    }

    protected void logApplicationEvent(String source, String eventName, String optionalDetails) {
        if (this.cacheEventLogger != null) {
            this.cacheEventLogger.logApplicationEvent(source, eventName, optionalDetails);
        }
    }

    protected <T> void logICacheEvent(ICacheEvent<T> cacheEvent) {
        if (this.cacheEventLogger != null) {
            this.cacheEventLogger.logICacheEvent(cacheEvent);
        }
    }

    protected String getExtraInfoForRequesterId(long requesterId) {
        String ipAddress = (String)this.idIPMap.get(requesterId);
        return ipAddress;
    }

    public void setCacheEventLogger(ICacheEventLogger cacheEventLogger) {
        this.cacheEventLogger = cacheEventLogger;
    }
}

