/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.runtime;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.BodyContent;
import javax.servlet.jsp.tagext.BodyTag;
import javax.servlet.jsp.tagext.Tag;
import org.apache.jasper.JasperException;
import org.apache.jasper.compiler.Localizer;
import org.apache.jasper.runtime.ExceptionUtils;
import org.apache.jasper.runtime.PageContextImpl;
import org.apache.jasper.runtime.ProtectedFunctionMapper;
import org.apache.jasper.runtime.ServletResponseWrapperInclude;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.InstanceManager;

public class JspRuntimeLibrary {
    public static Throwable getThrowable(ServletRequest request) {
        Throwable error = (Throwable)request.getAttribute("javax.servlet.error.exception");
        if (error == null && (error = (Throwable)request.getAttribute("javax.servlet.jsp.jspException")) != null) {
            request.setAttribute("javax.servlet.error.exception", error);
        }
        return error;
    }

    public static boolean coerceToBoolean(String s2) {
        if (s2 == null || s2.length() == 0) {
            return false;
        }
        return Boolean.parseBoolean(s2);
    }

    public static byte coerceToByte(String s2) {
        if (s2 == null || s2.length() == 0) {
            return 0;
        }
        return Byte.parseByte(s2);
    }

    public static char coerceToChar(String s2) {
        if (s2 == null || s2.length() == 0) {
            return '\u0000';
        }
        return s2.charAt(0);
    }

    public static double coerceToDouble(String s2) {
        if (s2 == null || s2.length() == 0) {
            return 0.0;
        }
        return Double.parseDouble(s2);
    }

    public static float coerceToFloat(String s2) {
        if (s2 == null || s2.length() == 0) {
            return 0.0f;
        }
        return Float.parseFloat(s2);
    }

    public static int coerceToInt(String s2) {
        if (s2 == null || s2.length() == 0) {
            return 0;
        }
        return Integer.parseInt(s2);
    }

    public static short coerceToShort(String s2) {
        if (s2 == null || s2.length() == 0) {
            return 0;
        }
        return Short.parseShort(s2);
    }

    public static long coerceToLong(String s2) {
        if (s2 == null || s2.length() == 0) {
            return 0L;
        }
        return Long.parseLong(s2);
    }

    public static Object coerce(String s2, Class<?> target) {
        boolean isNullOrEmpty;
        boolean bl = isNullOrEmpty = s2 == null || s2.length() == 0;
        if (target == Boolean.class) {
            if (isNullOrEmpty) {
                s2 = "false";
            }
            return Boolean.valueOf(s2);
        }
        if (target == Byte.class) {
            if (isNullOrEmpty) {
                return (byte)0;
            }
            return Byte.valueOf(s2);
        }
        if (target == Character.class) {
            if (isNullOrEmpty) {
                return Character.valueOf('\u0000');
            }
            Character result = Character.valueOf(s2.charAt(0));
            return result;
        }
        if (target == Double.class) {
            if (isNullOrEmpty) {
                return 0.0;
            }
            return Double.valueOf(s2);
        }
        if (target == Float.class) {
            if (isNullOrEmpty) {
                return Float.valueOf(0.0f);
            }
            return Float.valueOf(s2);
        }
        if (target == Integer.class) {
            if (isNullOrEmpty) {
                return 0;
            }
            return Integer.valueOf(s2);
        }
        if (target == Short.class) {
            if (isNullOrEmpty) {
                return (short)0;
            }
            return Short.valueOf(s2);
        }
        if (target == Long.class) {
            if (isNullOrEmpty) {
                return 0L;
            }
            return Long.valueOf(s2);
        }
        return null;
    }

    public static Object convert(String propertyName, String s2, Class<?> t, Class<?> propertyEditorClass) throws JasperException {
        try {
            if (s2 == null) {
                if (t.equals(Boolean.class) || t.equals(Boolean.TYPE)) {
                    s2 = "false";
                } else {
                    return null;
                }
            }
            if (propertyEditorClass != null) {
                return JspRuntimeLibrary.getValueFromBeanInfoPropertyEditor(t, propertyName, s2, propertyEditorClass);
            }
            if (t.equals(Boolean.class) || t.equals(Boolean.TYPE)) {
                s2 = s2.equalsIgnoreCase("on") || s2.equalsIgnoreCase("true") ? "true" : "false";
                return Boolean.valueOf(s2);
            }
            if (t.equals(Byte.class) || t.equals(Byte.TYPE)) {
                return Byte.valueOf(s2);
            }
            if (t.equals(Character.class) || t.equals(Character.TYPE)) {
                return s2.length() > 0 ? Character.valueOf(s2.charAt(0)) : null;
            }
            if (t.equals(Short.class) || t.equals(Short.TYPE)) {
                return Short.valueOf(s2);
            }
            if (t.equals(Integer.class) || t.equals(Integer.TYPE)) {
                return Integer.valueOf(s2);
            }
            if (t.equals(Float.class) || t.equals(Float.TYPE)) {
                return Float.valueOf(s2);
            }
            if (t.equals(Long.class) || t.equals(Long.TYPE)) {
                return Long.valueOf(s2);
            }
            if (t.equals(Double.class) || t.equals(Double.TYPE)) {
                return Double.valueOf(s2);
            }
            if (t.equals(String.class)) {
                return s2;
            }
            if (t.equals(File.class)) {
                return new File(s2);
            }
            if (t.getName().equals("java.lang.Object")) {
                return new Object[]{s2};
            }
            return JspRuntimeLibrary.getValueFromPropertyEditorManager(t, propertyName, s2);
        }
        catch (Exception ex) {
            throw new JasperException(ex);
        }
    }

    public static void introspect(Object bean, ServletRequest request) throws JasperException {
        Enumeration<String> e2 = request.getParameterNames();
        while (e2.hasMoreElements()) {
            String name = e2.nextElement();
            String value = request.getParameter(name);
            JspRuntimeLibrary.introspecthelper(bean, name, value, request, name, true);
        }
    }

    public static void introspecthelper(Object bean, String prop, String value, ServletRequest request, String param, boolean ignoreMethodNF) throws JasperException {
        Method method = null;
        Class<?> type = null;
        Class<?> propertyEditorClass = null;
        try {
            BeanInfo info = Introspector.getBeanInfo(bean.getClass());
            if (info != null) {
                PropertyDescriptor[] pd;
                for (PropertyDescriptor propertyDescriptor : pd = info.getPropertyDescriptors()) {
                    if (!propertyDescriptor.getName().equals(prop)) continue;
                    method = propertyDescriptor.getWriteMethod();
                    type = propertyDescriptor.getPropertyType();
                    propertyEditorClass = propertyDescriptor.getPropertyEditorClass();
                    break;
                }
            }
            if (method != null && type != null) {
                if (type.isArray()) {
                    if (request == null) {
                        throw new JasperException(Localizer.getMessage("jsp.error.beans.setproperty.noindexset"));
                    }
                    Class<?> t = type.getComponentType();
                    String[] values = request.getParameterValues(param);
                    if (values == null) {
                        return;
                    }
                    if (t.equals(String.class)) {
                        method.invoke(bean, new Object[]{values});
                    } else {
                        JspRuntimeLibrary.createTypedArray(prop, bean, method, values, t, propertyEditorClass);
                    }
                } else {
                    if (value == null || param != null && value.equals("")) {
                        return;
                    }
                    Object oval = JspRuntimeLibrary.convert(prop, value, type, propertyEditorClass);
                    if (oval != null) {
                        method.invoke(bean, oval);
                    }
                }
            }
        }
        catch (Exception ex) {
            Throwable thr = ExceptionUtils.unwrapInvocationTargetException(ex);
            ExceptionUtils.handleThrowable(thr);
            throw new JasperException(ex);
        }
        if (!ignoreMethodNF && method == null) {
            if (type == null) {
                throw new JasperException(Localizer.getMessage("jsp.error.beans.noproperty", prop, bean.getClass().getName()));
            }
            throw new JasperException(Localizer.getMessage("jsp.error.beans.nomethod.setproperty", prop, type.getName(), bean.getClass().getName()));
        }
    }

    public static String toString(Object o2) {
        return String.valueOf(o2);
    }

    public static String toString(byte b2) {
        return Byte.toString(b2);
    }

    public static String toString(boolean b2) {
        return Boolean.toString(b2);
    }

    public static String toString(short s2) {
        return Short.toString(s2);
    }

    public static String toString(int i2) {
        return Integer.toString(i2);
    }

    public static String toString(float f2) {
        return Float.toString(f2);
    }

    public static String toString(long l2) {
        return Long.toString(l2);
    }

    public static String toString(double d2) {
        return Double.toString(d2);
    }

    public static String toString(char c2) {
        return Character.toString(c2);
    }

    public static void createTypedArray(String propertyName, Object bean, Method method, String[] values, Class<?> t, Class<?> propertyEditorClass) throws JasperException {
        try {
            if (propertyEditorClass != null) {
                Integer[] tmpval = new Integer[values.length];
                for (int i2 = 0; i2 < values.length; ++i2) {
                    tmpval[i2] = JspRuntimeLibrary.getValueFromBeanInfoPropertyEditor(t, propertyName, values[i2], propertyEditorClass);
                }
                method.invoke(bean, new Object[]{tmpval});
            } else if (t.equals(Integer.class)) {
                Integer[] tmpval = new Integer[values.length];
                for (int i3 = 0; i3 < values.length; ++i3) {
                    tmpval[i3] = Integer.valueOf(values[i3]);
                }
                method.invoke(bean, new Object[]{tmpval});
            } else if (t.equals(Byte.class)) {
                Byte[] tmpval = new Byte[values.length];
                for (int i4 = 0; i4 < values.length; ++i4) {
                    tmpval[i4] = Byte.valueOf(values[i4]);
                }
                method.invoke(bean, new Object[]{tmpval});
            } else if (t.equals(Boolean.class)) {
                Boolean[] tmpval = new Boolean[values.length];
                for (int i5 = 0; i5 < values.length; ++i5) {
                    tmpval[i5] = Boolean.valueOf(values[i5]);
                }
                method.invoke(bean, new Object[]{tmpval});
            } else if (t.equals(Short.class)) {
                Short[] tmpval = new Short[values.length];
                for (int i6 = 0; i6 < values.length; ++i6) {
                    tmpval[i6] = Short.valueOf(values[i6]);
                }
                method.invoke(bean, new Object[]{tmpval});
            } else if (t.equals(Long.class)) {
                Long[] tmpval = new Long[values.length];
                for (int i7 = 0; i7 < values.length; ++i7) {
                    tmpval[i7] = Long.valueOf(values[i7]);
                }
                method.invoke(bean, new Object[]{tmpval});
            } else if (t.equals(Double.class)) {
                Double[] tmpval = new Double[values.length];
                for (int i8 = 0; i8 < values.length; ++i8) {
                    tmpval[i8] = Double.valueOf(values[i8]);
                }
                method.invoke(bean, new Object[]{tmpval});
            } else if (t.equals(Float.class)) {
                Float[] tmpval = new Float[values.length];
                for (int i9 = 0; i9 < values.length; ++i9) {
                    tmpval[i9] = Float.valueOf(values[i9]);
                }
                method.invoke(bean, new Object[]{tmpval});
            } else if (t.equals(Character.class)) {
                Character[] tmpval = new Character[values.length];
                for (int i10 = 0; i10 < values.length; ++i10) {
                    tmpval[i10] = Character.valueOf(values[i10].charAt(0));
                }
                method.invoke(bean, new Object[]{tmpval});
            } else if (t.equals(Integer.TYPE)) {
                int[] tmpval = new int[values.length];
                for (int i11 = 0; i11 < values.length; ++i11) {
                    tmpval[i11] = Integer.parseInt(values[i11]);
                }
                method.invoke(bean, new Object[]{tmpval});
            } else if (t.equals(Byte.TYPE)) {
                byte[] tmpval = new byte[values.length];
                for (int i12 = 0; i12 < values.length; ++i12) {
                    tmpval[i12] = Byte.parseByte(values[i12]);
                }
                method.invoke(bean, new Object[]{tmpval});
            } else if (t.equals(Boolean.TYPE)) {
                boolean[] tmpval = new boolean[values.length];
                for (int i13 = 0; i13 < values.length; ++i13) {
                    tmpval[i13] = Boolean.parseBoolean(values[i13]);
                }
                method.invoke(bean, new Object[]{tmpval});
            } else if (t.equals(Short.TYPE)) {
                short[] tmpval = new short[values.length];
                for (int i14 = 0; i14 < values.length; ++i14) {
                    tmpval[i14] = Short.parseShort(values[i14]);
                }
                method.invoke(bean, new Object[]{tmpval});
            } else if (t.equals(Long.TYPE)) {
                long[] tmpval = new long[values.length];
                for (int i15 = 0; i15 < values.length; ++i15) {
                    tmpval[i15] = Long.parseLong(values[i15]);
                }
                method.invoke(bean, new Object[]{tmpval});
            } else if (t.equals(Double.TYPE)) {
                double[] tmpval = new double[values.length];
                for (int i16 = 0; i16 < values.length; ++i16) {
                    tmpval[i16] = Double.parseDouble(values[i16]);
                }
                method.invoke(bean, new Object[]{tmpval});
            } else if (t.equals(Float.TYPE)) {
                float[] tmpval = new float[values.length];
                for (int i17 = 0; i17 < values.length; ++i17) {
                    tmpval[i17] = Float.parseFloat(values[i17]);
                }
                method.invoke(bean, new Object[]{tmpval});
            } else if (t.equals(Character.TYPE)) {
                char[] tmpval = new char[values.length];
                for (int i18 = 0; i18 < values.length; ++i18) {
                    tmpval[i18] = values[i18].charAt(0);
                }
                method.invoke(bean, new Object[]{tmpval});
            } else {
                Integer[] tmpval = new Integer[values.length];
                for (int i19 = 0; i19 < values.length; ++i19) {
                    tmpval[i19] = JspRuntimeLibrary.getValueFromPropertyEditorManager(t, propertyName, values[i19]);
                }
                method.invoke(bean, new Object[]{tmpval});
            }
        }
        catch (ReflectiveOperationException | RuntimeException ex) {
            Throwable thr = ExceptionUtils.unwrapInvocationTargetException(ex);
            ExceptionUtils.handleThrowable(thr);
            throw new JasperException("error in invoking method", ex);
        }
    }

    public static String escapeQueryString(String unescString) {
        if (unescString == null) {
            return null;
        }
        StringBuilder escStringBuilder = new StringBuilder();
        String shellSpChars = "&;`'\"|*?~<>^()[]{}$\\\n";
        for (int index = 0; index < unescString.length(); ++index) {
            char nextChar = unescString.charAt(index);
            if (shellSpChars.indexOf(nextChar) != -1) {
                escStringBuilder.append('\\');
            }
            escStringBuilder.append(nextChar);
        }
        return escStringBuilder.toString();
    }

    public static Object handleGetProperty(Object o2, String prop) throws JasperException {
        if (o2 == null) {
            throw new JasperException(Localizer.getMessage("jsp.error.beans.nullbean"));
        }
        Object value = null;
        try {
            Method method = JspRuntimeLibrary.getReadMethod(o2.getClass(), prop);
            value = method.invoke(o2, (Object[])null);
        }
        catch (Exception ex) {
            Throwable thr = ExceptionUtils.unwrapInvocationTargetException(ex);
            ExceptionUtils.handleThrowable(thr);
            throw new JasperException(ex);
        }
        return value;
    }

    public static void handleSetPropertyExpression(Object bean, String prop, String expression, PageContext pageContext, ProtectedFunctionMapper functionMapper) throws JasperException {
        try {
            Method method = JspRuntimeLibrary.getWriteMethod(bean.getClass(), prop);
            method.invoke(bean, PageContextImpl.proprietaryEvaluate(expression, method.getParameterTypes()[0], pageContext, functionMapper));
        }
        catch (Exception ex) {
            Throwable thr = ExceptionUtils.unwrapInvocationTargetException(ex);
            ExceptionUtils.handleThrowable(thr);
            throw new JasperException(ex);
        }
    }

    public static void handleSetProperty(Object bean, String prop, Object value) throws JasperException {
        try {
            Method method = JspRuntimeLibrary.getWriteMethod(bean.getClass(), prop);
            method.invoke(bean, value);
        }
        catch (Exception ex) {
            Throwable thr = ExceptionUtils.unwrapInvocationTargetException(ex);
            ExceptionUtils.handleThrowable(thr);
            throw new JasperException(ex);
        }
    }

    public static void handleSetProperty(Object bean, String prop, int value) throws JasperException {
        try {
            Method method = JspRuntimeLibrary.getWriteMethod(bean.getClass(), prop);
            method.invoke(bean, value);
        }
        catch (Exception ex) {
            Throwable thr = ExceptionUtils.unwrapInvocationTargetException(ex);
            ExceptionUtils.handleThrowable(thr);
            throw new JasperException(ex);
        }
    }

    public static void handleSetProperty(Object bean, String prop, short value) throws JasperException {
        try {
            Method method = JspRuntimeLibrary.getWriteMethod(bean.getClass(), prop);
            method.invoke(bean, value);
        }
        catch (Exception ex) {
            Throwable thr = ExceptionUtils.unwrapInvocationTargetException(ex);
            ExceptionUtils.handleThrowable(thr);
            throw new JasperException(ex);
        }
    }

    public static void handleSetProperty(Object bean, String prop, long value) throws JasperException {
        try {
            Method method = JspRuntimeLibrary.getWriteMethod(bean.getClass(), prop);
            method.invoke(bean, value);
        }
        catch (Exception ex) {
            Throwable thr = ExceptionUtils.unwrapInvocationTargetException(ex);
            ExceptionUtils.handleThrowable(thr);
            throw new JasperException(ex);
        }
    }

    public static void handleSetProperty(Object bean, String prop, double value) throws JasperException {
        try {
            Method method = JspRuntimeLibrary.getWriteMethod(bean.getClass(), prop);
            method.invoke(bean, value);
        }
        catch (Exception ex) {
            Throwable thr = ExceptionUtils.unwrapInvocationTargetException(ex);
            ExceptionUtils.handleThrowable(thr);
            throw new JasperException(ex);
        }
    }

    public static void handleSetProperty(Object bean, String prop, float value) throws JasperException {
        try {
            Method method = JspRuntimeLibrary.getWriteMethod(bean.getClass(), prop);
            method.invoke(bean, Float.valueOf(value));
        }
        catch (Exception ex) {
            Throwable thr = ExceptionUtils.unwrapInvocationTargetException(ex);
            ExceptionUtils.handleThrowable(thr);
            throw new JasperException(ex);
        }
    }

    public static void handleSetProperty(Object bean, String prop, char value) throws JasperException {
        try {
            Method method = JspRuntimeLibrary.getWriteMethod(bean.getClass(), prop);
            method.invoke(bean, Character.valueOf(value));
        }
        catch (Exception ex) {
            Throwable thr = ExceptionUtils.unwrapInvocationTargetException(ex);
            ExceptionUtils.handleThrowable(thr);
            throw new JasperException(ex);
        }
    }

    public static void handleSetProperty(Object bean, String prop, byte value) throws JasperException {
        try {
            Method method = JspRuntimeLibrary.getWriteMethod(bean.getClass(), prop);
            method.invoke(bean, value);
        }
        catch (Exception ex) {
            Throwable thr = ExceptionUtils.unwrapInvocationTargetException(ex);
            ExceptionUtils.handleThrowable(thr);
            throw new JasperException(ex);
        }
    }

    public static void handleSetProperty(Object bean, String prop, boolean value) throws JasperException {
        try {
            Method method = JspRuntimeLibrary.getWriteMethod(bean.getClass(), prop);
            method.invoke(bean, value);
        }
        catch (Exception ex) {
            Throwable thr = ExceptionUtils.unwrapInvocationTargetException(ex);
            ExceptionUtils.handleThrowable(thr);
            throw new JasperException(ex);
        }
    }

    public static Method getWriteMethod(Class<?> beanClass, String prop) throws JasperException {
        Method method = null;
        Class<?> type = null;
        try {
            PropertyDescriptor[] pd;
            BeanInfo info = Introspector.getBeanInfo(beanClass);
            for (PropertyDescriptor propertyDescriptor : pd = info.getPropertyDescriptors()) {
                if (!propertyDescriptor.getName().equals(prop)) continue;
                method = propertyDescriptor.getWriteMethod();
                type = propertyDescriptor.getPropertyType();
                break;
            }
        }
        catch (Exception ex) {
            throw new JasperException(ex);
        }
        if (method == null) {
            if (type == null) {
                throw new JasperException(Localizer.getMessage("jsp.error.beans.noproperty", prop, beanClass.getName()));
            }
            throw new JasperException(Localizer.getMessage("jsp.error.beans.nomethod.setproperty", prop, type.getName(), beanClass.getName()));
        }
        return method;
    }

    public static Method getReadMethod(Class<?> beanClass, String prop) throws JasperException {
        Method method = null;
        Class<?> type = null;
        try {
            PropertyDescriptor[] pd;
            BeanInfo info = Introspector.getBeanInfo(beanClass);
            for (PropertyDescriptor propertyDescriptor : pd = info.getPropertyDescriptors()) {
                if (!propertyDescriptor.getName().equals(prop)) continue;
                method = propertyDescriptor.getReadMethod();
                type = propertyDescriptor.getPropertyType();
                break;
            }
        }
        catch (Exception ex) {
            throw new JasperException(ex);
        }
        if (method == null) {
            if (type == null) {
                throw new JasperException(Localizer.getMessage("jsp.error.beans.noproperty", prop, beanClass.getName()));
            }
            throw new JasperException(Localizer.getMessage("jsp.error.beans.nomethod", prop, beanClass.getName()));
        }
        return method;
    }

    public static Object getValueFromBeanInfoPropertyEditor(Class<?> attrClass, String attrName, String attrValue, Class<?> propertyEditorClass) throws JasperException {
        try {
            PropertyEditor pe = (PropertyEditor)propertyEditorClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            pe.setAsText(attrValue);
            return pe.getValue();
        }
        catch (Exception ex) {
            throw new JasperException(Localizer.getMessage("jsp.error.beans.property.conversion", attrValue, attrClass.getName(), attrName, ex.getMessage()));
        }
    }

    public static Object getValueFromPropertyEditorManager(Class<?> attrClass, String attrName, String attrValue) throws JasperException {
        try {
            PropertyEditor propEditor = PropertyEditorManager.findEditor(attrClass);
            if (propEditor != null) {
                propEditor.setAsText(attrValue);
                return propEditor.getValue();
            }
            throw new IllegalArgumentException(Localizer.getMessage("jsp.error.beans.propertyeditor.notregistered"));
        }
        catch (IllegalArgumentException ex) {
            throw new JasperException(Localizer.getMessage("jsp.error.beans.property.conversion", attrValue, attrClass.getName(), attrName, ex.getMessage()));
        }
    }

    public static String getContextRelativePath(ServletRequest request, String relativePath) {
        if (relativePath.startsWith("/")) {
            return relativePath;
        }
        if (!(request instanceof HttpServletRequest)) {
            return relativePath;
        }
        HttpServletRequest hrequest = (HttpServletRequest)request;
        String uri = (String)request.getAttribute("javax.servlet.include.servlet_path");
        if (uri != null) {
            String pathInfo = (String)request.getAttribute("javax.servlet.include.path_info");
            if (pathInfo == null && uri.lastIndexOf(47) >= 0) {
                uri = uri.substring(0, uri.lastIndexOf(47));
            }
        } else {
            uri = hrequest.getServletPath();
            if (uri.lastIndexOf(47) >= 0) {
                uri = uri.substring(0, uri.lastIndexOf(47));
            }
        }
        return uri + '/' + relativePath;
    }

    public static void include(ServletRequest request, ServletResponse response, String relativePath, JspWriter out, boolean flush) throws IOException, ServletException {
        if (flush && !(out instanceof BodyContent)) {
            out.flush();
        }
        String resourcePath = JspRuntimeLibrary.getContextRelativePath(request, relativePath);
        RequestDispatcher rd = request.getRequestDispatcher(resourcePath);
        rd.include(request, new ServletResponseWrapperInclude(response, out));
    }

    public static String URLEncode(String s2, String enc) {
        if (s2 == null) {
            return "null";
        }
        if (enc == null) {
            enc = "ISO-8859-1";
        }
        StringBuilder out = new StringBuilder(s2.length());
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        OutputStreamWriter writer = null;
        try {
            writer = new OutputStreamWriter((OutputStream)buf, enc);
        }
        catch (UnsupportedEncodingException ex) {
            writer = new OutputStreamWriter(buf);
        }
        for (int i2 = 0; i2 < s2.length(); ++i2) {
            byte[] ba;
            char c2 = s2.charAt(i2);
            if (c2 == ' ') {
                out.append('+');
                continue;
            }
            if (JspRuntimeLibrary.isSafeChar(c2)) {
                out.append(c2);
                continue;
            }
            try {
                writer.write(c2);
                writer.flush();
            }
            catch (IOException e2) {
                buf.reset();
                continue;
            }
            for (byte b2 : ba = buf.toByteArray()) {
                out.append('%');
                out.append(Character.forDigit(b2 >> 4 & 0xF, 16));
                out.append(Character.forDigit(b2 & 0xF, 16));
            }
            buf.reset();
        }
        return out.toString();
    }

    private static boolean isSafeChar(int c2) {
        if (c2 >= 97 && c2 <= 122) {
            return true;
        }
        if (c2 >= 65 && c2 <= 90) {
            return true;
        }
        if (c2 >= 48 && c2 <= 57) {
            return true;
        }
        return c2 == 45 || c2 == 95 || c2 == 46 || c2 == 33 || c2 == 126 || c2 == 42 || c2 == 39 || c2 == 40 || c2 == 41;
    }

    public static JspWriter startBufferedBody(PageContext pageContext, BodyTag tag) throws JspException {
        BodyContent out = pageContext.pushBody();
        tag.setBodyContent(out);
        tag.doInitBody();
        return out;
    }

    public static void releaseTag(Tag tag, InstanceManager instanceManager, boolean reused) {
        if (!reused) {
            JspRuntimeLibrary.releaseTag(tag, instanceManager);
        }
    }

    protected static void releaseTag(Tag tag, InstanceManager instanceManager) {
        try {
            tag.release();
        }
        catch (Throwable t) {
            ExceptionUtils.handleThrowable(t);
            Log log = LogFactory.getLog(JspRuntimeLibrary.class);
            log.warn((Object)Localizer.getMessage("jsp.warning.tagRelease", tag.getClass().getName()), t);
        }
        try {
            instanceManager.destroyInstance(tag);
        }
        catch (Exception e2) {
            Throwable t = ExceptionUtils.unwrapInvocationTargetException(e2);
            ExceptionUtils.handleThrowable(t);
            Log log = LogFactory.getLog(JspRuntimeLibrary.class);
            log.warn((Object)Localizer.getMessage("jsp.warning.tagPreDestroy", tag.getClass().getName()), t);
        }
    }
}

