/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.security;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

public class ConcurrentMessageDigest {
    private static final String MD5 = "MD5";
    private static final String SHA1 = "SHA-1";
    private static final Map<String, Queue<MessageDigest>> queues = new HashMap<String, Queue<MessageDigest>>();

    private ConcurrentMessageDigest() {
    }

    public static byte[] digestMD5(byte[] ... input) {
        return ConcurrentMessageDigest.digest(MD5, input);
    }

    public static byte[] digestSHA1(byte[] ... input) {
        return ConcurrentMessageDigest.digest(SHA1, input);
    }

    public static byte[] digest(String algorithm, byte[] ... input) {
        return ConcurrentMessageDigest.digest(algorithm, 1, input);
    }

    public static byte[] digest(String algorithm, int rounds, byte[] ... input) {
        Queue<MessageDigest> queue = queues.get(algorithm);
        if (queue == null) {
            throw new IllegalStateException("Must call init() first");
        }
        MessageDigest md = queue.poll();
        if (md == null) {
            try {
                md = MessageDigest.getInstance(algorithm);
            }
            catch (NoSuchAlgorithmException e2) {
                throw new IllegalStateException("Must call init() first");
            }
        }
        for (byte[] bytes : input) {
            md.update(bytes);
        }
        byte[] result = md.digest();
        if (rounds > 1) {
            for (int i2 = 1; i2 < rounds; ++i2) {
                md.update(result);
                result = md.digest();
            }
        }
        queue.add(md);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(String algorithm) throws NoSuchAlgorithmException {
        Map<String, Queue<MessageDigest>> map = queues;
        synchronized (map) {
            if (!queues.containsKey(algorithm)) {
                MessageDigest md = MessageDigest.getInstance(algorithm);
                ConcurrentLinkedQueue<MessageDigest> queue = new ConcurrentLinkedQueue<MessageDigest>();
                queue.add(md);
                queues.put(algorithm, queue);
            }
        }
    }

    static {
        try {
            ConcurrentMessageDigest.init(MD5);
            ConcurrentMessageDigest.init(SHA1);
        }
        catch (NoSuchAlgorithmException e2) {
            throw new IllegalArgumentException(e2);
        }
    }
}

