/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlbeans.impl.jam.internal.elements;

import java.util.HashMap;
import java.util.Map;
import org.apache.xmlbeans.impl.jam.JClass;
import org.apache.xmlbeans.impl.jam.internal.elements.BuiltinClassImpl;
import org.apache.xmlbeans.impl.jam.internal.elements.ElementContext;

public final class PrimitiveClassImpl
extends BuiltinClassImpl {
    private static final Object[][] PRIMITIVES = new Object[][]{{"int", "I", Integer.TYPE}, {"long", "J", Long.TYPE}, {"boolean", "Z", Boolean.TYPE}, {"short", "S", Short.TYPE}, {"byte", "B", Byte.TYPE}, {"char", "C", Character.TYPE}, {"float", "F", Float.TYPE}, {"double", "D", Double.TYPE}};
    private static final Map NAME_TO_FD = new HashMap();
    private static final Map NAME_TO_CLASS = new HashMap();

    public static void mapNameToPrimitive(ElementContext ctx, Map out) {
        for (int i2 = 0; i2 < PRIMITIVES.length; ++i2) {
            PrimitiveClassImpl c2 = new PrimitiveClassImpl(ctx, (String)PRIMITIVES[i2][0]);
            out.put(PRIMITIVES[i2][0], c2);
            out.put(PRIMITIVES[i2][1], c2);
        }
    }

    public static String getPrimitiveClassForName(String named) {
        return (String)NAME_TO_FD.get(named);
    }

    public static boolean isPrimitive(String name) {
        return NAME_TO_FD.get(name) != null;
    }

    public static final String getFieldDescriptor(String classname) {
        return (String)NAME_TO_FD.get(classname);
    }

    public static final Class getPrimitiveClass(String classname) {
        return (Class)NAME_TO_CLASS.get(classname);
    }

    private PrimitiveClassImpl(ElementContext ctx, String name) {
        super(ctx);
        if (name == null) {
            throw new IllegalArgumentException("null name");
        }
        if (!NAME_TO_FD.containsKey(name)) {
            throw new IllegalArgumentException("Unknown primitive class '" + name + "'");
        }
        this.reallySetSimpleName(name);
    }

    @Override
    public String getQualifiedName() {
        return this.getSimpleName();
    }

    @Override
    public String getFieldDescriptor() {
        return (String)NAME_TO_FD.get(this.getSimpleName());
    }

    @Override
    public boolean isAssignableFrom(JClass c2) {
        return c2.isPrimitiveType() && c2.getSimpleName().equals(this.getSimpleName());
    }

    @Override
    public boolean isPrimitiveType() {
        return true;
    }

    @Override
    public Class getPrimitiveClass() {
        return (Class)NAME_TO_CLASS.get(this.getSimpleName());
    }

    static {
        for (int i2 = 0; i2 < PRIMITIVES.length; ++i2) {
            NAME_TO_FD.put(PRIMITIVES[i2][0], PRIMITIVES[i2][1]);
            NAME_TO_CLASS.put(PRIMITIVES[i2][0], PRIMITIVES[i2][2]);
        }
    }
}

