/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlbeans.impl.repackage;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Repackager {
    private List _fromPackages = new ArrayList();
    private List _toPackages = new ArrayList();
    private Matcher[] _fromMatchers;
    private String[] _toPackageNames;

    public Repackager(String repackageSpecs) {
        boolean swapped;
        ArrayList repackages = Repackager.splitPath(repackageSpecs, ';');
        do {
            swapped = false;
            for (int i2 = 1; i2 < repackages.size(); ++i2) {
                String spec1 = (String)repackages.get(i2 - 1);
                String spec2 = (String)repackages.get(i2);
                if (spec1.indexOf(58) >= spec2.indexOf(58)) continue;
                repackages.set(i2 - 1, spec2);
                repackages.set(i2, spec1);
                swapped = true;
            }
        } while (swapped);
        for (int i3 = 0; i3 < repackages.size(); ++i3) {
            String spec = (String)repackages.get(i3);
            int j2 = spec.indexOf(58);
            if (j2 < 0 || spec.indexOf(58, j2 + 1) >= 0) {
                throw new RuntimeException("Illegal repackage specification: " + spec);
            }
            String from = spec.substring(0, j2);
            String to = spec.substring(j2 + 1);
            this._fromPackages.add(Repackager.splitPath(from, '.'));
            this._toPackages.add(Repackager.splitPath(to, '.'));
        }
        this._fromMatchers = new Matcher[this._fromPackages.size() * 2];
        this._toPackageNames = new String[this._fromPackages.size() * 2];
        this.addPatterns('.', 0);
        this.addPatterns('/', this._fromPackages.size());
    }

    void addPatterns(char sep, int off) {
        for (int i2 = 0; i2 < this._fromPackages.size(); ++i2) {
            List from = (List)this._fromPackages.get(i2);
            List to = (List)this._toPackages.get(i2);
            String pattern = "";
            for (int j2 = 0; j2 < from.size(); ++j2) {
                if (j2 > 0) {
                    pattern = pattern + "\\" + sep;
                }
                pattern = pattern + from.get(j2);
            }
            String toPackage = "";
            for (int j3 = 0; j3 < to.size(); ++j3) {
                if (j3 > 0) {
                    toPackage = toPackage + sep;
                }
                toPackage = toPackage + to.get(j3);
            }
            this._fromMatchers[off + i2] = Pattern.compile(pattern).matcher("");
            this._toPackageNames[off + i2] = toPackage;
        }
    }

    public StringBuffer repackage(StringBuffer sb) {
        StringBuffer result = null;
        for (int i2 = 0; i2 < this._fromMatchers.length; ++i2) {
            Matcher m2 = this._fromMatchers[i2];
            m2.reset(sb);
            boolean found = m2.find();
            while (found) {
                if (result == null) {
                    result = new StringBuffer();
                }
                m2.appendReplacement(result, this._toPackageNames[i2]);
                found = m2.find();
            }
            if (result == null) continue;
            m2.appendTail(result);
            sb = result;
            result = null;
        }
        return sb;
    }

    public List getFromPackages() {
        return this._fromPackages;
    }

    public List getToPackages() {
        return this._toPackages;
    }

    public static ArrayList splitPath(String path, char separator) {
        int i2;
        ArrayList<String> components = new ArrayList<String>();
        while ((i2 = path.indexOf(separator)) >= 0) {
            components.add(path.substring(0, i2));
            path = path.substring(i2 + 1);
        }
        if (path.length() > 0) {
            components.add(path);
        }
        return components;
    }

    public static String dirForPath(String path) {
        return new File(path).getParent();
    }
}

