/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.apache.bcel.classfile;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.aspectj.apache.bcel.classfile.Attribute;
import org.aspectj.apache.bcel.classfile.ClassVisitor;
import org.aspectj.apache.bcel.classfile.ConstantPool;
import org.aspectj.apache.bcel.classfile.LocalVariable;

public class LocalVariableTable
extends Attribute {
    private boolean isInPackedState = false;
    private byte[] data;
    private int localVariableTableLength;
    private LocalVariable[] localVariableTable;

    public LocalVariableTable(LocalVariableTable c2) {
        this(c2.getNameIndex(), c2.getLength(), c2.getLocalVariableTable(), c2.getConstantPool());
    }

    public LocalVariableTable(int name_index, int length, LocalVariable[] local_variable_table, ConstantPool constant_pool) {
        super((byte)5, name_index, length, constant_pool);
        this.setLocalVariableTable(local_variable_table);
    }

    LocalVariableTable(int name_index, int length, DataInputStream file, ConstantPool constant_pool) throws IOException {
        super((byte)5, name_index, length, constant_pool);
        this.data = new byte[length];
        file.read(this.data);
        this.isInPackedState = true;
    }

    public void accept(ClassVisitor v) {
        this.unpack();
        v.visitLocalVariableTable(this);
    }

    public final void dump(DataOutputStream file) throws IOException {
        super.dump(file);
        if (this.isInPackedState) {
            file.write(this.data);
        } else {
            file.writeShort(this.localVariableTableLength);
            int i2 = 0;
            while (i2 < this.localVariableTableLength) {
                this.localVariableTable[i2].dump(file);
                ++i2;
            }
        }
    }

    public final LocalVariable[] getLocalVariableTable() {
        this.unpack();
        return this.localVariableTable;
    }

    public final LocalVariable getLocalVariable(int index) {
        this.unpack();
        int i2 = 0;
        while (i2 < this.localVariableTableLength) {
            if (this.localVariableTable[i2] != null && this.localVariableTable[i2].getIndex() == index) {
                return this.localVariableTable[i2];
            }
            ++i2;
        }
        return null;
    }

    public final void setLocalVariableTable(LocalVariable[] local_variable_table) {
        this.data = null;
        this.isInPackedState = false;
        this.localVariableTable = local_variable_table;
        this.localVariableTableLength = local_variable_table == null ? 0 : local_variable_table.length;
    }

    public final String toString() {
        StringBuffer buf = new StringBuffer("");
        this.unpack();
        int i2 = 0;
        while (i2 < this.localVariableTableLength) {
            buf.append(this.localVariableTable[i2].toString());
            if (i2 < this.localVariableTableLength - 1) {
                buf.append('\n');
            }
            ++i2;
        }
        return buf.toString();
    }

    public final int getTableLength() {
        this.unpack();
        return this.localVariableTableLength;
    }

    private void unpack() {
        if (!this.isInPackedState) {
            return;
        }
        try {
            ByteArrayInputStream bs = new ByteArrayInputStream(this.data);
            DataInputStream dis = new DataInputStream(bs);
            this.localVariableTableLength = dis.readUnsignedShort();
            this.localVariableTable = new LocalVariable[this.localVariableTableLength];
            int i2 = 0;
            while (i2 < this.localVariableTableLength) {
                this.localVariableTable[i2] = new LocalVariable(dis, this.cpool);
                ++i2;
            }
            dis.close();
            this.data = null;
        }
        catch (IOException e2) {
            throw new RuntimeException("Unpacking of LocalVariableTable attribute failed");
        }
        this.isInPackedState = false;
    }
}

