/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.apache.bcel.classfile.annotation;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.aspectj.apache.bcel.classfile.Attribute;
import org.aspectj.apache.bcel.classfile.ConstantPool;
import org.aspectj.apache.bcel.classfile.annotation.AnnotationGen;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RuntimeParamAnnos
extends Attribute {
    private List<AnnotationGen[]> parameterAnnotations;
    private boolean visible;
    private boolean inflated = false;
    private byte[] annotation_data;

    public RuntimeParamAnnos(byte attrid, boolean visible, int nameIdx, int len, ConstantPool cpool) {
        super(attrid, nameIdx, len, cpool);
        this.visible = visible;
        this.parameterAnnotations = new ArrayList<AnnotationGen[]>();
    }

    public RuntimeParamAnnos(byte attrid, boolean visible, int nameIdx, int len, byte[] data, ConstantPool cpool) {
        super(attrid, nameIdx, len, cpool);
        this.visible = visible;
        this.parameterAnnotations = new ArrayList<AnnotationGen[]>();
        this.annotation_data = data;
    }

    @Override
    public final void dump(DataOutputStream dos) throws IOException {
        super.dump(dos);
        this.writeAnnotations(dos);
    }

    public Attribute copy(ConstantPool constant_pool) {
        throw new RuntimeException("Not implemented yet!");
    }

    public List<AnnotationGen[]> getParameterAnnotations() {
        if (!this.inflated) {
            this.inflate();
        }
        return this.parameterAnnotations;
    }

    public AnnotationGen[] getAnnotationsOnParameter(int parameterIndex) {
        if (!this.inflated) {
            this.inflate();
        }
        if (parameterIndex >= this.parameterAnnotations.size()) {
            return AnnotationGen.NO_ANNOTATIONS;
        }
        return this.parameterAnnotations.get(parameterIndex);
    }

    public boolean areVisible() {
        return this.visible;
    }

    protected void readParameterAnnotations(DataInputStream dis, ConstantPool cpool) throws IOException {
        this.annotation_data = new byte[this.length];
        dis.read(this.annotation_data, 0, this.length);
    }

    private void inflate() {
        try {
            DataInputStream dis = new DataInputStream(new ByteArrayInputStream(this.annotation_data));
            int numParameters = dis.readUnsignedByte();
            int i2 = 0;
            while (i2 < numParameters) {
                int numAnnotations = dis.readUnsignedShort();
                AnnotationGen[] annotations = new AnnotationGen[numAnnotations];
                int j2 = 0;
                while (j2 < numAnnotations) {
                    annotations[j2] = AnnotationGen.read(dis, this.getConstantPool(), this.visible);
                    ++j2;
                }
                this.parameterAnnotations.add(annotations);
                ++i2;
            }
            this.inflated = true;
        }
        catch (IOException ioe) {
            throw new RuntimeException("Unabled to inflate annotation data, badly formed?");
        }
    }

    protected void writeAnnotations(DataOutputStream dos) throws IOException {
        if (!this.inflated) {
            dos.write(this.annotation_data, 0, this.length);
        } else {
            dos.writeByte(this.parameterAnnotations.size());
            int i2 = 0;
            while (i2 < this.parameterAnnotations.size()) {
                AnnotationGen[] annotations = this.parameterAnnotations.get(i2);
                dos.writeShort(annotations.length);
                int j2 = 0;
                while (j2 < annotations.length) {
                    annotations[j2].dump(dos);
                    ++j2;
                }
                ++i2;
            }
        }
    }

    public boolean isInflated() {
        return this.inflated;
    }

    @Override
    public String toString() {
        return "Runtime" + (this.visible ? "Visible" : "Invisible") + "ParameterAnnotations [" + (this.inflated ? "inflated" : "not yet inflated") + "]";
    }
}

