/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.runtime.reflect;

import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import org.aspectj.lang.reflect.MethodSignature;
import org.aspectj.runtime.reflect.CodeSignatureImpl;
import org.aspectj.runtime.reflect.StringMaker;

class MethodSignatureImpl
extends CodeSignatureImpl
implements MethodSignature {
    private Method method;
    Class returnType;

    MethodSignatureImpl(int modifiers, String name, Class declaringType, Class[] parameterTypes, String[] parameterNames, Class[] exceptionTypes, Class returnType2) {
        super(modifiers, name, declaringType, parameterTypes, parameterNames, exceptionTypes);
        this.returnType = returnType2;
    }

    MethodSignatureImpl(String stringRep) {
        super(stringRep);
    }

    public Class getReturnType() {
        if (this.returnType == null) {
            this.returnType = this.extractType(6);
        }
        return this.returnType;
    }

    protected String createToString(StringMaker sm) {
        StringBuffer buf = new StringBuffer();
        buf.append(sm.makeModifiersString(this.getModifiers()));
        if (sm.includeArgs) {
            buf.append(sm.makeTypeName(this.getReturnType()));
        }
        if (sm.includeArgs) {
            buf.append(" ");
        }
        buf.append(sm.makePrimaryTypeName(this.getDeclaringType(), this.getDeclaringTypeName()));
        buf.append(".");
        buf.append(this.getName());
        sm.addSignature(buf, this.getParameterTypes());
        sm.addThrows(buf, this.getExceptionTypes());
        return buf.toString();
    }

    public Method getMethod() {
        if (this.method == null) {
            Class dtype = this.getDeclaringType();
            try {
                this.method = dtype.getDeclaredMethod(this.getName(), this.getParameterTypes());
            }
            catch (NoSuchMethodException nsmEx) {
                HashSet<Class> searched = new HashSet<Class>();
                searched.add(dtype);
                this.method = this.search(dtype, this.getName(), this.getParameterTypes(), searched);
            }
        }
        return this.method;
    }

    private Method search(Class type, String name, Class[] params, Set searched) {
        Method m2;
        if (type == null) {
            return null;
        }
        if (!searched.contains(type)) {
            searched.add(type);
            try {
                return type.getDeclaredMethod(name, params);
            }
            catch (NoSuchMethodException nsme) {
                // empty catch block
            }
        }
        if ((m2 = this.search(type.getSuperclass(), name, params, searched)) != null) {
            return m2;
        }
        Class<?>[] superinterfaces = type.getInterfaces();
        if (superinterfaces != null) {
            for (int i2 = 0; i2 < superinterfaces.length; ++i2) {
                m2 = this.search(superinterfaces[i2], name, params, searched);
                if (m2 == null) continue;
                return m2;
            }
        }
        return null;
    }
}

