/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.aspectj.bridge.ISourceLocation;
import org.aspectj.weaver.AbstractReferenceTypeDelegate;
import org.aspectj.weaver.AnnotationAJ;
import org.aspectj.weaver.AnnotationTargetKind;
import org.aspectj.weaver.BCException;
import org.aspectj.weaver.BoundedReferenceType;
import org.aspectj.weaver.ConcreteTypeMunger;
import org.aspectj.weaver.ISourceContext;
import org.aspectj.weaver.Position;
import org.aspectj.weaver.ReferenceTypeDelegate;
import org.aspectj.weaver.ResolvedMember;
import org.aspectj.weaver.ResolvedType;
import org.aspectj.weaver.SourceContextImpl;
import org.aspectj.weaver.TypeVariable;
import org.aspectj.weaver.TypeVariableReference;
import org.aspectj.weaver.TypeVariableReferenceType;
import org.aspectj.weaver.UnresolvedType;
import org.aspectj.weaver.WeaverStateInfo;
import org.aspectj.weaver.World;
import org.aspectj.weaver.patterns.Declare;
import org.aspectj.weaver.patterns.PerClause;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReferenceType
extends ResolvedType {
    private final List derivativeTypes = new ArrayList();
    ReferenceType genericType = null;
    ReferenceTypeDelegate delegate = null;
    int startPos = 0;
    int endPos = 0;
    ResolvedMember[] parameterizedMethods = null;
    ResolvedMember[] parameterizedFields = null;
    ResolvedMember[] parameterizedPointcuts = null;
    WeakReference<ResolvedType[]> parameterizedInterfaces = new WeakReference<Object>(null);
    Collection<Declare> parameterizedDeclares = null;
    Collection parameterizedTypeMungers = null;
    private ResolvedType[] annotationTypes = null;
    private AnnotationAJ[] annotations = null;
    private ResolvedType newSuperclass;
    private ResolvedType[] newInterfaces;
    WeakReference<ResolvedType> superclassReference = new WeakReference<Object>(null);

    public ReferenceType(String signature, World world) {
        super(signature, world);
    }

    public ReferenceType(String signature, String signatureErasure, World world) {
        super(signature, signatureErasure, world);
    }

    public static ReferenceType fromTypeX(UnresolvedType tx, World world) {
        ReferenceType rt = new ReferenceType(tx.getErasureSignature(), world);
        rt.typeKind = tx.typeKind;
        return rt;
    }

    public ReferenceType(ResolvedType theGenericType, ResolvedType[] theParameters, World aWorld) {
        super(ReferenceType.makeParameterizedSignature(theGenericType, theParameters), theGenericType.signatureErasure, aWorld);
        ReferenceType genericReferenceType = (ReferenceType)theGenericType;
        this.typeParameters = theParameters;
        this.genericType = genericReferenceType;
        this.typeKind = UnresolvedType.TypeKind.PARAMETERIZED;
        this.delegate = genericReferenceType.getDelegate();
        genericReferenceType.addDependentType(this);
    }

    private void addDependentType(ReferenceType dependent) {
        this.derivativeTypes.add(dependent);
    }

    @Override
    public String getSignatureForAttribute() {
        if (this.genericType == null || this.typeParameters == null) {
            return this.getSignature();
        }
        return ReferenceType.makeDeclaredSignature(this.genericType, this.typeParameters);
    }

    public ReferenceType(UnresolvedType genericType, World world) {
        super(genericType.getSignature(), world);
        this.typeKind = UnresolvedType.TypeKind.GENERIC;
    }

    @Override
    public boolean isClass() {
        return this.delegate.isClass();
    }

    @Override
    public boolean isGenericType() {
        return !this.isParameterizedType() && !this.isRawType() && this.delegate.isGeneric();
    }

    public String getGenericSignature() {
        String sig = this.delegate.getDeclaredGenericSignature();
        return sig == null ? "" : sig;
    }

    @Override
    public AnnotationAJ[] getAnnotations() {
        return this.delegate.getAnnotations();
    }

    @Override
    public void addAnnotation(AnnotationAJ annotationX) {
        if (this.annotations == null) {
            this.annotations = new AnnotationAJ[1];
            this.annotations[0] = annotationX;
        } else {
            AnnotationAJ[] newAnnotations = new AnnotationAJ[this.annotations.length + 1];
            System.arraycopy(this.annotations, 0, newAnnotations, 1, this.annotations.length);
            newAnnotations[0] = annotationX;
            this.annotations = newAnnotations;
        }
        this.addAnnotationType(annotationX.getType());
    }

    @Override
    public boolean hasAnnotation(UnresolvedType ofType) {
        boolean onDelegate = this.delegate.hasAnnotation(ofType);
        if (onDelegate) {
            return true;
        }
        if (this.annotationTypes != null) {
            for (int i2 = 0; i2 < this.annotationTypes.length; ++i2) {
                if (!this.annotationTypes[i2].equals(ofType)) continue;
                return true;
            }
        }
        return false;
    }

    private void addAnnotationType(ResolvedType ofType) {
        if (this.annotationTypes == null) {
            this.annotationTypes = new ResolvedType[1];
            this.annotationTypes[0] = ofType;
        } else {
            ResolvedType[] newAnnotationTypes = new ResolvedType[this.annotationTypes.length + 1];
            System.arraycopy(this.annotationTypes, 0, newAnnotationTypes, 1, this.annotationTypes.length);
            newAnnotationTypes[0] = ofType;
            this.annotationTypes = newAnnotationTypes;
        }
    }

    @Override
    public ResolvedType[] getAnnotationTypes() {
        if (this.delegate == null) {
            throw new BCException("Unexpected null delegate for type " + this.getName());
        }
        if (this.annotationTypes == null) {
            return this.delegate.getAnnotationTypes();
        }
        ResolvedType[] delegateAnnotationTypes = this.delegate.getAnnotationTypes();
        ResolvedType[] result = new ResolvedType[this.annotationTypes.length + delegateAnnotationTypes.length];
        System.arraycopy(delegateAnnotationTypes, 0, result, 0, delegateAnnotationTypes.length);
        System.arraycopy(this.annotationTypes, 0, result, delegateAnnotationTypes.length, this.annotationTypes.length);
        return result;
    }

    @Override
    public String getNameAsIdentifier() {
        return this.getRawName().replace('.', '_');
    }

    @Override
    public AnnotationAJ getAnnotationOfType(UnresolvedType ofType) {
        AnnotationAJ[] axs = this.delegate.getAnnotations();
        if (axs == null) {
            if (this.annotations != null) {
                String searchSig = ofType.getSignature();
                for (int i2 = 0; i2 < this.annotations.length; ++i2) {
                    if (!this.annotations[i2].getTypeSignature().equals(searchSig)) continue;
                    return this.annotations[i2];
                }
            }
            return null;
        }
        for (int i3 = 0; i3 < axs.length; ++i3) {
            if (!axs[i3].getTypeSignature().equals(ofType.getSignature())) continue;
            return axs[i3];
        }
        return null;
    }

    @Override
    public boolean isAspect() {
        return this.delegate.isAspect();
    }

    @Override
    public boolean isAnnotationStyleAspect() {
        return this.delegate.isAnnotationStyleAspect();
    }

    @Override
    public boolean isEnum() {
        return this.delegate.isEnum();
    }

    @Override
    public boolean isAnnotation() {
        return this.delegate.isAnnotation();
    }

    @Override
    public boolean isAnonymous() {
        return this.delegate.isAnonymous();
    }

    @Override
    public boolean isNested() {
        return this.delegate.isNested();
    }

    public ResolvedType getOuterClass() {
        return this.delegate.getOuterClass();
    }

    public String getRetentionPolicy() {
        return this.delegate.getRetentionPolicy();
    }

    @Override
    public boolean isAnnotationWithRuntimeRetention() {
        return this.delegate.isAnnotationWithRuntimeRetention();
    }

    @Override
    public boolean canAnnotationTargetType() {
        return this.delegate.canAnnotationTargetType();
    }

    @Override
    public AnnotationTargetKind[] getAnnotationTargetKinds() {
        return this.delegate.getAnnotationTargetKinds();
    }

    @Override
    public boolean isCoerceableFrom(ResolvedType o2) {
        ResolvedType other = o2.resolve(this.world);
        if (this.isAssignableFrom(other) || other.isAssignableFrom(this)) {
            return true;
        }
        if (this.isParameterizedType() && other.isParameterizedType()) {
            return this.isCoerceableFromParameterizedType(other);
        }
        if (this.isParameterizedType() && other.isRawType()) {
            return ((ReferenceType)this.getRawType()).isCoerceableFrom(other.getGenericType());
        }
        if (this.isRawType() && other.isParameterizedType()) {
            return this.getGenericType().isCoerceableFrom(other.getRawType());
        }
        if (!this.isInterface() && !other.isInterface()) {
            return false;
        }
        if (this.isFinal() || other.isFinal()) {
            return false;
        }
        ResolvedMember[] a2 = this.getDeclaredMethods();
        ResolvedMember[] b2 = other.getDeclaredMethods();
        int alen = a2.length;
        for (int ai = 0; ai < alen; ++ai) {
            int blen = b2.length;
            for (int bi = 0; bi < blen; ++bi) {
                if (b2[bi].isCompatibleWith(a2[ai])) continue;
                return false;
            }
        }
        return true;
    }

    private final boolean isCoerceableFromParameterizedType(ResolvedType other) {
        ResolvedType theirRawType;
        if (!other.isParameterizedType()) {
            return false;
        }
        ResolvedType myRawType = this.getRawType();
        if ((myRawType == (theirRawType = other.getRawType()) || myRawType.isCoerceableFrom(theirRawType)) && this.getTypeParameters().length == other.getTypeParameters().length) {
            ResolvedType[] myTypeParameters = this.getResolvedTypeParameters();
            ResolvedType[] theirTypeParameters = other.getResolvedTypeParameters();
            for (int i2 = 0; i2 < myTypeParameters.length; ++i2) {
                TypeVariable tv;
                TypeVariableReferenceType tvrt;
                BoundedReferenceType wildcard;
                if (myTypeParameters[i2] == theirTypeParameters[i2]) continue;
                if (myTypeParameters[i2].isGenericWildcard()) {
                    wildcard = (BoundedReferenceType)myTypeParameters[i2];
                    if (wildcard.canBeCoercedTo(theirTypeParameters[i2])) continue;
                    return false;
                }
                if (myTypeParameters[i2].isTypeVariableReference()) {
                    tvrt = (TypeVariableReferenceType)myTypeParameters[i2];
                    tv = tvrt.getTypeVariable();
                    tv.resolve(this.world);
                    if (tv.canBeBoundTo(theirTypeParameters[i2])) continue;
                    return false;
                }
                if (theirTypeParameters[i2].isTypeVariableReference()) {
                    tvrt = (TypeVariableReferenceType)theirTypeParameters[i2];
                    tv = tvrt.getTypeVariable();
                    tv.resolve(this.world);
                    if (tv.canBeBoundTo(myTypeParameters[i2])) continue;
                    return false;
                }
                if (theirTypeParameters[i2].isGenericWildcard()) {
                    wildcard = (BoundedReferenceType)theirTypeParameters[i2];
                    if (wildcard.canBeCoercedTo(myTypeParameters[i2])) continue;
                    return false;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isAssignableFrom(ResolvedType other) {
        return this.isAssignableFrom(other, false);
    }

    @Override
    public boolean isAssignableFrom(ResolvedType other, boolean allowMissing) {
        ResolvedType[] interfaces;
        if (other.isPrimitiveType()) {
            if (!this.world.isInJava5Mode()) {
                return false;
            }
            if (ResolvedType.validBoxing.contains(this.getSignature() + other.getSignature())) {
                return true;
            }
        }
        if (this == other) {
            return true;
        }
        if (this.getSignature().equals(ResolvedType.OBJECT.getSignature())) {
            return true;
        }
        boolean thisRaw = this.isRawType();
        boolean thisGeneric = this.isGenericType();
        if ((thisRaw || thisGeneric) && other.isParameterizedType() && this.isAssignableFrom(other.getRawType())) {
            return true;
        }
        if (thisRaw && other.isGenericType() && this.isAssignableFrom(other.getRawType())) {
            return true;
        }
        if (thisGeneric && other.isRawType() && this.isAssignableFrom(other.getGenericType())) {
            return true;
        }
        if (this.isParameterizedType() && ((ReferenceType)this.getRawType()).isAssignableFrom(other)) {
            boolean wildcardsAllTheWay = true;
            ResolvedType[] myParameters = this.getResolvedTypeParameters();
            for (int i2 = 0; i2 < myParameters.length; ++i2) {
                if (!myParameters[i2].isGenericWildcard()) {
                    wildcardsAllTheWay = false;
                    continue;
                }
                BoundedReferenceType boundedRT = (BoundedReferenceType)myParameters[i2];
                if (!boundedRT.isExtends() && !boundedRT.isSuper()) continue;
                wildcardsAllTheWay = false;
            }
            if (wildcardsAllTheWay && !other.isParameterizedType()) {
                return true;
            }
            ResolvedType[] theirParameters = other.getResolvedTypeParameters();
            boolean parametersAssignable = true;
            if (myParameters.length == theirParameters.length) {
                block1: for (int i3 = 0; i3 < myParameters.length && parametersAssignable; ++i3) {
                    if (myParameters[i3] == theirParameters[i3]) continue;
                    ResolvedType mp = myParameters[i3];
                    ResolvedType tp = theirParameters[i3];
                    if (mp.isParameterizedType() && tp.isParameterizedType()) {
                        if (mp.getGenericType().equals(tp.getGenericType())) {
                            UnresolvedType[] mtps = mp.getTypeParameters();
                            UnresolvedType[] ttps = tp.getTypeParameters();
                            for (int ii = 0; ii < mtps.length; ++ii) {
                                if (mtps[ii].isTypeVariableReference() && ttps[ii].isTypeVariableReference()) {
                                    TypeVariable mtv = ((TypeVariableReferenceType)mtps[ii]).getTypeVariable();
                                    boolean b2 = mtv.canBeBoundTo((ResolvedType)ttps[ii]);
                                    if (b2) continue;
                                    parametersAssignable = false;
                                    continue block1;
                                }
                                parametersAssignable = false;
                                continue block1;
                            }
                            continue;
                        }
                        parametersAssignable = false;
                        break;
                    }
                    if (myParameters[i3].isTypeVariableReference() && theirParameters[i3].isTypeVariableReference()) {
                        TypeVariable myTV = ((TypeVariableReferenceType)myParameters[i3]).getTypeVariable();
                        boolean b3 = myTV.canBeBoundTo(theirParameters[i3]);
                        if (b3) continue;
                        parametersAssignable = false;
                    } else if (!myParameters[i3].isGenericWildcard()) {
                        parametersAssignable = false;
                    } else {
                        BoundedReferenceType wildcardType = (BoundedReferenceType)myParameters[i3];
                        if (wildcardType.alwaysMatches(theirParameters[i3])) continue;
                        parametersAssignable = false;
                    }
                    break;
                }
            } else {
                parametersAssignable = false;
            }
            if (parametersAssignable) {
                return true;
            }
        }
        if (this.isTypeVariableReference() && !other.isTypeVariableReference()) {
            TypeVariable aVar = ((TypeVariableReference)((Object)this)).getTypeVariable();
            return aVar.resolve(this.world).canBeBoundTo(other);
        }
        if (other.isTypeVariableReference()) {
            TypeVariableReferenceType otherType = (TypeVariableReferenceType)other;
            if (this instanceof TypeVariableReference) {
                return ((TypeVariableReference)((Object)this)).getTypeVariable().resolve(this.world).canBeBoundTo(otherType.getTypeVariable().getFirstBound().resolve(this.world));
            }
            return this.isAssignableFrom(otherType.getTypeVariable().getFirstBound().resolve(this.world));
        }
        if (allowMissing && other.isMissing()) {
            return false;
        }
        for (ResolvedType intface : interfaces = other.getDeclaredInterfaces()) {
            if (!this.isAssignableFrom(intface, allowMissing)) continue;
            return true;
        }
        ResolvedType superclass = other.getSuperclass();
        return superclass != null && this.isAssignableFrom(superclass, allowMissing);
    }

    @Override
    public ISourceContext getSourceContext() {
        return this.delegate.getSourceContext();
    }

    @Override
    public ISourceLocation getSourceLocation() {
        ISourceContext isc = this.delegate.getSourceContext();
        return isc.makeSourceLocation(new Position(this.startPos, this.endPos));
    }

    @Override
    public boolean isExposedToWeaver() {
        return this.delegate == null || this.delegate.isExposedToWeaver();
    }

    @Override
    public WeaverStateInfo getWeaverState() {
        return this.delegate.getWeaverState();
    }

    @Override
    public ResolvedMember[] getDeclaredFields() {
        if (this.parameterizedFields != null) {
            return this.parameterizedFields;
        }
        if (this.isParameterizedType() || this.isRawType()) {
            ResolvedMember[] delegateFields = this.delegate.getDeclaredFields();
            this.parameterizedFields = new ResolvedMember[delegateFields.length];
            for (int i2 = 0; i2 < delegateFields.length; ++i2) {
                this.parameterizedFields[i2] = delegateFields[i2].parameterizedWith(this.getTypesForMemberParameterization(), this, this.isParameterizedType());
            }
            return this.parameterizedFields;
        }
        return this.delegate.getDeclaredFields();
    }

    @Override
    public ResolvedType[] getDeclaredInterfaces() {
        ResolvedType[] interfaces = (ResolvedType[])this.parameterizedInterfaces.get();
        if (interfaces != null) {
            return interfaces;
        }
        ResolvedType[] delegateInterfaces = this.delegate.getDeclaredInterfaces();
        if (this.newInterfaces != null) {
            ResolvedType[] extraInterfaces = new ResolvedType[delegateInterfaces.length + this.newInterfaces.length];
            System.arraycopy(delegateInterfaces, 0, extraInterfaces, 0, delegateInterfaces.length);
            System.arraycopy(this.newInterfaces, 0, extraInterfaces, delegateInterfaces.length, this.newInterfaces.length);
            delegateInterfaces = extraInterfaces;
        }
        if (this.isParameterizedType()) {
            interfaces = new ResolvedType[delegateInterfaces.length];
            for (int i2 = 0; i2 < delegateInterfaces.length; ++i2) {
                interfaces[i2] = delegateInterfaces[i2].isParameterizedType() ? delegateInterfaces[i2].parameterize(this.getMemberParameterizationMap()).resolve(this.world) : delegateInterfaces[i2];
            }
            this.parameterizedInterfaces = new WeakReference<ResolvedType[]>(interfaces);
            return interfaces;
        }
        if (this.isRawType()) {
            UnresolvedType[] paramTypes = this.getTypesForMemberParameterization();
            interfaces = new ResolvedType[delegateInterfaces.length];
            int max = interfaces.length;
            for (int i3 = 0; i3 < max; ++i3) {
                interfaces[i3] = delegateInterfaces[i3];
                if (interfaces[i3].isGenericType()) {
                    interfaces[i3] = interfaces[i3].getRawType().resolve(this.getWorld());
                    continue;
                }
                if (!interfaces[i3].isParameterizedType()) continue;
                UnresolvedType[] toUseForParameterization = this.determineThoseTypesToUse(interfaces[i3], paramTypes);
                interfaces[i3] = interfaces[i3].parameterizedWith(toUseForParameterization);
            }
            this.parameterizedInterfaces = new WeakReference<ResolvedType[]>(interfaces);
            return interfaces;
        }
        if (this.delegate.isCacheable()) {
            this.parameterizedInterfaces = new WeakReference<ResolvedType[]>(delegateInterfaces);
        }
        return delegateInterfaces;
    }

    private String toString(ResolvedType[] delegateInterfaces) {
        StringBuffer sb = new StringBuffer();
        if (delegateInterfaces != null) {
            for (ResolvedType rt : delegateInterfaces) {
                sb.append(rt).append(" ");
            }
        }
        return sb.toString();
    }

    private UnresolvedType[] determineThoseTypesToUse(ResolvedType parameterizedInterface, UnresolvedType[] paramTypes) {
        UnresolvedType[] tParms = parameterizedInterface.getTypeParameters();
        UnresolvedType[] retVal = new UnresolvedType[tParms.length];
        for (int i2 = 0; i2 < tParms.length; ++i2) {
            UnresolvedType tParm = tParms[i2];
            if (tParm.isTypeVariableReference()) {
                TypeVariableReference tvrt = (TypeVariableReference)((Object)tParm);
                TypeVariable tv = tvrt.getTypeVariable();
                int rank = this.getRank(tv.getName());
                if (rank != -1) {
                    retVal[i2] = paramTypes[rank];
                    continue;
                }
                retVal[i2] = tParms[i2];
                continue;
            }
            retVal[i2] = tParms[i2];
        }
        return retVal;
    }

    private int getRank(String tvname) {
        TypeVariable[] thisTypesTVars = this.getGenericType().getTypeVariables();
        for (int i2 = 0; i2 < thisTypesTVars.length; ++i2) {
            TypeVariable tv = thisTypesTVars[i2];
            if (!tv.getName().equals(tvname)) continue;
            return i2;
        }
        return -1;
    }

    @Override
    public ResolvedMember[] getDeclaredMethods() {
        if (this.parameterizedMethods != null) {
            return this.parameterizedMethods;
        }
        if (this.isParameterizedType() || this.isRawType()) {
            ResolvedMember[] delegateMethods = this.delegate.getDeclaredMethods();
            UnresolvedType[] parameters = this.getTypesForMemberParameterization();
            this.parameterizedMethods = new ResolvedMember[delegateMethods.length];
            for (int i2 = 0; i2 < delegateMethods.length; ++i2) {
                this.parameterizedMethods[i2] = delegateMethods[i2].parameterizedWith(parameters, this, this.isParameterizedType());
            }
            return this.parameterizedMethods;
        }
        return this.delegate.getDeclaredMethods();
    }

    @Override
    public ResolvedMember[] getDeclaredPointcuts() {
        if (this.parameterizedPointcuts != null) {
            return this.parameterizedPointcuts;
        }
        if (this.isParameterizedType()) {
            ResolvedMember[] delegatePointcuts = this.delegate.getDeclaredPointcuts();
            this.parameterizedPointcuts = new ResolvedMember[delegatePointcuts.length];
            for (int i2 = 0; i2 < delegatePointcuts.length; ++i2) {
                this.parameterizedPointcuts[i2] = delegatePointcuts[i2].parameterizedWith(this.getTypesForMemberParameterization(), this, this.isParameterizedType());
            }
            return this.parameterizedPointcuts;
        }
        return this.delegate.getDeclaredPointcuts();
    }

    private UnresolvedType[] getTypesForMemberParameterization() {
        UnresolvedType[] parameters = null;
        if (this.isParameterizedType()) {
            parameters = this.getTypeParameters();
        } else if (this.isRawType()) {
            TypeVariable[] tvs = this.getGenericType().getTypeVariables();
            parameters = new UnresolvedType[tvs.length];
            for (int i2 = 0; i2 < tvs.length; ++i2) {
                parameters[i2] = tvs[i2].getFirstBound();
            }
        }
        return parameters;
    }

    @Override
    public TypeVariable[] getTypeVariables() {
        if (this.typeVariables == null) {
            this.typeVariables = this.delegate.getTypeVariables();
            for (int i2 = 0; i2 < this.typeVariables.length; ++i2) {
                this.typeVariables[i2].resolve(this.world);
            }
        }
        return this.typeVariables;
    }

    @Override
    public PerClause getPerClause() {
        PerClause pclause = this.delegate.getPerClause();
        if (this.isParameterizedType()) {
            Map<String, UnresolvedType> parameterizationMap = this.getAjMemberParameterizationMap();
            pclause = (PerClause)pclause.parameterizeWith(parameterizationMap, this.world);
        }
        return pclause;
    }

    @Override
    public Collection<Declare> getDeclares() {
        if (this.parameterizedDeclares != null) {
            return this.parameterizedDeclares;
        }
        Collection<Declare> declares = null;
        if (this.ajMembersNeedParameterization()) {
            Collection<Declare> genericDeclares = this.delegate.getDeclares();
            this.parameterizedDeclares = new ArrayList<Declare>();
            Map<String, UnresolvedType> parameterizationMap = this.getAjMemberParameterizationMap();
            for (Declare declareStatement : genericDeclares) {
                this.parameterizedDeclares.add(declareStatement.parameterizeWith(parameterizationMap, this.world));
            }
            declares = this.parameterizedDeclares;
        } else {
            declares = this.delegate.getDeclares();
        }
        for (Declare d2 : declares) {
            d2.setDeclaringType(this);
        }
        return declares;
    }

    @Override
    public Collection<ConcreteTypeMunger> getTypeMungers() {
        return this.delegate.getTypeMungers();
    }

    public Collection getPrivilegedAccesses() {
        return this.delegate.getPrivilegedAccesses();
    }

    @Override
    public int getModifiers() {
        return this.delegate.getModifiers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResolvedType getSuperclass() {
        ResolvedType ret = null;
        if (ret != null) {
            return ret;
        }
        if (this.newSuperclass != null) {
            if (this.isParameterizedType() && this.newSuperclass.isParameterizedType()) {
                return this.newSuperclass.parameterize(this.getMemberParameterizationMap()).resolve(this.getWorld());
            }
            if (this.delegate.isCacheable()) {
                this.superclassReference = new WeakReference<ResolvedType>(ret);
            }
            return this.newSuperclass;
        }
        try {
            this.world.setTypeVariableLookupScope(this);
            ret = this.delegate.getSuperclass();
        }
        finally {
            this.world.setTypeVariableLookupScope(null);
        }
        if (this.isParameterizedType() && ret.isParameterizedType()) {
            ret = ret.parameterize(this.getMemberParameterizationMap()).resolve(this.getWorld());
        }
        if (this.delegate.isCacheable()) {
            this.superclassReference = new WeakReference<ResolvedType>(ret);
        }
        return ret;
    }

    public ReferenceTypeDelegate getDelegate() {
        return this.delegate;
    }

    public void setDelegate(ReferenceTypeDelegate delegate) {
        ReferenceType genType;
        if (this.delegate != null && this.delegate.copySourceContext() && this.delegate.getSourceContext() != SourceContextImpl.UNKNOWN_SOURCE_CONTEXT) {
            ((AbstractReferenceTypeDelegate)delegate).setSourceContext(this.delegate.getSourceContext());
        }
        this.delegate = delegate;
        for (ReferenceType dependent : this.derivativeTypes) {
            dependent.setDelegate(delegate);
        }
        if (this.isRawType() && this.getGenericType() != null && (genType = (ReferenceType)this.getGenericType()).getDelegate() != delegate) {
            genType.setDelegate(delegate);
        }
        this.clearParameterizationCaches();
        this.ensureConsistent();
    }

    private void clearParameterizationCaches() {
        this.parameterizedFields = null;
        this.parameterizedInterfaces.clear();
        this.parameterizedMethods = null;
        this.parameterizedPointcuts = null;
        this.superclassReference = new WeakReference<Object>(null);
    }

    public int getEndPos() {
        return this.endPos;
    }

    public int getStartPos() {
        return this.startPos;
    }

    public void setEndPos(int endPos) {
        this.endPos = endPos;
    }

    public void setStartPos(int startPos) {
        this.startPos = startPos;
    }

    @Override
    public boolean doesNotExposeShadowMungers() {
        return this.delegate.doesNotExposeShadowMungers();
    }

    public String getDeclaredGenericSignature() {
        return this.delegate.getDeclaredGenericSignature();
    }

    public void setGenericType(ReferenceType rt) {
        this.genericType = rt;
        if (this.typeKind == UnresolvedType.TypeKind.SIMPLE) {
            this.typeKind = UnresolvedType.TypeKind.RAW;
            this.signatureErasure = this.signature;
        }
    }

    public void demoteToSimpleType() {
        this.genericType = null;
        this.typeKind = UnresolvedType.TypeKind.SIMPLE;
        this.signatureErasure = null;
    }

    @Override
    public ResolvedType getGenericType() {
        if (this.isGenericType()) {
            return this;
        }
        return this.genericType;
    }

    private static String makeParameterizedSignature(ResolvedType aGenericType, ResolvedType[] someParameters) {
        String rawSignature = aGenericType.getErasureSignature();
        StringBuffer ret = new StringBuffer();
        ret.append("P");
        ret.append(rawSignature.substring(1, rawSignature.length() - 1));
        ret.append("<");
        for (int i2 = 0; i2 < someParameters.length; ++i2) {
            ret.append(someParameters[i2].getSignature());
        }
        ret.append(">;");
        return ret.toString();
    }

    private static String makeDeclaredSignature(ResolvedType aGenericType, UnresolvedType[] someParameters) {
        StringBuffer ret = new StringBuffer();
        String rawSig = aGenericType.getErasureSignature();
        ret.append(rawSig.substring(0, rawSig.length() - 1));
        ret.append("<");
        for (int i2 = 0; i2 < someParameters.length; ++i2) {
            ret.append(((ReferenceType)someParameters[i2]).getSignatureForAttribute());
        }
        ret.append(">;");
        return ret.toString();
    }

    @Override
    public void ensureConsistent() {
        this.annotations = null;
        this.annotationTypes = null;
        this.newSuperclass = null;
        this.newInterfaces = null;
        this.parameterizedInterfaces.clear();
        this.superclassReference = new WeakReference<Object>(null);
    }

    @Override
    public void addParent(ResolvedType newParent) {
        if (newParent.isClass()) {
            this.newSuperclass = newParent;
            this.superclassReference = new WeakReference<Object>(null);
        } else {
            if (this.newInterfaces == null) {
                this.newInterfaces = new ResolvedType[1];
                this.newInterfaces[0] = newParent;
            } else {
                ResolvedType[] existing = this.delegate.getDeclaredInterfaces();
                if (existing != null) {
                    for (int i2 = 0; i2 < existing.length; ++i2) {
                        if (!existing[i2].equals(newParent)) continue;
                        return;
                    }
                }
                ResolvedType[] newNewInterfaces = new ResolvedType[this.newInterfaces.length + 1];
                System.arraycopy(this.newInterfaces, 0, newNewInterfaces, 1, this.newInterfaces.length);
                newNewInterfaces[0] = newParent;
                this.newInterfaces = newNewInterfaces;
            }
            this.parameterizedInterfaces.clear();
        }
    }
}

