/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.aspectj.weaver.AbstractAnnotationAJ;
import org.aspectj.weaver.AnnotationNameValuePair;
import org.aspectj.weaver.AnnotationValue;
import org.aspectj.weaver.ArrayAnnotationValue;
import org.aspectj.weaver.ResolvedType;
import org.aspectj.weaver.UnresolvedType;

public class StandardAnnotation
extends AbstractAnnotationAJ {
    private final boolean isRuntimeVisible;
    private List nvPairs = null;

    public StandardAnnotation(ResolvedType type, boolean isRuntimeVisible) {
        super(type);
        this.isRuntimeVisible = isRuntimeVisible;
    }

    public boolean isRuntimeVisible() {
        return this.isRuntimeVisible;
    }

    public String stringify() {
        StringBuffer sb = new StringBuffer();
        sb.append("@").append(this.type.getClassName());
        if (this.hasNameValuePairs()) {
            sb.append("(");
            for (AnnotationNameValuePair element : this.nvPairs) {
                sb.append(element.stringify());
            }
            sb.append(")");
        }
        return sb.toString();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("ANNOTATION [" + this.getTypeSignature() + "] [" + (this.isRuntimeVisible ? "runtimeVisible" : "runtimeInvisible") + "] [");
        if (this.nvPairs != null) {
            Iterator iter = this.nvPairs.iterator();
            while (iter.hasNext()) {
                AnnotationNameValuePair element = (AnnotationNameValuePair)iter.next();
                sb.append(element.toString());
                if (!iter.hasNext()) continue;
                sb.append(",");
            }
        }
        sb.append("]");
        return sb.toString();
    }

    public boolean hasNamedValue(String n2) {
        if (this.nvPairs == null) {
            return false;
        }
        for (int i2 = 0; i2 < this.nvPairs.size(); ++i2) {
            AnnotationNameValuePair pair = (AnnotationNameValuePair)this.nvPairs.get(i2);
            if (!pair.getName().equals(n2)) continue;
            return true;
        }
        return false;
    }

    public boolean hasNameValuePair(String n2, String v) {
        if (this.nvPairs == null) {
            return false;
        }
        for (int i2 = 0; i2 < this.nvPairs.size(); ++i2) {
            AnnotationNameValuePair pair = (AnnotationNameValuePair)this.nvPairs.get(i2);
            if (!pair.getName().equals(n2) || !pair.getValue().stringify().equals(v)) continue;
            return true;
        }
        return false;
    }

    public Set getTargets() {
        if (!this.type.equals(UnresolvedType.AT_TARGET)) {
            return Collections.EMPTY_SET;
        }
        AnnotationNameValuePair nvp = (AnnotationNameValuePair)this.nvPairs.get(0);
        ArrayAnnotationValue aav = (ArrayAnnotationValue)nvp.getValue();
        AnnotationValue[] avs = aav.getValues();
        HashSet<String> targets = new HashSet<String>();
        for (int i2 = 0; i2 < avs.length; ++i2) {
            AnnotationValue value = avs[i2];
            targets.add(value.stringify());
        }
        return targets;
    }

    public List getNameValuePairs() {
        return this.nvPairs;
    }

    public boolean hasNameValuePairs() {
        return this.nvPairs != null && this.nvPairs.size() != 0;
    }

    public void addNameValuePair(AnnotationNameValuePair pair) {
        if (this.nvPairs == null) {
            this.nvPairs = new ArrayList();
        }
        this.nvPairs.add(pair);
    }

    public String getStringFormOfValue(String name) {
        if (this.hasNameValuePairs()) {
            for (AnnotationNameValuePair nvPair : this.nvPairs) {
                if (!nvPair.getName().equals(name)) continue;
                return nvPair.getValue().stringify();
            }
        }
        return null;
    }
}

