/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver.ast;

import org.aspectj.weaver.Member;
import org.aspectj.weaver.ResolvedType;
import org.aspectj.weaver.ast.ASTNode;
import org.aspectj.weaver.ast.And;
import org.aspectj.weaver.ast.Call;
import org.aspectj.weaver.ast.Expr;
import org.aspectj.weaver.ast.FieldGetCall;
import org.aspectj.weaver.ast.HasAnnotation;
import org.aspectj.weaver.ast.ITestVisitor;
import org.aspectj.weaver.ast.Instanceof;
import org.aspectj.weaver.ast.Literal;
import org.aspectj.weaver.ast.Not;
import org.aspectj.weaver.ast.Or;
import org.aspectj.weaver.ast.Var;

public abstract class Test
extends ASTNode {
    public abstract void accept(ITestVisitor var1);

    public static Test makeAnd(Test a2, Test b2) {
        if (a2 == Literal.TRUE) {
            if (b2 == Literal.TRUE) {
                return a2;
            }
            return b2;
        }
        if (b2 == Literal.TRUE) {
            return a2;
        }
        if (a2 == Literal.FALSE || b2 == Literal.FALSE) {
            return Literal.FALSE;
        }
        return new And(a2, b2);
    }

    public static Test makeOr(Test a2, Test b2) {
        if (a2 == Literal.FALSE) {
            return b2;
        }
        if (b2 == Literal.FALSE) {
            return a2;
        }
        if (a2 == Literal.TRUE || b2 == Literal.TRUE) {
            return Literal.TRUE;
        }
        return new Or(a2, b2);
    }

    public static Test makeNot(Test a2) {
        if (a2 instanceof Not) {
            return ((Not)a2).getBody();
        }
        if (a2 == Literal.TRUE) {
            return Literal.FALSE;
        }
        if (a2 == Literal.FALSE) {
            return Literal.TRUE;
        }
        return new Not(a2);
    }

    public static Test makeInstanceof(Var v, ResolvedType ty) {
        if (ty.equals(ResolvedType.OBJECT)) {
            return Literal.TRUE;
        }
        Test e2 = ty.isAssignableFrom(v.getType()) ? Literal.TRUE : (!ty.isCoerceableFrom(v.getType()) ? Literal.FALSE : new Instanceof(v, ty));
        return e2;
    }

    public static Test makeHasAnnotation(Var v, ResolvedType annTy) {
        return new HasAnnotation(v, annTy);
    }

    public static Test makeCall(Member m2, Expr[] args) {
        return new Call(m2, args);
    }

    public static Test makeFieldGetCall(Member f2, Member m2, Expr[] args) {
        return new FieldGetCall(f2, m2, args);
    }
}

