/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.aspectj.apache.bcel.classfile.AnnotationDefault;
import org.aspectj.apache.bcel.classfile.Attribute;
import org.aspectj.apache.bcel.classfile.Field;
import org.aspectj.apache.bcel.classfile.JavaClass;
import org.aspectj.apache.bcel.classfile.LocalVariable;
import org.aspectj.apache.bcel.classfile.LocalVariableTable;
import org.aspectj.apache.bcel.classfile.Method;
import org.aspectj.apache.bcel.classfile.annotation.AnnotationGen;
import org.aspectj.apache.bcel.util.NonCachingClassLoaderRepository;
import org.aspectj.apache.bcel.util.Repository;
import org.aspectj.weaver.AnnotationAJ;
import org.aspectj.weaver.ResolvedType;
import org.aspectj.weaver.UnresolvedType;
import org.aspectj.weaver.World;
import org.aspectj.weaver.bcel.BcelAnnotation;
import org.aspectj.weaver.bcel.BcelWeakClassLoaderReference;
import org.aspectj.weaver.reflect.AnnotationFinder;
import org.aspectj.weaver.reflect.ArgNameFinder;

public class Java15AnnotationFinder
implements AnnotationFinder,
ArgNameFinder {
    private Repository bcelRepository;
    private BcelWeakClassLoaderReference classLoaderRef;
    private World world;
    public static final ResolvedType[][] NO_PARAMETER_ANNOTATIONS = new ResolvedType[0][];

    public void setClassLoader(ClassLoader aLoader) {
        this.classLoaderRef = new BcelWeakClassLoaderReference(aLoader);
        this.bcelRepository = new NonCachingClassLoaderRepository(this.classLoaderRef);
    }

    public void setWorld(World aWorld) {
        this.world = aWorld;
    }

    public Object getAnnotation(ResolvedType annotationType, Object onObject) {
        try {
            Class<?> annotationClass = Class.forName(annotationType.getName(), false, this.getClassLoader());
            if (onObject.getClass().isAnnotationPresent(annotationClass)) {
                return onObject.getClass().getAnnotation(annotationClass);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return null;
    }

    public Object getAnnotationFromClass(ResolvedType annotationType, Class aClass) {
        try {
            Class<?> annotationClass = Class.forName(annotationType.getName(), false, this.getClassLoader());
            if (aClass.isAnnotationPresent(annotationClass)) {
                return aClass.getAnnotation(annotationClass);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return null;
    }

    public Object getAnnotationFromMember(ResolvedType annotationType, Member aMember) {
        if (!(aMember instanceof AccessibleObject)) {
            return null;
        }
        AccessibleObject ao = (AccessibleObject)((Object)aMember);
        try {
            Class<?> annotationClass = Class.forName(annotationType.getName(), false, this.getClassLoader());
            if (ao.isAnnotationPresent(annotationClass)) {
                return ao.getAnnotation(annotationClass);
            }
        }
        catch (ClassNotFoundException ex) {
            // empty catch block
        }
        return null;
    }

    private ClassLoader getClassLoader() {
        return this.classLoaderRef.getClassLoader();
    }

    public AnnotationAJ getAnnotationOfType(UnresolvedType ofType, Member onMember) {
        if (!(onMember instanceof AccessibleObject)) {
            return null;
        }
        try {
            JavaClass jc = this.bcelRepository.loadClass(onMember.getDeclaringClass());
            AnnotationGen[] anns = new AnnotationGen[]{};
            if (onMember instanceof java.lang.reflect.Method) {
                Method bcelMethod = jc.getMethod((java.lang.reflect.Method)onMember);
                if (bcelMethod != null) {
                    anns = bcelMethod.getAnnotations();
                }
            } else if (onMember instanceof Constructor) {
                Method bcelCons = jc.getMethod((Constructor)onMember);
                anns = bcelCons.getAnnotations();
            } else if (onMember instanceof java.lang.reflect.Field) {
                Field bcelField = jc.getField((java.lang.reflect.Field)onMember);
                anns = bcelField.getAnnotations();
            }
            this.bcelRepository.clear();
            if (anns == null) {
                anns = new AnnotationGen[]{};
            }
            for (int i2 = 0; i2 < anns.length; ++i2) {
                if (!anns[i2].getTypeSignature().equals(ofType.getSignature())) continue;
                return new BcelAnnotation(anns[i2], this.world);
            }
            return null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    public String getAnnotationDefaultValue(Member onMember) {
        try {
            Method bcelMethod;
            JavaClass jc = this.bcelRepository.loadClass(onMember.getDeclaringClass());
            if (onMember instanceof java.lang.reflect.Method && (bcelMethod = jc.getMethod((java.lang.reflect.Method)onMember)) != null) {
                Attribute[] attrs = bcelMethod.getAttributes();
                for (int i2 = 0; i2 < attrs.length; ++i2) {
                    Attribute attribute = attrs[i2];
                    if (!attribute.getName().equals("AnnotationDefault")) continue;
                    AnnotationDefault def = (AnnotationDefault)attribute;
                    return def.getElementValue().stringifyValue();
                }
                return null;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return null;
    }

    public Set getAnnotations(Member onMember) {
        if (!(onMember instanceof AccessibleObject)) {
            return Collections.EMPTY_SET;
        }
        try {
            JavaClass jc = this.bcelRepository.loadClass(onMember.getDeclaringClass());
            AnnotationGen[] anns = new AnnotationGen[]{};
            if (onMember instanceof java.lang.reflect.Method) {
                Method bcelMethod = jc.getMethod((java.lang.reflect.Method)onMember);
                if (bcelMethod != null) {
                    anns = bcelMethod.getAnnotations();
                }
            } else if (onMember instanceof Constructor) {
                Method bcelCons = jc.getMethod((Constructor)onMember);
                anns = bcelCons.getAnnotations();
            } else if (onMember instanceof java.lang.reflect.Field) {
                Field bcelField = jc.getField((java.lang.reflect.Field)onMember);
                anns = bcelField.getAnnotations();
            }
            this.bcelRepository.clear();
            if (anns == null) {
                anns = new AnnotationGen[]{};
            }
            HashSet<ResolvedType> annSet = new HashSet<ResolvedType>();
            for (int i2 = 0; i2 < anns.length; ++i2) {
                annSet.add(this.world.resolve(UnresolvedType.forSignature(anns[i2].getTypeSignature())));
            }
            return annSet;
        }
        catch (ClassNotFoundException cnfEx) {
            AccessibleObject ao = (AccessibleObject)((Object)onMember);
            Annotation[] anns = ao.getDeclaredAnnotations();
            HashSet<ResolvedType> annSet = new HashSet<ResolvedType>();
            for (int i3 = 0; i3 < anns.length; ++i3) {
                annSet.add(UnresolvedType.forName(anns[i3].annotationType().getName()).resolve(this.world));
            }
            return annSet;
        }
    }

    public ResolvedType[] getAnnotations(Class forClass, World inWorld) {
        try {
            JavaClass jc = this.bcelRepository.loadClass(forClass);
            AnnotationGen[] anns = jc.getAnnotations();
            this.bcelRepository.clear();
            if (anns == null) {
                return new ResolvedType[0];
            }
            ResolvedType[] ret = new ResolvedType[anns.length];
            for (int i2 = 0; i2 < ret.length; ++i2) {
                ret[i2] = inWorld.resolve(UnresolvedType.forSignature(anns[i2].getTypeSignature()));
            }
            return ret;
        }
        catch (ClassNotFoundException cnfEx) {
            Annotation[] classAnnotations = forClass.getAnnotations();
            ResolvedType[] ret = new ResolvedType[classAnnotations.length];
            for (int i3 = 0; i3 < classAnnotations.length; ++i3) {
                ret[i3] = inWorld.resolve(classAnnotations[i3].annotationType().getName());
            }
            return ret;
        }
    }

    public String[] getParameterNames(Member forMember) {
        if (!(forMember instanceof AccessibleObject)) {
            return null;
        }
        try {
            JavaClass jc = this.bcelRepository.loadClass(forMember.getDeclaringClass());
            LocalVariableTable lvt = null;
            int numVars = 0;
            if (forMember instanceof java.lang.reflect.Method) {
                Method bcelMethod = jc.getMethod((java.lang.reflect.Method)forMember);
                lvt = bcelMethod.getLocalVariableTable();
                numVars = bcelMethod.getArgumentTypes().length;
            } else if (forMember instanceof Constructor) {
                Method bcelCons = jc.getMethod((Constructor)forMember);
                lvt = bcelCons.getLocalVariableTable();
                numVars = bcelCons.getArgumentTypes().length;
            }
            return this.getParameterNamesFromLVT(lvt, numVars);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private String[] getParameterNamesFromLVT(LocalVariableTable lvt, int numVars) {
        if (lvt == null) {
            return null;
        }
        LocalVariable[] vars = lvt.getLocalVariableTable();
        if (vars.length < numVars) {
            return null;
        }
        String[] ret = new String[numVars];
        for (int i2 = 0; i2 < numVars; ++i2) {
            ret[i2] = vars[i2 + 1].getName();
        }
        return ret;
    }

    public ResolvedType[][] getParameterAnnotationTypes(Member onMember) {
        if (!(onMember instanceof AccessibleObject)) {
            return NO_PARAMETER_ANNOTATIONS;
        }
        try {
            JavaClass jc = this.bcelRepository.loadClass(onMember.getDeclaringClass());
            AnnotationGen[][] anns = null;
            if (onMember instanceof java.lang.reflect.Method) {
                Method bcelMethod = jc.getMethod((java.lang.reflect.Method)onMember);
                if (bcelMethod != null) {
                    anns = bcelMethod.getParameterAnnotations();
                }
            } else if (onMember instanceof Constructor) {
                Method bcelCons = jc.getMethod((Constructor)onMember);
                anns = bcelCons.getParameterAnnotations();
            } else if (onMember instanceof java.lang.reflect.Field) {
                // empty if block
            }
            this.bcelRepository.clear();
            if (anns == null) {
                return NO_PARAMETER_ANNOTATIONS;
            }
            ResolvedType[][] result = new ResolvedType[anns.length][];
            for (int i2 = 0; i2 < anns.length; ++i2) {
                if (anns[i2] == null) continue;
                result[i2] = new ResolvedType[anns[i2].length];
                for (int j2 = 0; j2 < anns[i2].length; ++j2) {
                    result[i2][j2] = this.world.resolve(UnresolvedType.forSignature(anns[i2][j2].getTypeSignature()));
                }
            }
            return result;
        }
        catch (ClassNotFoundException cnfEx) {
            AccessibleObject ao = (AccessibleObject)((Object)onMember);
            Annotation[][] anns = null;
            if (onMember instanceof java.lang.reflect.Method) {
                anns = ((java.lang.reflect.Method)ao).getParameterAnnotations();
            } else if (onMember instanceof Constructor) {
                anns = ((Constructor)ao).getParameterAnnotations();
            } else if (onMember instanceof java.lang.reflect.Field) {
                // empty if block
            }
            if (anns == null) {
                return NO_PARAMETER_ANNOTATIONS;
            }
            ResolvedType[][] result = new ResolvedType[anns.length][];
            for (int i3 = 0; i3 < anns.length; ++i3) {
                if (anns[i3] == null) continue;
                result[i3] = new ResolvedType[anns[i3].length];
                for (int j3 = 0; j3 < anns[i3].length; ++j3) {
                    result[i3][j3] = UnresolvedType.forName(anns[i3][j3].annotationType().getName()).resolve(this.world);
                }
            }
            return result;
        }
    }
}

