/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.apt.dispatch;

import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.apt.dispatch.AnnotationDiscoveryVisitor;
import org.eclipse.jdt.internal.compiler.apt.dispatch.BaseProcessingEnvImpl;
import org.eclipse.jdt.internal.compiler.apt.model.Factory;
import org.eclipse.jdt.internal.compiler.apt.model.TypeElementImpl;
import org.eclipse.jdt.internal.compiler.apt.util.ManyToMany;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.lookup.AnnotationBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;

public class RoundEnvImpl
implements RoundEnvironment {
    private final BaseProcessingEnvImpl _processingEnv;
    private final boolean _isLastRound;
    private final CompilationUnitDeclaration[] _units;
    private final ManyToMany<TypeElement, Element> _annoToUnit;
    private final ReferenceBinding[] _binaryTypes;
    private final Factory _factory;
    private Set<Element> _rootElements = null;

    public RoundEnvImpl(CompilationUnitDeclaration[] units, ReferenceBinding[] binaryTypeBindings, boolean isLastRound, BaseProcessingEnvImpl env) {
        this._processingEnv = env;
        this._isLastRound = isLastRound;
        this._units = units;
        this._factory = this._processingEnv.getFactory();
        AnnotationDiscoveryVisitor visitor = new AnnotationDiscoveryVisitor(this._processingEnv);
        if (this._units != null) {
            CompilationUnitDeclaration[] compilationUnitDeclarationArray = this._units;
            int n2 = this._units.length;
            int n3 = 0;
            while (n3 < n2) {
                CompilationUnitDeclaration unit = compilationUnitDeclarationArray[n3];
                unit.scope.suppressImportErrors = true;
                unit.traverse((ASTVisitor)visitor, unit.scope);
                unit.scope.suppressImportErrors = false;
                ++n3;
            }
        }
        this._annoToUnit = visitor._annoToElement;
        if (binaryTypeBindings != null) {
            this.collectAnnotations(binaryTypeBindings);
        }
        this._binaryTypes = binaryTypeBindings;
    }

    private void collectAnnotations(ReferenceBinding[] referenceBindings) {
        ReferenceBinding[] referenceBindingArray = referenceBindings;
        int n2 = referenceBindings.length;
        int n3 = 0;
        while (n3 < n2) {
            MethodBinding[] methodBindings;
            int n4;
            FieldBinding[] fieldBindings;
            AnnotationBinding[] annotationBindings;
            ReferenceBinding referenceBinding = referenceBindingArray[n3];
            if (referenceBinding instanceof ParameterizedTypeBinding) {
                referenceBinding = ((ParameterizedTypeBinding)referenceBinding).genericType();
            }
            AnnotationBinding[] annotationBindingArray = annotationBindings = Factory.getPackedAnnotationBindings(referenceBinding.getAnnotations());
            int n5 = annotationBindings.length;
            int n6 = 0;
            while (n6 < n5) {
                AnnotationBinding annotationBinding = annotationBindingArray[n6];
                TypeElement anno = (TypeElement)this._factory.newElement(annotationBinding.getAnnotationType());
                Element element = this._factory.newElement(referenceBinding);
                this._annoToUnit.put(anno, element);
                ++n6;
            }
            FieldBinding[] fieldBindingArray = fieldBindings = referenceBinding.fields();
            int n7 = fieldBindings.length;
            n5 = 0;
            while (n5 < n7) {
                FieldBinding fieldBinding = fieldBindingArray[n5];
                AnnotationBinding[] annotationBindingArray2 = annotationBindings = Factory.getPackedAnnotationBindings(fieldBinding.getAnnotations());
                n4 = annotationBindings.length;
                int n8 = 0;
                while (n8 < n4) {
                    AnnotationBinding annotationBinding = annotationBindingArray2[n8];
                    TypeElement anno = (TypeElement)this._factory.newElement(annotationBinding.getAnnotationType());
                    Element element = this._factory.newElement(fieldBinding);
                    this._annoToUnit.put(anno, element);
                    ++n8;
                }
                ++n5;
            }
            MethodBinding[] methodBindingArray = methodBindings = referenceBinding.methods();
            int n9 = methodBindings.length;
            n7 = 0;
            while (n7 < n9) {
                MethodBinding methodBinding = methodBindingArray[n7];
                AnnotationBinding[] annotationBindingArray3 = annotationBindings = Factory.getPackedAnnotationBindings(methodBinding.getAnnotations());
                int n10 = annotationBindings.length;
                n4 = 0;
                while (n4 < n10) {
                    AnnotationBinding annotationBinding = annotationBindingArray3[n4];
                    TypeElement anno = (TypeElement)this._factory.newElement(annotationBinding.getAnnotationType());
                    Element element = this._factory.newElement(methodBinding);
                    this._annoToUnit.put(anno, element);
                    ++n4;
                }
                ++n7;
            }
            ReferenceBinding[] memberTypes = referenceBinding.memberTypes();
            this.collectAnnotations(memberTypes);
            ++n3;
        }
    }

    public Set<TypeElement> getRootAnnotations() {
        return Collections.unmodifiableSet(this._annoToUnit.getKeySet());
    }

    @Override
    public boolean errorRaised() {
        return this._processingEnv.errorRaised();
    }

    @Override
    public Set<? extends Element> getElementsAnnotatedWith(TypeElement a2) {
        if (a2.getKind() != ElementKind.ANNOTATION_TYPE) {
            throw new IllegalArgumentException("Argument must represent an annotation type");
        }
        Binding annoBinding = ((TypeElementImpl)a2)._binding;
        if (0L != (annoBinding.getAnnotationTagBits() & 0x1000000000000L)) {
            HashSet<Element> annotatedElements = new HashSet<Element>(this._annoToUnit.getValues(a2));
            ReferenceBinding annoTypeBinding = (ReferenceBinding)annoBinding;
            for (TypeElement element : ElementFilter.typesIn(this.getRootElements())) {
                ReferenceBinding typeBinding = (ReferenceBinding)((TypeElementImpl)element)._binding;
                this.addAnnotatedElements(annoTypeBinding, typeBinding, annotatedElements);
            }
            return Collections.unmodifiableSet(annotatedElements);
        }
        return Collections.unmodifiableSet(this._annoToUnit.getValues(a2));
    }

    private void addAnnotatedElements(ReferenceBinding anno, ReferenceBinding type, Set<Element> result) {
        if (type.isClass() && this.inheritsAnno(type, anno)) {
            result.add(this._factory.newElement(type));
        }
        ReferenceBinding[] referenceBindingArray = type.memberTypes();
        int n2 = referenceBindingArray.length;
        int n3 = 0;
        while (n3 < n2) {
            ReferenceBinding element = referenceBindingArray[n3];
            this.addAnnotatedElements(anno, element, result);
            ++n3;
        }
    }

    private boolean inheritsAnno(ReferenceBinding element, ReferenceBinding anno) {
        ReferenceBinding searchedElement = element;
        do {
            AnnotationBinding[] annos;
            if (searchedElement instanceof ParameterizedTypeBinding) {
                searchedElement = ((ParameterizedTypeBinding)searchedElement).genericType();
            }
            AnnotationBinding[] annotationBindingArray = annos = Factory.getPackedAnnotationBindings(searchedElement.getAnnotations());
            int n2 = annos.length;
            int n3 = 0;
            while (n3 < n2) {
                AnnotationBinding annoBinding = annotationBindingArray[n3];
                if (annoBinding.getAnnotationType() == anno) {
                    return true;
                }
                ++n3;
            }
        } while ((searchedElement = searchedElement.superclass()) != null);
        return false;
    }

    @Override
    public Set<? extends Element> getElementsAnnotatedWith(Class<? extends Annotation> a2) {
        String canonicalName = a2.getCanonicalName();
        if (canonicalName == null) {
            throw new IllegalArgumentException("Argument must represent an annotation type");
        }
        TypeElement annoType = this._processingEnv.getElementUtils().getTypeElement(canonicalName);
        if (annoType == null) {
            return Collections.emptySet();
        }
        return this.getElementsAnnotatedWith(annoType);
    }

    @Override
    public Set<? extends Element> getRootElements() {
        if (this._units == null) {
            return Collections.emptySet();
        }
        if (this._rootElements == null) {
            HashSet<Element> elements = new HashSet<Element>(this._units.length);
            Object[] objectArray = this._units;
            int n2 = this._units.length;
            int n3 = 0;
            while (n3 < n2) {
                CompilationUnitDeclaration unit = objectArray[n3];
                if (unit.scope != null && unit.scope.topLevelTypes != null) {
                    SourceTypeBinding[] sourceTypeBindingArray = unit.scope.topLevelTypes;
                    int n4 = unit.scope.topLevelTypes.length;
                    int n5 = 0;
                    while (n5 < n4) {
                        SourceTypeBinding binding = sourceTypeBindingArray[n5];
                        Element element = this._factory.newElement(binding);
                        if (element == null) {
                            throw new IllegalArgumentException("Top-level type binding could not be converted to element: " + binding);
                        }
                        elements.add(element);
                        ++n5;
                    }
                }
                ++n3;
            }
            if (this._binaryTypes != null) {
                objectArray = this._binaryTypes;
                n2 = this._binaryTypes.length;
                n3 = 0;
                while (n3 < n2) {
                    Object typeBinding = objectArray[n3];
                    Element element = this._factory.newElement((Binding)typeBinding);
                    if (element == null) {
                        throw new IllegalArgumentException("Top-level type binding could not be converted to element: " + typeBinding);
                    }
                    elements.add(element);
                    ++n3;
                }
            }
            this._rootElements = elements;
        }
        return this._rootElements;
    }

    @Override
    public boolean processingOver() {
        return this._isLastRound;
    }
}

