/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jdt.internal.compiler.ast.FunctionalExpression;
import org.eclipse.jdt.internal.compiler.ast.LambdaExpression;
import org.eclipse.jdt.internal.compiler.ast.ReferenceExpression;
import org.eclipse.jdt.internal.compiler.lookup.ConstraintFormula;
import org.eclipse.jdt.internal.compiler.lookup.ConstraintTypeFormula;
import org.eclipse.jdt.internal.compiler.lookup.InferenceContext18;
import org.eclipse.jdt.internal.compiler.lookup.InferenceVariable;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class ConstraintExceptionFormula
extends ConstraintFormula {
    FunctionalExpression left;

    public ConstraintExceptionFormula(FunctionalExpression left, TypeBinding type) {
        this.left = left;
        this.right = type;
        this.relation = 7;
    }

    @Override
    public Object reduce(InferenceContext18 inferenceContext) {
        int i2;
        int nParam;
        Scope scope = inferenceContext.scope;
        if (!this.right.isFunctionalInterface(scope)) {
            return FALSE;
        }
        MethodBinding sam = this.right.getSingleAbstractMethod(scope, true);
        if (sam == null) {
            return FALSE;
        }
        if (this.left instanceof LambdaExpression) {
            if (((LambdaExpression)this.left).argumentsTypeElided()) {
                nParam = sam.parameters.length;
                i2 = 0;
                while (i2 < nParam) {
                    if (!sam.parameters[i2].isProperType(true)) {
                        return FALSE;
                    }
                    ++i2;
                }
            }
            if (sam.returnType != TypeBinding.VOID && !sam.returnType.isProperType(true)) {
                return FALSE;
            }
        } else if (!((ReferenceExpression)this.left).isExactMethodReference()) {
            nParam = sam.parameters.length;
            i2 = 0;
            while (i2 < nParam) {
                if (!sam.parameters[i2].isProperType(true)) {
                    return FALSE;
                }
                ++i2;
            }
            if (sam.returnType != TypeBinding.VOID && !sam.returnType.isProperType(true)) {
                return FALSE;
            }
        }
        ReferenceBinding[] thrown = sam.thrownExceptions;
        InferenceVariable[] e2 = new InferenceVariable[thrown.length];
        int n2 = 0;
        int i3 = 0;
        while (i3 < thrown.length) {
            if (!((TypeBinding)thrown[i3]).isProperType(true)) {
                e2[n2++] = (InferenceVariable)thrown[i3];
            }
            ++i3;
        }
        if (n2 == 0) {
            return TRUE;
        }
        TypeBinding[] ePrime = null;
        if (this.left instanceof LambdaExpression) {
            LambdaExpression lambda = ((LambdaExpression)this.left).resolveExpressionExpecting(this.right, inferenceContext.scope, inferenceContext);
            if (lambda == null) {
                return TRUE;
            }
            Set<TypeBinding> ePrimeSet = lambda.getThrownExceptions();
            ePrime = ePrimeSet.toArray(new TypeBinding[ePrimeSet.size()]);
        } else {
            MethodBinding method;
            ReferenceExpression referenceExpression = ((ReferenceExpression)this.left).resolveExpressionExpecting(this.right, scope, inferenceContext);
            MethodBinding methodBinding = method = referenceExpression != null ? referenceExpression.binding : null;
            if (method != null) {
                ePrime = method.thrownExceptions;
            }
        }
        if (ePrime == null) {
            return TRUE;
        }
        int m2 = ePrime.length;
        ArrayList<ConstraintTypeFormula> result = new ArrayList<ConstraintTypeFormula>();
        int i4 = 0;
        while (i4 < m2) {
            block26: {
                if (!ePrime[i4].isUncheckedException(false)) {
                    int j2 = 0;
                    while (j2 < thrown.length) {
                        if (!((TypeBinding)thrown[j2]).isProperType(true) || !ePrime[i4].isCompatibleWith(thrown[j2])) {
                            ++j2;
                            continue;
                        }
                        break block26;
                    }
                    j2 = 0;
                    while (j2 < n2) {
                        result.add(ConstraintTypeFormula.create(ePrime[i4], e2[j2], 2));
                        ++j2;
                    }
                }
            }
            ++i4;
        }
        int j3 = 0;
        while (j3 < n2) {
            inferenceContext.currentBounds.inThrows.add(e2[j3].prototype());
            ++j3;
        }
        return result.toArray(new ConstraintFormula[result.size()]);
    }

    @Override
    Collection<InferenceVariable> inputVariables(InferenceContext18 context) {
        if (this.left instanceof LambdaExpression) {
            if (this.right instanceof InferenceVariable) {
                return Collections.singletonList((InferenceVariable)this.right);
            }
            if (this.right.isFunctionalInterface(context.scope)) {
                LambdaExpression lambda = (LambdaExpression)this.left;
                MethodBinding sam = this.right.getSingleAbstractMethod(context.scope, true);
                HashSet<InferenceVariable> variables = new HashSet<InferenceVariable>();
                if (lambda.argumentsTypeElided()) {
                    int len = sam.parameters.length;
                    int i2 = 0;
                    while (i2 < len) {
                        sam.parameters[i2].collectInferenceVariables(variables);
                        ++i2;
                    }
                }
                if (sam.returnType != TypeBinding.VOID) {
                    sam.returnType.collectInferenceVariables(variables);
                }
                return variables;
            }
        } else if (this.left instanceof ReferenceExpression) {
            if (this.right instanceof InferenceVariable) {
                return Collections.singletonList((InferenceVariable)this.right);
            }
            if (this.right.isFunctionalInterface(context.scope)) {
                MethodBinding sam = this.right.getSingleAbstractMethod(context.scope, true);
                HashSet<InferenceVariable> variables = new HashSet<InferenceVariable>();
                int len = sam.parameters.length;
                int i3 = 0;
                while (i3 < len) {
                    sam.parameters[i3].collectInferenceVariables(variables);
                    ++i3;
                }
                sam.returnType.collectInferenceVariables(variables);
                return variables;
            }
        }
        return EMPTY_VARIABLE_LIST;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer().append('\u27e8');
        this.left.printExpression(4, buf);
        buf.append(" \u2286throws ");
        this.appendTypeName(buf, this.right);
        buf.append('\u27e9');
        return buf.toString();
    }
}

