/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.arrays;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.homelinux.elabor.arrays.ArrayHelper;
import org.homelinux.elabor.arrays.Condition;
import org.homelinux.elabor.arrays.FilterIterable;

public class Filter<T> {
    private List<Condition<T>> conditions;

    public Filter(Condition<T> condition) {
        this(ArrayHelper.buildArray(condition));
    }

    public Filter(List<Condition<T>> conditions) {
        this.conditions = conditions;
    }

    public List<T> filter(Iterable<? extends T> items) {
        ArrayList<T> list = new ArrayList<T>();
        for (T item : items) {
            if (!this.check(item)) continue;
            list.add(item);
        }
        return list;
    }

    public boolean check(T item) {
        boolean ok = true;
        Iterator<Condition<T>> iterator = this.conditions.iterator();
        while (ok && iterator.hasNext()) {
            Condition<T> condition = iterator.next();
            ok = condition.check(item);
        }
        return ok;
    }

    public static <T> int count(Iterable<T> items, Filter<T> filter) {
        int count = 0;
        for (T item : items) {
            if (!filter.check(item)) continue;
            ++count;
        }
        return count;
    }

    public Iterable<T> iterable(Iterable<T> items) {
        return new FilterIterable<T>(items, this);
    }
}

