/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.calendar;

import java.sql.Time;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.homelinux.elabor.calendar.Month;

public class ElaborCalendar
implements Comparable<ElaborCalendar> {
    private Calendar calendar = Calendar.getInstance();

    public ElaborCalendar(TimeZone timeZone) {
        this();
        this.calendar.setTimeZone(timeZone);
    }

    public ElaborCalendar() {
    }

    public ElaborCalendar(TimeZone timeZone, int anno, Month mese) {
        this(timeZone, anno, mese, 1);
    }

    public ElaborCalendar(int anno, Month mese) {
        this(anno, mese, 1);
    }

    public ElaborCalendar(TimeZone timeZone, int anno, Month mese, int giorno) {
        this(timeZone, anno, mese, giorno, 1);
    }

    public ElaborCalendar(int anno, Month mese, int giorno) {
        this(anno, mese, giorno, 1);
    }

    public ElaborCalendar(TimeZone timeZone, int anno, Month mese, int giorno, int ora) {
        this(timeZone, anno, mese, giorno, ora, 0);
    }

    public ElaborCalendar(int anno, Month mese, int giorno, int ora) {
        this(anno, mese, giorno, ora, 0);
    }

    public ElaborCalendar(TimeZone timeZone, int anno, Month mese, int giorno, int ora, int minuti) {
        this(timeZone);
        this.calendar.clear();
        this.setAnno(anno);
        this.setMese(mese);
        this.setGiorno(giorno);
        this.setOra(ora);
        this.calendar.set(12, minuti);
        this.calendar.set(13, 0);
        this.calendar.set(14, 0);
    }

    public ElaborCalendar(int anno, Month mese, int giorno, int ora, int minuti) {
        this();
        this.calendar.clear();
        this.setAnno(anno);
        this.setMese(mese);
        this.setGiorno(giorno);
        this.setOra(ora);
        this.calendar.set(12, minuti);
        this.calendar.set(13, 0);
        this.calendar.set(14, 0);
    }

    public ElaborCalendar(TimeZone timeZone, Date time) {
        this(timeZone);
        this.setDate(time);
    }

    public ElaborCalendar(Date time) {
        this();
        this.setDate(time);
    }

    public ElaborCalendar(int year) {
        this(year, Month.JANUARY);
    }

    public void setDate(Date time) {
        this.calendar.setTime(time);
    }

    public void setOra(int ora) {
        this.calendar.set(11, ora - 1);
    }

    public int getOra() {
        return this.calendar.get(11) + 1;
    }

    public int getOraSolare() {
        int ora = this.getOra();
        int dst = this.calendar.get(16);
        if (dst != 0) {
            ora = (ora + 22) % 24 + 1;
        }
        return ora;
    }

    public void setGiorno(int giorno) {
        this.calendar.set(5, giorno);
    }

    public int getGiorno() {
        return this.calendar.get(5);
    }

    public int getGiornoSolare() {
        int dst;
        int giorno = this.getGiorno();
        if (this.getOra() == 1 && (dst = this.calendar.get(16)) != 0) {
            Calendar cal = (Calendar)this.calendar.clone();
            cal.add(14, -dst);
            giorno = cal.get(5);
        }
        return giorno;
    }

    public void setMese(Month mese) {
        this.calendar.set(2, mese.ordinal());
    }

    public Month getMese() {
        return Month.values()[this.calendar.get(2)];
    }

    public Month getMeseSolare() {
        int dst;
        Month mese = this.getMese();
        if (this.getGiorno() == 1 && this.getOra() == 1 && (dst = this.calendar.get(16)) != 0) {
            Calendar cal = (Calendar)this.calendar.clone();
            cal.add(14, -dst);
            mese = Month.values()[cal.get(2)];
        }
        return mese;
    }

    public void setAnno(int anno) {
        this.calendar.set(1, anno);
    }

    public int getAnno() {
        return this.calendar.get(1);
    }

    public int getAnnoSolare() {
        int dst;
        int anno = this.getAnno();
        if (this.getMese() == Month.JANUARY && this.getGiorno() == 1 && this.getOra() == 1 && (dst = this.calendar.get(16)) != 0) {
            Calendar cal = (Calendar)this.calendar.clone();
            cal.add(14, -dst);
            anno = cal.get(1);
        }
        return anno;
    }

    public void addOre(int ore) {
        this.calendar.add(10, ore);
    }

    public void addOre(double durata) {
        int ore = (int)Math.floor(durata);
        int minuti = (int)Math.round((durata - (double)ore) * 60.0);
        this.addOre(ore);
        this.addMinuti(minuti);
    }

    public Date getDate() {
        return this.calendar.getTime();
    }

    public boolean isSolare() {
        return this.calendar.get(16) == 0;
    }

    public boolean isLegale() {
        return !this.isSolare();
    }

    public void setSolare() {
        this.calendar.set(16, 0);
    }

    public boolean isFirstSolare() {
        boolean is = false;
        if (this.isSolare()) {
            Calendar test = (Calendar)this.calendar.clone();
            test.add(11, -1);
            if (test.get(16) != 0) {
                is = true;
            }
        }
        return is;
    }

    public boolean isLastSolare() {
        boolean is = false;
        if (this.isSolare()) {
            Calendar test = (Calendar)this.calendar.clone();
            test.add(11, 1);
            if (test.get(16) != 0) {
                is = true;
            }
        }
        return is;
    }

    public boolean isLastLegale() {
        boolean is = false;
        if (this.isLegale()) {
            Calendar test = (Calendar)this.calendar.clone();
            test.add(11, 1);
            if (test.get(16) == 0) {
                is = true;
            }
        }
        return is;
    }

    public boolean isFirstLegale() {
        boolean is = false;
        if (this.isLegale()) {
            Calendar test = (Calendar)this.calendar.clone();
            test.add(11, -1);
            if (test.get(16) == 0) {
                is = true;
            }
        }
        return is;
    }

    public void addAnni(int nAnni) {
        this.calendar.add(1, nAnni);
    }

    public void addMesi(int nMesi) {
        this.calendar.add(2, nMesi);
    }

    public void addGiorni(int nGiorni) {
        this.calendar.add(5, nGiorni);
    }

    public void addMinuti(int minuti) {
        this.calendar.add(12, minuti);
    }

    public void addSecondi(int secondi) {
        this.calendar.add(13, secondi);
    }

    public void setMinuti(int minuti) {
        this.calendar.set(12, minuti);
    }

    public int getMinuti() {
        return this.calendar.get(12);
    }

    public boolean before(ElaborCalendar eCalendar) {
        return this.getDate().before(eCalendar.getDate());
    }

    public boolean after(ElaborCalendar eCalendar) {
        return this.getDate().after(eCalendar.getDate());
    }

    public int getIndex() {
        int anno = this.getAnno();
        Month mese = this.getMese();
        int giorno = this.getGiorno();
        ElaborCalendar dayStart = new ElaborCalendar(anno, mese, giorno);
        long millisenconds = this.getDate().getTime() - dayStart.getDate().getTime();
        return (int)Math.floor((double)millisenconds / 900000.0);
    }

    public void setIndex(int index) {
        this.setOra(1);
        this.setMinuti(0);
        this.addMinuti(index * 15);
    }

    public int getDayOfWeek() {
        return this.calendar.get(7);
    }

    public void setTime(Time time) {
        ElaborCalendar cal = new ElaborCalendar(time);
        int ora = cal.getOra();
        int min = cal.getMinuti();
        this.setOra(ora);
        this.setMinuti(min);
    }

    public void setSecondi(int secs) {
        this.calendar.set(13, secs);
    }

    public void resetTime() {
        this.calendar.set(11, 0);
        this.calendar.set(12, 0);
        this.calendar.set(13, 0);
        this.calendar.set(14, 0);
    }

    public static int getWeekOfYear(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(3);
    }

    public Date getLastDayOfMonth(Date data) {
        this.calendar.setTime(data);
        this.calendar.add(2, 1);
        this.calendar.set(5, 1);
        this.calendar.add(5, -1);
        Date lastDayOfMonth = this.calendar.getTime();
        return lastDayOfMonth;
    }

    @Override
    public int compareTo(ElaborCalendar o2) {
        return this.calendar.compareTo(o2.calendar);
    }

    public void setTimeZone(TimeZone timeZone) {
        this.calendar.setTimeZone(timeZone);
    }
}

